/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.expire;

import java.io.IOException;
import java.io.Serializable;
import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class FileWatcher
implements Serializable {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(FileWatcher.class.getName());
    public static final String EXCEPTION_URL_NOT_NULL = "URL can NOT be null here.";
    public static final String EXCEPTION_URL_NOT_IN_CACHE = "The URL you specified within the disk cache does not exist: ";
    private String url = "";
    private long lastModified = 0L;
    private String parent = "";

    public FileWatcher(String url) throws IOException {
        this(url, null);
    }

    public FileWatcher(String url, String parent) throws IOException {
        if (url == null) {
            throw new IOException(EXCEPTION_URL_NOT_NULL);
        }
        if (DiskCacheUtils.isRemote(url) && !DiskCacheUtils.isCached(url)) {
            throw new IOException(EXCEPTION_URL_NOT_IN_CACHE + url);
        }
        try {
            this.lastModified = JetspeedDiskCache.getInstance().getEntry(url).getLastModified();
        }
        catch (Throwable e) {
            logger.error("Unable to set last modified on url " + url, e);
        }
        this.url = url;
        this.parent = parent;
    }

    public boolean hasChanged() {
        try {
            if (this.lastModified == 0L) {
                DiskCacheEntry entry = JetspeedDiskCache.getInstance().getEntry(this.url);
                this.lastModified = entry.getLastModified();
                return false;
            }
            long recent = JetspeedDiskCache.getInstance().getEntry(this.url).getLastModified();
            if (recent == 0L || this.lastModified < recent) {
                if (logger.isInfoEnabled()) {
                    String message = "";
                    if (this.parent != null) {
                        message = this.parent + ":  ";
                    }
                    message = message + "REFRESH: Expiring Portlet because it's URL has been modified on disk -> " + this.url;
                    logger.info(message);
                }
                return true;
            }
        }
        catch (IOException e) {
            logger.error("Exception", e);
            return false;
        }
        return false;
    }
}

