/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.security.portlets;

import org.apache.ecs.ConcreteElement;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.security.portlets.CacheablePortletWrapper;
import org.apache.jetspeed.portal.security.portlets.CacheableStatefulPortletWrapper;
import org.apache.jetspeed.portal.security.portlets.StatefulPortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.PortletStats;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.portletcache.Cacheable;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;

public class PortletWrapper
implements Portlet {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(PortletWrapper.class.getName());
    private Portlet wrappedPortlet = null;
    private PortalResource portalResource = null;
    private ConcreteElement content = null;

    public PortletWrapper(Portlet inner) {
        this.wrappedPortlet = inner;
        this.portalResource = new PortalResource(this.wrappedPortlet);
    }

    public final String getName() {
        return this.wrappedPortlet.getName();
    }

    public final void setName(String name) {
        this.wrappedPortlet.setName(name);
    }

    public final PortletConfig getPortletConfig() {
        return this.wrappedPortlet.getPortletConfig();
    }

    public final void setPortletConfig(PortletConfig pc) {
        this.wrappedPortlet.setPortletConfig(pc);
    }

    public ConcreteElement getContent(RunData rundata) {
        if (this.checkPermission(rundata, "view")) {
            if (PortletStats.isEnabled()) {
                long start = System.currentTimeMillis();
                this.content = this.wrappedPortlet.getContent(rundata);
                long time = System.currentTimeMillis() - start;
                PortletStats.logAccess(rundata, this, "200", time);
            } else {
                this.content = this.wrappedPortlet.getContent(rundata);
            }
            return this.content;
        }
        if (PortletStats.isEnabled()) {
            PortletStats.logAccess(rundata, this, "401");
        }
        return new JetspeedClearElement(Localization.getString((RunData)rundata, (String)"SECURITY_NO_ACCESS_TO_PORTLET"));
    }

    public String getDescription() {
        return this.wrappedPortlet.getDescription();
    }

    public String getDescription(String instanceDescription) {
        return this.wrappedPortlet.getDescription(instanceDescription);
    }

    public void setDescription(String description) {
        this.wrappedPortlet.setDescription(description);
    }

    public String getImage(String instanceImage) {
        return this.wrappedPortlet.getImage(instanceImage);
    }

    public void setImage(String image) {
        this.wrappedPortlet.setImage(image);
    }

    public String getTitle() {
        return this.wrappedPortlet.getTitle();
    }

    public String getTitle(String instanceTitle) {
        return this.wrappedPortlet.getTitle(instanceTitle);
    }

    public void setTitle(String title) {
        this.wrappedPortlet.setTitle(title);
    }

    public boolean getAllowEdit(RunData rundata) {
        return this.checkPermission(rundata, "customize");
    }

    public boolean getAllowView(RunData rundata) {
        if (this.checkPermission(rundata, "view")) {
            return this.wrappedPortlet.getAllowView(rundata);
        }
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return this.checkPermission(rundata, "maximize");
    }

    public void init() throws PortletException {
        this.wrappedPortlet.init();
    }

    public long getCreationTime() {
        return this.wrappedPortlet.getCreationTime();
    }

    public void setCreationTime(long creationTime) {
        this.wrappedPortlet.setCreationTime(creationTime);
    }

    public boolean supportsType(MimeType mimeType) {
        return this.wrappedPortlet.supportsType(mimeType);
    }

    protected boolean checkPermission(RunData rundata, String permissionName) {
        try {
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
            this.portalResource.setOwner(jsLink.getUserName());
            JetspeedLinkFactory.putInstance(jsLink);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
            this.portalResource.setOwner(null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checking for Portlet permission: " + permissionName + " for portlet: " + this.wrappedPortlet.getName() + " Owner = " + this.portalResource.getOwner());
        }
        return JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), this.portalResource, permissionName);
    }

    public boolean isShowTitleBar(RunData rundata) {
        if (this.wrappedPortlet.getPortletConfig() != null) {
            return Boolean.valueOf(this.wrappedPortlet.getPortletConfig().getInitParameter("_showtitlebar", "true"));
        }
        return this.getAttribute("_showtitlebar", "true", rundata).equals("true");
    }

    public String getAttribute(String attrName, String attrDefValue, RunData rundata) {
        if (this.checkPermission(rundata, "view")) {
            return this.wrappedPortlet.getAttribute(attrName, attrDefValue, rundata);
        }
        return this.wrappedPortlet.getAttribute(attrName, attrDefValue, rundata);
    }

    public void setAttribute(String attrName, String attrValue, RunData rundata) {
        if (this.checkPermission(rundata, "view")) {
            this.wrappedPortlet.setAttribute(attrName, attrValue, rundata);
        } else {
            this.wrappedPortlet.setAttribute(attrName, attrValue, rundata);
        }
    }

    public PortletInstance getInstance(RunData rundata) {
        return this.wrappedPortlet.getInstance(rundata);
    }

    public static Portlet wrap(Portlet aPortlet) {
        if (aPortlet instanceof PortletState) {
            if (aPortlet instanceof Cacheable) {
                return new CacheableStatefulPortletWrapper(aPortlet);
            }
            return new StatefulPortletWrapper(aPortlet);
        }
        if (aPortlet instanceof Cacheable) {
            return new CacheablePortletWrapper(aPortlet);
        }
        return new PortletWrapper(aPortlet);
    }

    public String getID() {
        return this.wrappedPortlet.getID();
    }

    public void setID(String id) {
        this.wrappedPortlet.setID(id);
    }

    public boolean providesCustomization() {
        return this.wrappedPortlet.providesCustomization();
    }

    public Portlet getPortlet() {
        return this.wrappedPortlet;
    }
}

