/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.jsp.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.template.TemplateLink;

public class DynamicURITag
extends TagSupport {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DynamicURITag.class.getName());
    private String screen;
    private String template;
    private String action;

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int doStartTag() throws JspException {
        RunData data = (RunData)this.pageContext.getAttribute("rundata", 2);
        TemplateLink uri = new TemplateLink(data);
        if (this.template != null) {
            uri.setPage(this.template);
        }
        if (this.screen != null) {
            uri.setScreen(this.screen);
        }
        if (this.action != null) {
            uri.setAction(this.action);
        }
        try {
            if (uri != null) {
                this.pageContext.getOut().print(uri.toString());
            }
        }
        catch (Exception e) {
            String message = "Error processing DynamicUriTag, parameter: screen='" + this.screen + "', action='" + this.action + "'";
            logger.error(message, e);
            try {
                data.getOut().print(message);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return 1;
    }
}

