/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.portaltoolkit;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Control;
import org.apache.jetspeed.om.profile.Controller;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.MetaInfo;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.profile.Skin;
import org.apache.jetspeed.om.registry.PortletControlEntry;
import org.apache.jetspeed.om.registry.PortletControllerEntry;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.SecurityEntry;
import org.apache.jetspeed.om.registry.SkinEntry;
import org.apache.jetspeed.portal.BasePortletConfig;
import org.apache.jetspeed.portal.BasePortletControlConfig;
import org.apache.jetspeed.portal.BasePortletControllerConfig;
import org.apache.jetspeed.portal.BasePortletSet;
import org.apache.jetspeed.portal.BasePortletSkin;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.portaltoolkit.PortalToolkitService;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.util.JetspeedException;
import org.apache.jetspeed.util.MetaData;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class JetspeedPortalToolkitService
extends TurbineBaseService
implements PortalToolkitService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedPortalToolkitService.class.getName());
    private String defaultControl = null;
    private String defaultController = null;
    private String defaultSkin = null;
    private String defaultUserSecurityRef = null;
    private String defaultAnonSecurityRef = null;
    private String defaultRoleSecurityRef = null;
    private String defaultGroupSecurityRef = null;

    public void init(ServletConfig conf) throws InitializationException {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PortalToolkit");
        this.defaultControl = serviceConf.getString("default.control");
        this.defaultController = serviceConf.getString("default.controller");
        this.defaultSkin = serviceConf.getString("default.skin");
        this.defaultUserSecurityRef = serviceConf.getString("default.user.security.ref");
        this.defaultAnonSecurityRef = serviceConf.getString("default.anon.security.ref");
        this.defaultRoleSecurityRef = serviceConf.getString("default.role.security.ref");
        this.defaultGroupSecurityRef = serviceConf.getString("default.group.security.ref");
        this.setInit(true);
    }

    public PortletControl getControl(String name) {
        PortletControl pc = null;
        PortletControlEntry entry = null;
        if (name != null) {
            entry = (PortletControlEntry)Registry.getEntry(Registry.PORTLET_CONTROL, name);
        }
        Hashtable params = null;
        try {
            if (entry == null) {
                if (name != null) {
                    pc = (PortletControl)Class.forName(name).newInstance();
                    params = new Hashtable();
                }
            } else {
                pc = (PortletControl)Class.forName(entry.getClassname()).newInstance();
                params = entry.getParameterMap();
            }
        }
        catch (Exception e) {
            logger.error("Unable to instanciate control " + name + ", using default", e);
        }
        if (pc == null && this.defaultControl != null && !this.defaultControl.equals(name)) {
            return this.getControl(this.defaultControl);
        }
        BasePortletControlConfig pcConf = new BasePortletControlConfig();
        pcConf.setName(name);
        pcConf.setInitParameters(params);
        pc.setConfig(pcConf);
        return pc;
    }

    public PortletControl getControl(Control control) {
        PortletControl pc = null;
        if (control != null) {
            pc = this.getControl(control.getName());
            pc.getConfig().getInitParameters().putAll(JetspeedPortalToolkitService.getParameters(control));
        } else if (this.defaultControl != null) {
            pc = this.getControl(this.defaultControl);
        }
        return pc;
    }

    protected PortletControl getControl(Control control, PortletEntry entry) {
        PortletControl pc = null;
        if (control != null) {
            pc = this.getControl(control.getName());
            pc.getConfig().getInitParameters().putAll(JetspeedPortalToolkitService.getParameters(control));
        } else {
            org.apache.jetspeed.om.registry.Parameter dftPortletCtrl = entry.getParameter("_control");
            if (dftPortletCtrl != null) {
                pc = this.getControl(dftPortletCtrl.getValue());
            } else if (this.defaultControl != null) {
                pc = this.getControl(this.defaultControl);
            }
        }
        return pc;
    }

    public PortletController getController(String name) {
        PortletController pc = null;
        PortletControllerEntry entry = null;
        if (name != null) {
            entry = (PortletControllerEntry)Registry.getEntry(Registry.PORTLET_CONTROLLER, name);
        }
        Hashtable params = null;
        try {
            if (entry == null) {
                if (name != null) {
                    pc = (PortletController)Class.forName(name).newInstance();
                    params = new Hashtable();
                }
            } else {
                pc = (PortletController)Class.forName(entry.getClassname()).newInstance();
                params = entry.getParameterMap();
            }
        }
        catch (Exception e) {
            logger.error("Unable to instanciate controller " + name + ", using default");
        }
        if (pc == null && this.defaultController != null && !this.defaultController.equals(name)) {
            return this.getController(this.defaultController);
        }
        BasePortletControllerConfig pcConf = new BasePortletControllerConfig();
        pcConf.setName(name);
        pcConf.setInitParameters(params);
        pc.setConfig(pcConf);
        pc.init();
        return pc;
    }

    public PortletController getController(Controller controller) {
        PortletController pc = null;
        if (controller != null) {
            pc = this.getController(controller.getName());
            pc.getConfig().getInitParameters().putAll(JetspeedPortalToolkitService.getParameters(controller));
        } else if (this.defaultController != null) {
            pc = this.getController(this.defaultController);
        }
        pc.init();
        return pc;
    }

    public PortletSkin getSkin(String name) {
        JetspeedRunDataService jrds;
        JetspeedRunData jData;
        BasePortletSkin result = new BasePortletSkin();
        SkinEntry entry = null;
        if (name != null) {
            entry = (SkinEntry)Registry.getEntry(Registry.SKIN, name);
        }
        if (entry == null) {
            entry = (SkinEntry)Registry.getEntry(Registry.SKIN, this.defaultSkin);
        }
        if (entry != null) {
            result.setName(entry.getName());
            result.putAll(entry.getParameterMap());
        }
        if ((jData = (jrds = (JetspeedRunDataService)((Object)ServiceUtil.getServiceByName("RunDataService"))).getCurrentRunData()) != null) {
            result.setCapabilityMap(jData.getCapability());
        }
        return result;
    }

    public PortletSkin getSkin(Skin skin) {
        PortletSkin result = null;
        String name = null;
        if (skin != null) {
            name = skin.getName();
            result = this.getSkin(name);
            result.putAll(JetspeedPortalToolkitService.getParameters(skin));
        }
        return result;
    }

    public PortletSet getSet(Portlets portlets) {
        VariableInteger lastID = new VariableInteger(0);
        return this.getSet(portlets, new VariableInteger(0));
    }

    protected PortletSet getSet(Portlets portlets, VariableInteger theCount) {
        BasePortletSet set = new BasePortletSet();
        PortletController controller = this.getController(portlets.getController());
        set.setController(controller);
        String name = portlets.getName();
        if (name != null) {
            set.setName(name);
        } else {
            set.setName(String.valueOf(theCount.getValue()));
        }
        set.setID(portlets.getId());
        theCount.setValue(theCount.getValue() + 1);
        set.setPortletConfig(this.getPortletConfig(portlets));
        Iterator it = portlets.getPortletsIterator();
        while (it.hasNext()) {
            Portlets subset = (Portlets)it.next();
            subset.setParentPortlets(portlets);
            Map constraints = JetspeedPortalToolkitService.getParameters(subset.getLayout());
            int position = JetspeedPortalToolkitService.getPosition(subset.getLayout());
            set.addPortlet(this.getSet(subset, theCount), controller.getConstraints(constraints), position);
        }
        Iterator eit = portlets.getEntriesIterator();
        while (eit.hasNext()) {
            try {
                Entry psmlEntry = (Entry)eit.next();
                PortletEntry entry = (PortletEntry)Registry.getEntry(Registry.PORTLET, psmlEntry.getParent());
                if (entry != null) {
                    Portlet p = PortletFactory.getPortlet(psmlEntry);
                    if (p == null) continue;
                    Map constraints = JetspeedPortalToolkitService.getParameters(psmlEntry.getLayout());
                    int position = JetspeedPortalToolkitService.getPosition(psmlEntry.getLayout());
                    PortletControl control = this.getControl(psmlEntry.getControl(), entry);
                    set.addPortlet(this.initControl(control, p), controller.getConstraints(constraints), position);
                    continue;
                }
                logger.error(" The portlet " + psmlEntry.getParent() + " does not exist in the Registry ");
            }
            catch (JetspeedException e) {
                logger.error("Exception", e);
            }
        }
        if (portlets.getControl() != null) {
            PortletControl control = this.getControl(portlets.getControl());
            return this.initControl(control, set);
        }
        set.sortPortletSet();
        return set;
    }

    protected PortletControl initControl(PortletControl pc, Portlet portlet) {
        if (portlet == null) {
            throw new IllegalArgumentException("Portlet not specified");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PortletControl not specified");
        }
        pc.init(portlet);
        return pc;
    }

    protected PortletConfig getPortletConfig(Portlets portlets) {
        BasePortletConfig pc = new BasePortletConfig();
        pc.setName(portlets.getName());
        pc.setInitParameters(JetspeedPortalToolkitService.getParameters(portlets));
        pc.setPortletSkin(this.getSkin(this.findSkin(portlets)));
        pc.setSecurityRef(portlets.getSecurityRef());
        pc.setMetainfo(JetspeedPortalToolkitService.getMetaData(portlets));
        return pc;
    }

    protected static Map getParameters(Portlets portlets) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (portlets != null) {
            Parameter[] props = portlets.getParameter();
            for (int i = 0; i < props.length; ++i) {
                hash.put(props[i].getName(), props[i].getValue());
            }
        }
        return hash;
    }

    protected static Map getParameters(Control control) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (control != null) {
            Parameter[] params = control.getParameter();
            for (int i = 0; i < params.length; ++i) {
                hash.put(params[i].getName(), params[i].getValue());
            }
        }
        return hash;
    }

    protected static Map getParameters(Controller controller) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (controller != null) {
            Parameter[] params = controller.getParameter();
            for (int i = 0; i < params.length; ++i) {
                hash.put(params[i].getName(), params[i].getValue());
            }
        }
        return hash;
    }

    protected static Map getParameters(Layout layout) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (layout != null) {
            Parameter[] props = layout.getParameter();
            for (int i = 0; i < props.length; ++i) {
                hash.put(props[i].getName(), props[i].getValue());
            }
        }
        return hash;
    }

    protected static Map getParameters(Skin skin) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (skin != null) {
            Parameter[] props = skin.getParameter();
            for (int i = 0; i < props.length; ++i) {
                hash.put(props[i].getName(), props[i].getValue());
            }
        }
        return hash;
    }

    protected static MetaData getMetaData(Portlets portlets) {
        MetaData data = new MetaData();
        MetaInfo meta = portlets.getMetaInfo();
        if (meta != null) {
            if (meta.getTitle() != null) {
                data.setTitle(meta.getTitle());
            }
            if (meta.getDescription() != null) {
                data.setDescription(meta.getDescription());
            }
            if (meta.getImage() != null) {
                data.setImage(meta.getImage());
            }
        }
        return data;
    }

    protected static int getPosition(Layout layout) {
        int pos = -1;
        try {
            pos = (int)layout.getPosition();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return pos;
    }

    public Portlets getReference(String locatorPath) {
        ProfileLocator locator = Profiler.createLocator();
        locator.createFromPath(locatorPath);
        String id = locator.getId();
        try {
            Profile profile = Profiler.getProfile(locator);
            PSMLDocument doc = profile.getDocument();
            if (doc == null) {
                return null;
            }
            Portlets portlets = doc.getPortlets();
            return portlets;
        }
        catch (Exception e) {
            logger.error("Exception", e);
            return null;
        }
    }

    protected String findSkin(Portlets portlets) {
        if (portlets.getSkin() != null) {
            return portlets.getSkin().getName();
        }
        if (portlets.getParentPortlets() != null) {
            return this.findSkin(portlets.getParentPortlets());
        }
        return this.defaultSkin;
    }

    public SecurityReference getDefaultSecurityRef(Profile profile) {
        String type = null;
        if (profile.getUserName() != null) {
            type = profile.getAnonymous() ? "anon" : "user";
        } else if (profile.getRoleName() != null) {
            type = "role";
        } else if (profile.getGroupName() != null) {
            type = "group";
        }
        return this.getDefaultSecurityRef(type);
    }

    public SecurityReference getDefaultSecurityRef(String type) {
        BaseSecurityReference result = null;
        SecurityEntry entry = null;
        String defaultRef = null;
        if (type.equals("user")) {
            defaultRef = this.defaultUserSecurityRef;
        } else if (type.equals("anon")) {
            defaultRef = this.defaultAnonSecurityRef;
        } else if (type.equals("role")) {
            defaultRef = this.defaultRoleSecurityRef;
        } else if (type.equals("group")) {
            defaultRef = this.defaultGroupSecurityRef;
        }
        if (defaultRef != null) {
            entry = (SecurityEntry)((Object)Registry.getEntry(Registry.SECURITY, defaultRef));
            if (logger.isDebugEnabled()) {
                logger.debug("JetspeedPortalToolkit: default security for type: " + type + " is " + defaultRef);
            }
            if (entry != null) {
                result = new BaseSecurityReference();
                result.setParent(entry.getName());
                if (logger.isDebugEnabled()) {
                    logger.debug("JetspeedPortalToolkit: default security for type: " + type + " was set to " + entry.getName());
                }
            }
        }
        return result;
    }

    protected static class VariableInteger {
        int value;

        public VariableInteger(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

