/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.resources;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResourceService;

public class VariableResourcesService
extends TurbineResourceService {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(VariableResourcesService.class.getName());
    public static final String WEBAPP_DIR = "webapp.dir";
    public static final String WEB_DIR = "web.dir";
    public static final String JVM_DIR = "jvm.dir";
    public static final String START_TOKEN = "${";
    public static final String END_TOKEN = "}";
    private Hashtable variables = null;
    private Hashtable strings = null;
    private Hashtable vectors = null;
    private Hashtable arrays = null;

    public void init() {
        while (!this.getInit()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                logger.info("VariableResources service: Waiting for init()...");
            }
        }
    }

    public synchronized void init(ServletConfig config) throws InitializationException {
        if (this.getInit()) {
            return;
        }
        String props = config.getInitParameter("properties");
        this.variables = new Hashtable();
        this.strings = new Hashtable();
        this.vectors = new Hashtable();
        this.arrays = new Hashtable();
        this.initVariables(config);
        super.init(config);
    }

    private void initVariables(ServletConfig config) {
        ServletContext ctxt = config.getServletContext();
        String path = ctxt.getRealPath("/");
        if (path != null) {
            this.variables.put(WEBAPP_DIR, VariableResourcesService.normalizePath(path));
        }
        try {
            path = new File(".").getCanonicalPath();
            if (path != null) {
                this.variables.put(JVM_DIR, VariableResourcesService.normalizePath(path));
            }
        }
        catch (IOException e) {
            logger.error("Exception define JVM app dir", e);
        }
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            String paramValue = config.getInitParameter(paramName);
            this.variables.put(paramName.toLowerCase(), paramValue);
        }
    }

    private static String normalizePath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVariables(Hashtable vars) {
        VariableResourcesService variableResourcesService = this;
        synchronized (variableResourcesService) {
            this.variables = vars;
            this.strings = new Hashtable();
            this.vectors = new Hashtable();
            this.arrays = new Hashtable();
        }
    }

    protected String substituteString(String base) {
        if (base == null) {
            return null;
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String var = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            var = base.substring(begin + START_TOKEN.length(), end);
            if (this.variables.get(var) != null) {
                result.append(this.variables.get(var));
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    public String getString(String name) {
        String std = (String)this.strings.get(name);
        if (std == null && (std = this.substituteString(super.getString(name))) != null) {
            this.strings.put(name, std);
        }
        return std;
    }

    public String getString(String name, String def) {
        String std = this.getString(name);
        if (std == null) {
            std = this.substituteString(def);
        }
        return std;
    }

    public String[] getStringArray(String name) {
        String[] std = (String[])this.arrays.get(name);
        if (std == null && (std = super.getStringArray(name)) != null) {
            for (int i = 0; i < std.length; ++i) {
                std[i] = this.substituteString(std[i]);
            }
            this.arrays.put(name, std);
        }
        return std;
    }

    public Vector getVector(String name) {
        Vector<String> std = (Vector<String>)this.vectors.get(name);
        if (std == null && (std = super.getVector(name)) != null) {
            Vector<String> newstd = new Vector<String>();
            Enumeration en = std.elements();
            while (en.hasMoreElements()) {
                newstd.addElement(this.substituteString((String)en.nextElement()));
            }
            std = newstd;
            this.vectors.put(name, std);
        }
        return std;
    }

    public Vector getVector(String name, Vector def) {
        Vector<String> std = this.getVector(name);
        if (std == null && def != null) {
            std = new Vector<String>();
            Enumeration en = def.elements();
            while (en.hasMoreElements()) {
                std.addElement(this.substituteString((String)en.nextElement()));
            }
        }
        return std;
    }

    public ResourceService getResources(String prefix) {
        Configuration config = this.getConfiguration().subset(prefix);
        if (config == null) {
            return null;
        }
        VariableResourcesService res = new VariableResourcesService();
        try {
            res.init(config);
        }
        catch (Exception e) {
            logger.error("Unable to init resources for " + prefix, e);
        }
        res.setVariables(this.variables);
        return res;
    }
}

