/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.services.search.ObjectHandler;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;

public class HandlerFactory {
    private static final Map handlerCache = Collections.synchronizedMap(new HashMap());

    public static ObjectHandler getHandler(Object obj) throws Exception {
        return HandlerFactory.getHandler(obj.getClass().getName());
    }

    public static ObjectHandler getHandler(String className) throws Exception {
        ObjectHandler handler = null;
        if (handlerCache.containsKey(className)) {
            handler = (ObjectHandler)handlerCache.get(className);
        } else {
            ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("Search");
            String handlerClass = serviceConf.getString("document." + className);
            if (handlerClass == null) {
                throw new Exception("No handler was found for document type: " + className);
            }
            handler = (ObjectHandler)Class.forName(handlerClass).newInstance();
            handlerCache.put(className, handler);
        }
        return handler;
    }
}

