/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.services.security;

import java.util.Iterator;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.jetspeed.services.security.RoleManagement;
import org.apache.turbine.services.TurbineServices;

public abstract class JetspeedRoleManagement {
    public String SERVICE_NAME = "RoleManagement";

    protected static RoleManagement getService() {
        return (RoleManagement)TurbineServices.getInstance().getService("RoleManagement");
    }

    public static Iterator getRoles(String username) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getService().getRoles(username);
    }

    public static Iterator getRoles() throws JetspeedSecurityException {
        return JetspeedRoleManagement.getService().getRoles();
    }

    public static void addRole(Role role) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().addRole(role);
    }

    public static void saveRole(Role role) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().saveRole(role);
    }

    public static void removeRole(String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().removeRole(rolename);
    }

    public static void grantRole(String username, String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().grantRole(username, rolename);
    }

    public static void grantRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().grantRole(username, rolename, groupname);
    }

    public static void revokeRole(String username, String rolename) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().revokeRole(username, rolename);
    }

    public static void revokeRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        JetspeedRoleManagement.getService().revokeRole(username, rolename, groupname);
    }

    public static boolean hasRole(String username, String rolename) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getService().hasRole(username, rolename);
    }

    public static boolean hasRole(String username, String rolename, String groupname) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getService().hasRole(username, rolename, groupname);
    }

    public static Role getRole(String rolename) throws JetspeedSecurityException {
        return JetspeedRoleManagement.getService().getRole(rolename);
    }
}

