/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.File;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class DirectoryUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DirectoryUtils.class.getName());

    public static void main(String[] args) {
        DirectoryUtils.rmdir(args[0]);
    }

    public static final boolean rmdir(String directory) {
        try {
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                dir.delete();
                return true;
            }
            DirectoryUtils.deleteTraversal(directory);
            dir.delete();
            return true;
        }
        catch (Exception e) {
            logger.error("Error in rmdir utility:", e);
            return false;
        }
    }

    private static void deleteTraversal(String path) {
        File file = new File(path);
        if (file.isFile()) {
            try {
                file.delete();
            }
            catch (Exception e) {
                logger.error("Failed to Delete file: " + path + " : ", e);
                file.deleteOnExit();
            }
        } else if (file.isDirectory()) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] list = file.list();
            for (int ix = 0; list != null && ix < list.length; ++ix) {
                DirectoryUtils.deleteTraversal(path + list[ix]);
            }
            try {
                file.delete();
            }
            catch (Exception e) {
                logger.error("Failed to Delete directory: " + path + " : ", e);
                file.deleteOnExit();
            }
        }
    }
}

