/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileCopy {
    public static final int BUFFER_SIZE = 4096;

    public static final void copy(String source, String destination) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        FileCopy.copyStream(input, output, buffer);
        input.close();
        output.close();
    }

    public static final void copyFromURL(String source, String destination) throws IOException {
        byte[] buffer = new byte[4096];
        URL url = new URL(source);
        BufferedInputStream input = new BufferedInputStream(new DataInputStream(url.openStream()));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        FileCopy.copyStream(input, output, buffer);
        input.close();
        output.close();
    }

    public static final void copyStream(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int bytesRead;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }
}

