/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class LineCounter {
    int count = 0;

    public static void main(String[] args) {
        LineCounter lc = new LineCounter();
        int count = 0;
        int totalCount = 0;
        for (int ix = 0; ix < args.length; ++ix) {
            count = lc.run(args[ix]);
            System.out.println("Count for path [" + args[ix] + "] = " + count);
            totalCount += count;
        }
        System.out.println("Total Count = " + totalCount);
    }

    public int run(String path) {
        System.out.println("Running LineCounter for " + path);
        this.count = 0;
        return this.traverse(path);
    }

    private int traverse(String path) {
        File file = new File(path);
        if (file.isFile()) {
            try {
                String name = file.getName();
                if (name.endsWith("java")) {
                    this.count += this.countFile(file);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to count file: " + path + " : " + e.toString());
            }
        } else if (file.isDirectory()) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String[] list = file.list();
            for (int ix = 0; list != null && ix < list.length; ++ix) {
                this.traverse(path + list[ix]);
            }
        }
        return this.count;
    }

    private int countFile(File file) throws FileNotFoundException, IOException {
        String s;
        FileReader reader = new FileReader(file);
        BufferedReader br = new BufferedReader(reader);
        int mycount = 0;
        while ((s = br.readLine()) != null) {
            if (s.length() <= 0) continue;
            ++mycount;
        }
        return mycount;
    }
}

