/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.xml.JetspeedXMLEntityResolver;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleTransform {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SimpleTransform.class.getName());

    public static String transform(Document doc, String stylesheet_url) throws SAXException {
        return SimpleTransform.transform(doc, stylesheet_url, null);
    }

    public static String transform(Document doc, String stylesheet_url, Map params) throws SAXException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            logger.error("SimpleTransform: nobody told you that we need a SAX Transformer?");
            throw new SAXException("Invalid SAX Tranformer");
        }
        try {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            TemplatesHandler templatesHandler = saxTFactory.newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(templatesHandler);
            reader.setEntityResolver(new JetspeedXMLEntityResolver());
            InputSource xstyle = new InputSource(JetspeedDiskCache.getInstance().getEntry(stylesheet_url).getReader());
            xstyle.setSystemId(stylesheet_url);
            reader.parse(xstyle);
            Templates templates = templatesHandler.getTemplates();
            TransformerHandler handler = saxTFactory.newTransformerHandler(templates);
            reader.setContentHandler(handler);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            Transformer processor = handler.getTransformer();
            if (params != null) {
                for (String name : params.keySet()) {
                    String value = (String)params.get(name);
                    processor.setParameter(name, value);
                }
            }
            StringWriter pw = new StringWriter();
            processor.transform(new DOMSource(doc), new StreamResult(pw));
            try {
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                logger.error("Exception", e);
            }
            return pw.toString();
        }
        catch (Exception e) {
            logger.error("Invalid SAX Transformer: ", e);
            throw new SAXException("problem in SAX transform: " + e.toString());
        }
    }

    public static String transform(String url, String stylesheet_url) throws SAXException {
        return SimpleTransform.transform(url, stylesheet_url, null);
    }

    public static String transform(String url, String stylesheet_url, Map params) throws SAXException {
        InputSource style;
        InputSource in;
        try {
            in = new InputSource(JetspeedDiskCache.getInstance().getEntry(url).getReader());
            style = new InputSource(JetspeedDiskCache.getInstance().getEntry(stylesheet_url).getReader());
        }
        catch (IOException e) {
            logger.error("Exception", e);
            in = new InputSource(url);
            style = new InputSource(stylesheet_url);
        }
        if (logger.isInfoEnabled()) {
            logger.info("SimpleTransform:  transforming url: " + url + " with stylesheet: " + stylesheet_url);
        }
        in.setSystemId(url);
        style.setSystemId(stylesheet_url);
        return SimpleTransform.transform(in, style, params);
    }

    public static String transform(InputSource content, InputSource stylesheet, Map params) throws SAXException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            logger.error("SimpleTransform: nobody told you that we need a SAX Transformer?");
            throw new SAXException("Invalid SAX Tranformer");
        }
        try {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            TemplatesHandler templatesHandler = saxTFactory.newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(templatesHandler);
            reader.parse(stylesheet);
            Templates templates = templatesHandler.getTemplates();
            TransformerHandler handler = saxTFactory.newTransformerHandler(templates);
            reader.setContentHandler(handler);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            Transformer processor = handler.getTransformer();
            if (params != null) {
                for (String name : params.keySet()) {
                    String value = (String)params.get(name);
                    processor.setParameter(name, new XString(value));
                }
            }
            StringWriter pw = new StringWriter();
            processor.transform(new SAXSource(content), new StreamResult(pw));
            try {
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                logger.error("Exception", e);
            }
            return pw.toString();
        }
        catch (Exception e) {
            logger.error("Invalid SAX Transformer: ", e);
            throw new SAXException("problem in SAX transform: " + e.toString());
        }
    }

    public static Reader SAXTransform(String content_url, String stylesheet_url, Map params) throws IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (!tFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            logger.error("SimpleTransform: nobody told you that we need a SAX Transformer?");
            throw new IOException("Invalid SAX Tranformer");
        }
        try {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            TemplatesHandler templatesHandler = saxTFactory.newTemplatesHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(templatesHandler);
            reader.setEntityResolver(new JetspeedXMLEntityResolver());
            InputSource style = new InputSource(JetspeedDiskCache.getInstance().getEntry(stylesheet_url).getReader());
            style.setSystemId(stylesheet_url);
            InputSource xstyle = style;
            reader.parse(xstyle);
            Templates templates = templatesHandler.getTemplates();
            TransformerHandler handler = saxTFactory.newTransformerHandler(templates);
            reader.setContentHandler(handler);
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            final Transformer processor = handler.getTransformer();
            if (params != null) {
                for (String name : params.keySet()) {
                    String value = (String)params.get(name);
                    processor.setParameter(name, new XString(value));
                }
            }
            PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream(pis);
            try {
                final OutputStreamWriter pw = new OutputStreamWriter((OutputStream)pos, "utf-8");
                InputSource is = new InputSource(JetspeedDiskCache.getInstance().getEntry(content_url).getReader());
                is.setSystemId(content_url);
                final SAXSource xinput = new SAXSource(is);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        logger.debug("Starting SAX thread...");
                        try {
                            processor.transform(xinput, new StreamResult(pw));
                            pw.close();
                            logger.debug("...ending SAX thread.");
                        }
                        catch (Exception se) {
                            logger.debug("Error in SAXTransform" + se.toString(), se);
                        }
                    }
                });
                t.start();
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("Need utf-8 encoding to SAXTransform", uee);
            }
            return new InputStreamReader((InputStream)pis, "utf-8");
        }
        catch (Exception e) {
            logger.error("Invalid SAX Transformer:", e);
            throw new IOException("problem in SAX transform: " + e.toString());
        }
    }

    static {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

