/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.parser;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.jetspeed.util.ValidationException;
import org.apache.jetspeed.util.ValidationHelper;
import org.apache.jetspeed.util.parser.DefaultJetspeedParameterParser;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.StringKey;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.pool.Recyclable;

public class ValidationParameterParser
extends DefaultJetspeedParameterParser
implements ParameterParser,
Recyclable {
    public ValidationParameterParser() {
    }

    public ValidationParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    public void setProperties(Object bean) throws Exception {
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] props = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        StringBuffer invalidFieldMessages = new StringBuffer("");
        boolean valid = true;
        for (int i = 0; i < props.length; ++i) {
            String propname = props[i].getName();
            Method setter = props[i].getWriteMethod();
            if (setter == null || !this.containsKey(propname) && !this.containsDateSelectorKeys(propname) && !this.containsTimeSelectorKeys(propname)) continue;
            if (!this.validateProperty(bean, props[i])) {
                invalidFieldMessages.append("'");
                invalidFieldMessages.append(propname);
                invalidFieldMessages.append("' is not a valid field, ");
                valid = false;
            }
            this.setMyProperty(bean, props[i]);
        }
        String msg = this.generalValidation(bean);
        if (msg != null) {
            invalidFieldMessages.append(msg);
            invalidFieldMessages.append(", ");
            valid = false;
        }
        if (!valid) {
            int lastComma = new String(invalidFieldMessages).lastIndexOf(", ");
            String result = invalidFieldMessages.substring(0, lastComma);
            throw new ValidationException(result);
        }
    }

    protected void setMyProperty(Object bean, PropertyDescriptor prop) throws Exception {
        if (prop instanceof IndexedPropertyDescriptor) {
            throw new Exception(prop.getName() + " is an indexed property (not supported)");
        }
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new Exception(prop.getName() + " is a read only property");
        }
        Object[] args = this.getArguments(prop);
        try {
            setter.invoke(bean, args);
        }
        catch (Throwable t) {
            System.out.println("Validation: EXCEPTION (prop): " + prop.getName());
        }
    }

    protected Object[] getArguments(PropertyDescriptor prop) throws Exception {
        Class<?> propclass = prop.getPropertyType();
        Object[] args = new Object[]{null};
        if (propclass == String.class) {
            args[0] = this.getString(prop.getName());
        } else if (propclass == Integer.class || propclass == Integer.TYPE) {
            args[0] = this.getInteger(prop.getName());
        } else if (propclass == Short.class || propclass == Short.TYPE) {
            args[0] = new Short((short)this.getInteger(prop.getName()).intValue());
        } else if (propclass == Long.class || propclass == Long.TYPE) {
            args[0] = new Long(this.getLong(prop.getName()));
        } else if (propclass == Boolean.class || propclass == Boolean.TYPE) {
            args[0] = this.getBool(prop.getName());
        } else if (propclass == Double.class || propclass == Double.TYPE) {
            args[0] = new Double(this.getDouble(prop.getName()));
        } else if (propclass == BigDecimal.class) {
            args[0] = this.getBigDecimal(prop.getName());
        } else if (propclass == String[].class) {
            args[0] = this.getStrings(prop.getName());
        } else if (propclass == Object.class) {
            args[0] = this.getObject(prop.getName());
        } else if (propclass == int[].class) {
            args[0] = this.getInts(prop.getName());
        } else if (propclass == Integer[].class) {
            args[0] = this.getIntegers(prop.getName());
        } else if (propclass == Date.class) {
            args[0] = this.getDate(prop.getName());
        } else if (propclass == NumberKey.class) {
            args[0] = this.getNumberKey(prop.getName());
        } else if (propclass == StringKey.class) {
            args[0] = this.getStringKey(prop.getName());
        }
        return args;
    }

    protected boolean validateProperty(Object bean, PropertyDescriptor prop) throws Exception {
        String propertyName = prop.getName();
        String methodName = "validate" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Class[] signatureParams = new Class[]{prop.getPropertyType()};
        Object[] methodParams = this.getArguments(prop);
        try {
            Method method = bean.getClass().getMethod(methodName, signatureParams);
            boolean isValidBool = (Boolean)method.invoke(bean, methodParams);
            return isValidBool;
        }
        catch (NoSuchMethodException nsm_e) {
            try {
                return this.validateObject(prop);
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
    }

    protected boolean validateObject(PropertyDescriptor prop) throws Exception {
        Class<?> propclass = prop.getPropertyType();
        Object[] args = new Object[]{null};
        if (propclass == String.class) {
            return ValidationHelper.isAlphaNumeric(this.getString(prop.getName()), false);
        }
        if (propclass == Integer.class || propclass == Integer.TYPE) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        if (propclass == Short.class || propclass == Short.TYPE) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        if (propclass == Long.class || propclass == Long.TYPE) {
            return ValidationHelper.isDecimal(this.getString(prop.getName()), false);
        }
        if (propclass == Boolean.class || propclass == Boolean.TYPE) {
            return true;
        }
        if (propclass == Double.class || propclass == Double.TYPE) {
            return ValidationHelper.isDecimal(this.getString(prop.getName()), false);
        }
        if (propclass == BigDecimal.class) {
            return ValidationHelper.isDecimal(this.getString(prop.getName()), false);
        }
        if (propclass == String[].class) {
            return ValidationHelper.isAlphaNumeric(this.getString(prop.getName()), false);
        }
        if (propclass == Object.class) {
            System.err.println("Auto validate: Object-- NOT IMPLEMENTED");
            return true;
        }
        if (propclass == int[].class) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        if (propclass == Integer[].class) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        if (propclass == Date.class) {
            return true;
        }
        if (propclass == NumberKey.class) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        if (propclass == StringKey.class) {
            return ValidationHelper.isInteger(this.getString(prop.getName()), false);
        }
        return false;
    }

    protected String generalValidation(Object bean) throws Exception {
        String methodName = "validate";
        try {
            Method method = bean.getClass().getMethod(methodName, null);
            String msg = (String)method.invoke(bean, null);
            return msg;
        }
        catch (NoSuchMethodException nsm_e) {
        }
        catch (Exception e) {
            System.err.println("EXCEPTION INVOKING METHOD " + methodName + " : " + e);
        }
        return null;
    }
}

