/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.webservices.finance.stockmarket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.jetspeed.webservices.finance.stockmarket.SOAPResponseHandler;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuote;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuoteArrayHandler;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuoteHandler;
import org.apache.jetspeed.webservices.finance.stockmarket.StockQuoteService;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JetspeedStockQuoteService
extends TurbineBaseService
implements StockQuoteService {
    boolean debugIO = false;
    PrintStream debugOutputStream = System.out;
    private static final String BASE_SOAP_ENVELOPE = "<?xml version=\"1.0\"?>\n<SOAP-ENV:Envelope \n     xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n     xmlns:xsd1=\"urn:DataQuoteService\"\n     xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"\n     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n     xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <SOAP-ENV:Body>\n";
    private static final String END_SOAP_ENVELOPE = "  </SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";
    private static final String SOAP_ENCODING = " SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n";
    private static final String SERVICE_END_POINT = "http://www.bluesunrise.com/webservices/container/BlueSunriseFinance/BlueSunriseFinanceService/BlueSunriseFinancePort/";
    private static final String WSDL_SERVICE_NAMESPACE = "urn:QuoteService";
    private static final String SOAP_METHOD_QUOTE = "urn:QuoteService/quote";
    private static final String SOAP_METHOD_FULLQUOTE = "urn:QuoteService/fullQuote";
    private static final String SOAP_METHOD_FULLQUOTES = "urn:QuoteService/fullQuotes";
    private String soapEndPoint = "http://www.bluesunrise.com/webservices/container/BlueSunriseFinance/BlueSunriseFinanceService/BlueSunriseFinancePort/";
    private static final String QUOTE_RESULT = "quoteResult";
    private static final String FULL_QUOTE_RESULT = "fullQuoteResult";
    private static final String FULL_QUOTES_RESULT = "fullQuotesResult";
    private static final String DEFAULT_RETURN = "return";

    public String quote(String symbol) throws RemoteException {
        StringBuffer envelope = new StringBuffer(BASE_SOAP_ENVELOPE);
        envelope.append("    <m1:quote xmlns:m1=\"urn:QuoteService\"");
        envelope.append(SOAP_ENCODING);
        envelope.append("      <symbol xsi:type=\"xsd:string\">");
        envelope.append(symbol);
        envelope.append("</symbol>\n");
        envelope.append("    </m1:quote>\n");
        envelope.append(END_SOAP_ENVELOPE);
        SOAPResponseHandler handler = new SOAPResponseHandler(WSDL_SERVICE_NAMESPACE, QUOTE_RESULT, DEFAULT_RETURN);
        this.doSOAPRequest(SOAP_METHOD_QUOTE, envelope, handler);
        if (handler.isFault()) {
            throw new RemoteException(handler.getFaultContent());
        }
        try {
            String resultString = handler.getResult();
            if (resultString == null) {
                throw new RemoteException("Could not find return in soap response");
            }
            return resultString;
        }
        catch (Exception e) {
            throw new RemoteException("Error generating result.", e);
        }
    }

    public StockQuote fullQuote(String symbol) throws RemoteException {
        StringBuffer envelope = new StringBuffer(BASE_SOAP_ENVELOPE);
        envelope.append("    <m1:fullQuote xmlns:m1=\"urn:QuoteService\"");
        envelope.append(SOAP_ENCODING);
        envelope.append("      <symbol xsi:type=\"xsd:string\">");
        envelope.append(symbol);
        envelope.append("</symbol>\n");
        envelope.append("    </m1:fullQuote>\n");
        envelope.append(END_SOAP_ENVELOPE);
        SOAPResponseHandler handler = new SOAPResponseHandler(WSDL_SERVICE_NAMESPACE, FULL_QUOTE_RESULT, DEFAULT_RETURN);
        StockQuoteHandler quoteHandler = new StockQuoteHandler();
        handler.setResultHandler(quoteHandler);
        this.doSOAPRequest(SOAP_METHOD_FULLQUOTE, envelope, handler);
        if (handler.isFault()) {
            throw new RemoteException(handler.getFaultContent());
        }
        try {
            return quoteHandler.getResult();
        }
        catch (Exception e) {
            throw new RemoteException("Error generating result.", e);
        }
    }

    public StockQuote[] fullQuotes(String[] symbols) throws RemoteException {
        if (null == symbols || symbols.length < 1) {
            throw new RemoteException("Invalid symbols[] parameter");
        }
        StringBuffer envelope = new StringBuffer(BASE_SOAP_ENVELOPE);
        envelope.append("    <m1:fullQuotes xmlns:m1=\"urn:QuoteService\"");
        envelope.append(SOAP_ENCODING);
        envelope.append("      <symbols xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[" + symbols.length + "]\">\n");
        for (int ix = 0; ix < symbols.length; ++ix) {
            envelope.append("        <item xsi:type=\"xsd:string\">");
            envelope.append(symbols[ix]);
            envelope.append("</item>\n");
        }
        envelope.append("      ");
        envelope.append("</symbols>\n");
        envelope.append("    </m1:fullQuotes>\n");
        envelope.append(END_SOAP_ENVELOPE);
        SOAPResponseHandler handler = new SOAPResponseHandler(WSDL_SERVICE_NAMESPACE, FULL_QUOTES_RESULT, DEFAULT_RETURN);
        StockQuoteArrayHandler quoteHandler = new StockQuoteArrayHandler();
        handler.setResultHandler(quoteHandler);
        this.doSOAPRequest(SOAP_METHOD_FULLQUOTES, envelope, handler);
        if (handler.isFault()) {
            throw new RemoteException(handler.getFaultContent());
        }
        try {
            return quoteHandler.getResult();
        }
        catch (Exception e) {
            throw new RemoteException("Error generating result.", e);
        }
    }

    public void setWebService(String service) {
        this.soapEndPoint = service;
    }

    public String getWebService() {
        return this.soapEndPoint;
    }

    private void doSOAPRequest(String soapAction, StringBuffer envelope, XMLFilterImpl handler) throws RemoteException {
        try {
            if (this.debugIO) {
                this.debugOutputStream.println("SOAPURL: " + this.soapEndPoint);
                this.debugOutputStream.println("SoapAction: " + soapAction);
                this.debugOutputStream.println("SoapEnvelope:");
                this.debugOutputStream.println(envelope.toString());
            }
            URL url = new URL(this.soapEndPoint);
            HttpURLConnection connect = (HttpURLConnection)url.openConnection();
            connect.setDoOutput(true);
            byte[] bytes = envelope.toString().getBytes();
            connect.setRequestProperty("SOAPAction", "\"" + soapAction + "\"");
            connect.setRequestProperty("content-type", "text/xml");
            connect.setRequestProperty("content-length", "" + bytes.length);
            OutputStream out = connect.getOutputStream();
            out.write(bytes);
            out.flush();
            int rc = connect.getResponseCode();
            InputStream stream = null;
            if (rc == 200) {
                stream = connect.getInputStream();
            } else if (rc == 500) {
                stream = connect.getErrorStream();
            }
            if (stream != null) {
                String contentType;
                if (this.debugIO) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    int bt = stream.read();
                    while (bt != -1) {
                        bout.write(bt);
                        bt = stream.read();
                    }
                    this.debugOutputStream.println("Response:");
                    this.debugOutputStream.println(new String(bout.toByteArray()));
                    stream.close();
                    stream = new ByteArrayInputStream(bout.toByteArray());
                }
                if ((contentType = connect.getContentType()).indexOf("text/xml") == -1) {
                    throw new RemoteException("Content-type not text/xml.  Instead, found " + contentType);
                }
            } else {
                throw new RemoteException("Communication error: " + rc + " " + connect.getResponseMessage());
            }
            SAXParser xmlreader = new SAXParser();
            handler.setParent((XMLReader)xmlreader);
            xmlreader.setContentHandler((ContentHandler)handler);
            xmlreader.parse(new InputSource(stream));
            stream.close();
        }
        catch (RemoteException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new RemoteException("Error doing soap stuff", ex);
        }
    }

    public static void main(String[] args) {
        try {
            JetspeedStockQuoteService service = new JetspeedStockQuoteService();
            if (args.length == 0) {
                return;
            }
            int index = 0;
            if (args[index].startsWith("-") && "-debug".equals(args[0])) {
                service.debugIO = true;
                ++index;
            }
            if (index >= args.length) {
                return;
            }
            if ("quote".equals(args[index])) {
                if (++index >= args.length) {
                    return;
                }
                System.out.println(service.quote(args[index]));
            } else if (!"quotes".equals(args[index])) {
                if ("fullQuote".equals(args[index])) {
                    if (++index >= args.length) {
                        return;
                    }
                    System.out.println(service.fullQuote(args[index]));
                } else if ("fullQuotes".equals(args[index])) {
                    String[] symbols = new String[args.length - ++index];
                    for (int ix = 0; ix < symbols.length; ++ix) {
                        symbols[ix] = args[index];
                        ++index;
                    }
                    StockQuote[] stocks = service.fullQuotes(symbols);
                    for (int ix = 0; ix < stocks.length; ++ix) {
                        System.out.println(stocks[ix]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

