/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.workflow.WorkflowRouteResultData;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowCategoryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowCategoryFormData.class.getName());
    private ALStringField category_name;
    private ALStringField note;
    private ALStringField ordertemplate;
    private Integer category_id;
    private ALNumberField route_id;
    private ALStringField route;
    private List<WorkflowRouteResultData> routeList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        if (categoryid != null && Integer.valueOf(categoryid) != null) {
            this.category_id = Integer.valueOf(categoryid);
        }
    }

    public void initField() {
        this.category_name = new ALStringField();
        this.category_name.setFieldName(ALLocalizationUtils.getl10n((String)"WORKFLOW_CLASSIFICATION"));
        this.category_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"WORKFLOW_MEMO"));
        this.note.setTrim(true);
        this.ordertemplate = new ALStringField();
        this.ordertemplate.setFieldName(ALLocalizationUtils.getl10n((String)"WORKFLOW_APPLICATION_CONTENTS_TEMPLATE"));
        this.ordertemplate.setTrim(true);
        this.route_id = new ALNumberField();
        this.route = new ALStringField();
        this.route_id.setFieldName(ALLocalizationUtils.getl10n((String)"WORKFLOW_APPLICATION_ROUTE"));
    }

    protected void setValidator() {
        this.category_name.setNotNull(true);
        this.category_name.limitMaxLength(50);
        this.ordertemplate.limitMaxLength(1000);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTWorkflowCategory.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"categoryName", (Object)this.category_name.getValue());
            query.setQualifier(exp1);
            if ("update".equals(this.getMode())) {
                Expression exp2 = ExpressionFactory.noMatchDbExp((String)"CATEGORY_ID", (Object)this.category_id);
                query.andQualifier(exp2);
            }
            if (query.fetchList().size() != 0) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"WORKFLOW_ALERT_CATEGORY_ALREADY_CREATED", (Object[])new Object[]{this.category_name.toString()}));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        this.category_name.validate(msgList);
        this.note.validate(msgList);
        this.ordertemplate.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            this.category_name.setValue(category.getCategoryName());
            this.ordertemplate.setValue(category.getTemplate());
            this.note.setValue(category.getNote());
            if (category.getEipTWorkflowRoute() == null) {
                this.route_id.setValue(0L);
            } else {
                this.route_id.setValue(category.getEipTWorkflowRoute().getRouteId().longValue());
            }
            if (category.getEipTWorkflowRoute() != null) {
                this.route.setValue(category.getEipTWorkflowRoute().getRoute());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute route = WorkflowUtils.getEipTWorkflowRoute(this.route_id.getValue());
            EipTWorkflowCategory category = (EipTWorkflowCategory)Database.create(EipTWorkflowCategory.class);
            category.setCategoryName(this.category_name.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setCreateDate(Calendar.getInstance().getTime());
            category.setUpdateDate(Calendar.getInstance().getTime());
            category.setTemplate(this.ordertemplate.getValue());
            category.setEipTWorkflowRoute(route);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowRoute route = WorkflowUtils.getEipTWorkflowRoute(this.route_id.getValue());
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            category.setCategoryName(this.category_name.getValue());
            category.setTemplate(this.ordertemplate.getValue());
            category.setNote(this.note.getValue());
            category.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            category.setUpdateDate(Calendar.getInstance().getTime());
            category.setEipTWorkflowRoute(route);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTWorkflowCategory category = WorkflowUtils.getEipTWorkflowCategory(rundata, context);
            if (category == null) {
                return false;
            }
            if (category.getCategoryId() == 1) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"WORKFLOW_ALERT_CATEGORY_DELETE_OTHER", (Object[])new Object[0]));
                return false;
            }
            Database.delete((Persistent)category);
            SelectQuery query = Database.query(EipTWorkflowRequest.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"eipTWorkflowCategory.CATEGORY_ID", (Object)category.getCategoryId());
            query.setQualifier(exp1);
            List requests = query.fetchList();
            if (requests != null && requests.size() > 0) {
                EipTWorkflowRequest request = null;
                EipTWorkflowCategory defaultCategory = WorkflowUtils.getEipTWorkflowCategory(1L);
                int size = requests.size();
                for (int i = 0; i < size; ++i) {
                    request = (EipTWorkflowRequest)requests.get(i);
                    request.setEipTWorkflowCategory(defaultCategory);
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 121, category.getCategoryName());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    public String routeTemplate(int num) {
        for (WorkflowRouteResultData o : this.routeList) {
            WorkflowRouteResultData tmp = o;
            if (tmp.getRouteId().getValue() != (long)num) continue;
            return tmp.getRouteH();
        }
        return "";
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public ALStringField getTemplate() {
        return this.ordertemplate;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALNumberField getRouteId() {
        return this.route_id;
    }

    public ALStringField getRoute() {
        return this.route;
    }

    public String getRouteH() {
        StringBuffer routeun = new StringBuffer();
        if (this.route.getValue() != null && !"".equals(this.route.getValue())) {
            StringTokenizer st = new StringTokenizer(this.route.getValue(), ",");
            while (st.hasMoreTokens()) {
                String username = WorkflowUtils.getName(st.nextToken());
                routeun.append(username);
                routeun.append(" -> ");
            }
            routeun.append(ALLocalizationUtils.getl10n((String)"WORKFLOW_COMPLETION"));
            return routeun.toString();
        }
        return "";
    }

    public List<WorkflowRouteResultData> getRouteList() {
        return this.routeList;
    }

    public void loadRouteList(RunData rundata, Context context) {
        this.routeList = WorkflowUtils.loadRouteList(rundata, context);
    }
}

