/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration.BasePropertiesConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesConfiguration
extends BasePropertiesConfiguration
implements Configuration {
    Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$PropertiesConfiguration == null ? (class$org$apache$commons$configuration$PropertiesConfiguration = PropertiesConfiguration.class$("org.apache.commons.configuration.PropertiesConfiguration")) : class$org$apache$commons$configuration$PropertiesConfiguration));
    protected String fileSeparator = System.getProperty("file.separator");
    protected String fileName = null;
    static /* synthetic */ Class class$org$apache$commons$configuration$PropertiesConfiguration;

    public PropertiesConfiguration() {
        this.setIncludesAllowed(false);
    }

    public PropertiesConfiguration(Configuration defaults) throws IOException {
        this();
        this.defaults = defaults;
    }

    public PropertiesConfiguration(String fileName) throws IOException {
        this.load(fileName);
    }

    public void load() throws IOException {
        this.load(this.getFileName());
    }

    public void load(String fileName) throws IOException {
        this.load(this.getPropertyStream(fileName));
    }

    public PropertiesConfiguration(String file, Configuration defaults) throws IOException {
        this(file);
        this.defaults = defaults;
    }

    public PropertiesConfiguration(String file, String defaultFile) throws IOException {
        this(file);
        if (StringUtils.isNotEmpty((String)defaultFile)) {
            this.defaults = new PropertiesConfiguration(defaultFile);
        }
    }

    public InputStream getPropertyStream(String resourceName) throws IOException {
        FileInputStream resource = null;
        File file = null;
        if (resourceName.startsWith(this.fileSeparator)) {
            file = new File(resourceName);
        } else if (StringUtils.isEmpty((String)this.getBasePath())) {
            file = new File(resourceName);
        } else {
            StringBuffer fileName = new StringBuffer();
            fileName.append(this.getBasePath());
            if (!this.getBasePath().endsWith(this.fileSeparator)) {
                fileName.append(this.fileSeparator);
            }
            if (resourceName.startsWith("." + this.fileSeparator)) {
                fileName.append(resourceName.substring(2));
            } else {
                fileName.append(resourceName);
            }
            file = new File(fileName.toString());
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Could not open file " + file);
        }
        if (!file.canRead()) {
            throw new IOException("File " + resourceName + " exists but could not be read.");
        }
        resource = new FileInputStream(file);
        File baseFile = file.getParentFile();
        if (baseFile != null) {
            this.setBasePath(baseFile.getAbsolutePath());
            this.setIncludesAllowed(true);
        } else {
            this.setIncludesAllowed(false);
        }
        return resource;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setBasePath(String basePath) {
        super.setBasePath(basePath);
        this.setIncludesAllowed(StringUtils.isNotEmpty((String)basePath));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

