/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookCompanyFormData.class.getName());
    private ALStringField company_name;
    private ALStringField company_name_kana;
    private ALStringField post_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;
    private ALStringField url;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.company_name = new ALStringField();
        this.company_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_COMPANY_NAME"));
        this.company_name.setTrim(true);
        this.company_name_kana = new ALStringField();
        this.company_name_kana.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_COMPANY_NAME_KANA"));
        this.company_name_kana.setTrim(true);
        this.post_name = new ALStringField();
        this.post_name.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_POST_NAME"));
        this.post_name.setTrim(true);
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode1.setTrim(true);
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_ZIPCODE"));
        this.zipcode2.setTrim(true);
        this.address = new ALStringField();
        this.address.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_COMPANY_ADDRESS"));
        this.address.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_TELEPHONE"));
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_TELEPHONE"));
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_TELEPHONE"));
        this.telephone3.setTrim(true);
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_FAX_NUMBER"));
        this.fax_number1.setTrim(true);
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_FAX_NUMBER"));
        this.fax_number2.setTrim(true);
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_FAX_NUMBER"));
        this.fax_number3.setTrim(true);
        this.url = new ALStringField();
        this.url.setFieldName(ALLocalizationUtils.getl10n((String)"ADDRESSBOOK_URL"));
        this.url.setTrim(true);
    }

    protected void setValidator() {
        this.company_name.setNotNull(true);
        this.company_name.limitMaxLength(50);
        this.company_name_kana.setNotNull(true);
        this.company_name_kana.limitMaxLength(50);
        this.post_name.limitMaxLength(50);
        this.address.limitMaxLength(50);
        this.url.setCharacterType(19);
        this.url.limitMaxLength(50);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.company_name.validate(msgList);
        this.company_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.company_name_kana.toString())));
        this.company_name_kana.validate(msgList);
        this.post_name.validate(msgList);
        this.address.validate(msgList);
        this.url.validate(msgList);
        if (!(this.zipcode1.getValue().equals("") && this.zipcode2.getValue().equals("") || this.zipcode1.validate(dummy) && this.zipcode2.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u90f5\u4fbf\u756a\u53f7</span> \u300f\u306f7\u6841\u306e\u534a\u89d2\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals("") || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals("") || this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
            msgList.add("\u300e <span class='em'>FAX\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            StringTokenizer token;
            EipMAddressbookCompany company = AddressBookUtils.getEipMAddressbookCompany(rundata, context);
            if (company == null) {
                return false;
            }
            this.company_name.setValue(company.getCompanyName());
            this.company_name_kana.setValue(company.getCompanyNameKana());
            this.post_name.setValue(company.getPostName());
            this.address.setValue(company.getAddress());
            if (company.getZipcode() != null && (token = new StringTokenizer(company.getZipcode(), "-")).countTokens() == 3) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            if (company.getTelephone() != null && (token = new StringTokenizer(company.getTelephone(), "-")).countTokens() == 3) {
                this.telephone1.setValue(token.nextToken());
                this.telephone2.setValue(token.nextToken());
                this.telephone3.setValue(token.nextToken());
            }
            if (company.getFaxNumber() != null && (token = new StringTokenizer(company.getFaxNumber(), "-")).countTokens() == 3) {
                this.fax_number1.setValue(token.nextToken());
                this.fax_number2.setValue(token.nextToken());
                this.fax_number3.setValue(token.nextToken());
            }
            if (company.getZipcode() != null && (token = new StringTokenizer(company.getZipcode(), "-")).countTokens() == 2) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            this.url.setValue(company.getUrl());
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookCompanyFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressbookCompany company = (EipMAddressbookCompany)Database.create(EipMAddressbookCompany.class);
            rundata.getParameters().setProperties((Object)company);
            company.setCompanyName(this.company_name.getValue());
            company.setCompanyNameKana(this.company_name_kana.getValue());
            company.setPostName(this.post_name.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                company.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                company.setZipcode("");
            }
            company.setAddress(this.address.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                company.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                company.setTelephone("");
            }
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                company.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                company.setFaxNumber("");
            }
            company.setUrl(this.url.getValue());
            int uid = ALEipUtils.getUserId((RunData)rundata);
            company.setCreateUserId(Integer.valueOf(uid));
            company.setUpdateUserId(Integer.valueOf(uid));
            Date now = new Date();
            company.setCreateDate(now);
            company.setUpdateDate(now);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(company.getCompanyId().intValue(), 161, this.company_name.getValue());
            return true;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookCompanyFormData.insertFormData", (Throwable)ex);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMAddressbookCompany company = AddressBookUtils.getEipMAddressbookCompany(rundata, context);
            if (company == null) {
                return false;
            }
            company.setCompanyName(this.company_name.getValue());
            company.setCompanyNameKana(this.company_name_kana.getValue());
            company.setPostName(this.post_name.getValue());
            company.setAddress(this.address.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                company.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                company.setZipcode("");
            }
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                company.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                company.setTelephone("");
            }
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                company.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                company.setFaxNumber("");
            }
            company.setAddress(this.address.getValue());
            company.setUrl(this.url.getValue());
            company.setUpdateUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            company.setUpdateDate(new Date());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(company.getCompanyId().intValue(), 161, this.company_name.getValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookCompanyFormData.updateFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String companyid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (companyid == null || Integer.valueOf(companyid) == null) {
                logger.debug((Object)"[AddressBook] Cannot find Address ID .");
                return false;
            }
            EipMAddressbookCompany company = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)Integer.valueOf(companyid));
            int entityId = company.getCompanyId();
            String companyName = company.getCompanyName();
            Database.delete((Persistent)company);
            int empty_id = AddressBookUtils.getDummyEipMAddressbookCompany(rundata, context).getCompanyId();
            SelectQuery addrquery = Database.query(EipMAddressbook.class);
            Expression addrexp = ExpressionFactory.matchDbExp((String)"eipMAddressbookCompany.COMPANY_ID", (Object)companyid);
            addrquery.setQualifier(addrexp);
            List addresses = addrquery.fetchList();
            if (addresses != null && addresses.size() > 0) {
                EipMAddressbook addressbook = null;
                EipMAddressbookCompany dummycompany = (EipMAddressbookCompany)Database.get(EipMAddressbookCompany.class, (Object)empty_id);
                int addrsize = addresses.size();
                for (int i = 0; i < addrsize; ++i) {
                    addressbook = (EipMAddressbook)addresses.get(i);
                    addressbook.setEipMAddressbookCompany(dummycompany);
                }
            }
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 161, companyName);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"AddressBookCompanyFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getCompanyNameKana() {
        return this.company_name_kana;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALStringField getUrl() {
        return this.url;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }

    public void setAddress(ALStringField field) {
        this.address = field;
    }

    public void setCompanyName(ALStringField field) {
        this.company_name = field;
    }

    public void setCompanyNameKana(ALStringField field) {
        this.company_name_kana = field;
    }

    public void setPostName(ALStringField field) {
        this.post_name = field;
    }

    public void setUrl(ALStringField field) {
        this.url = field;
    }

    public String getAclPortletFeature() {
        return "addressbook_company";
    }
}

