/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.addressbook.AddressBookCompanyResultData;
import com.aimluck.eip.addressbook.AddressBookCompanySelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALXlsScreen;
import com.aimluck.eip.modules.screens.AddressBookXlsExportScreen;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanyXlsExportScreen
extends ALXlsScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookXlsExportScreen.class.getName());
    public static final String FOLDER_TMP_FOR_ADDRESSBOOK_FILES = JetspeedResources.getString((String)"aipo.tmp.addressbook.directory", (String)"");
    public static final String FILE_NAME = "addressbookcompany.xls";
    private String userid;
    private String aclPortletFeature = null;

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String target_user_id = rundata.getParameters().getString("target_user_id");
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        if (this.userid.equals(target_user_id)) {
            this.aclPortletFeature = "addressbook_address_outside";
        }
        super.init(rundata, context);
    }

    protected boolean createHSSFWorkbook(RunData rundata, Context context, HSSFWorkbook wb) {
        try {
            this.setupAddressBookSheet(rundata, context, wb);
        }
        catch (Exception e) {
            logger.error((Object)"AddressBookCompanyXlsExportScreen.createHSSFWorkbook", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setupAddressBookSheet(RunData rundata, Context context, HSSFWorkbook wb) throws Exception {
        String sheet_name = "\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af(\u4f1a\u793e\u60c5\u5831)";
        String[] headers = new String[]{"\u4f1a\u793e\u540d", "\u4f1a\u793e\u540d\uff08\u30d5\u30ea\u30ac\u30ca\uff09", "\u90e8\u7f72\u540d", "\u90f5\u4fbf\u756a\u53f7", "\u4f4f\u6240", "\u96fb\u8a71\u756a\u53f7", "FAX", "URL"};
        short[] cell_enc_types = new short[]{1, 1, 1, 1, 1, 1, 1, 1};
        HSSFSheet sheet = this.createHSSFSheet(wb, sheet_name, headers, cell_enc_types);
        int rowcount = 0;
        HSSFCellStyle style_col = wb.createCellStyle();
        style_col.setVerticalAlignment((short)1);
        style_col.setAlignment((short)5);
        AddressBookCompanySelectData listData = new AddressBookCompanySelectData();
        listData.initField();
        listData.setRowsNum(1000);
        listData.doSelectList((ALAction)this, rundata, context);
        int page_num = listData.getPagesNum();
        int current_page = 1;
        while (true) {
            int listsize = listData.getList().size();
            for (int j = 0; j < listsize; ++j) {
                AddressBookCompanyResultData rd = (AddressBookCompanyResultData)listData.getList().get(j);
                String[] rows = new String[]{rd.getCompanyName().getValue(), rd.getCompanyNameKana().getValue(), rd.getPostName().getValue(), rd.getZipcode().getValue(), rd.getAddress().getValue(), rd.getTelephone().getValue(), rd.getFaxNumber().getValue(), rd.getUrl().getValue()};
                this.addRow(sheet.createRow(++rowcount), cell_enc_types, rows);
            }
            if (++current_page > page_num) break;
            listData.setCurrentPage(current_page);
            listData.doSelectList((ALAction)this, rundata, context);
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        ALEventlogFactoryService.getInstance().getEventlogHandler().logXlsScreen(uid, "\u30a2\u30c9\u30ec\u30b9\u30d6\u30c3\u30af(\u4f1a\u793e\u60c5\u5831)\u51fa\u529b", 163);
    }

    protected String getFileName() {
        return FILE_NAME;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

