/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.FileIOAccountCsvFormData;
import com.aimluck.eip.fileio.FileIOAccountCsvResultData;
import com.aimluck.eip.fileio.util.FileIOAccountCsvUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountCsvSelectData
extends ALCsvAbstractSelectData<FileIOAccountCsvResultData, FileIOAccountCsvResultData> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountCsvSelectData.class.getName());
    private boolean overMaxUser = false;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    protected ResultList<FileIOAccountCsvResultData> selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return new ResultList(this.readAccountInfoFromCsv(rundata));
            }
            if (this.stats == 1) {
                String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account.csv";
                return new ResultList(this.readAccountInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000));
            }
            if (this.stats == 2) {
                if (this.error_count <= 0) {
                    return null;
                }
                String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post_err.csv";
                return new ResultList(this.readAccountInfoFromCsvPage(rundata, filepath, 0, 100));
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"fileio", (Throwable)ex);
            return null;
        }
    }

    protected FileIOAccountCsvResultData selectDetail(RunData rundata, Context context) {
        return null;
    }

    private List<FileIOAccountCsvResultData> readAccountInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account.csv";
        String filepath_err = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + ALStorageService.separator() + "account_post_err.csv";
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOAccountCsvResultData> list = new ArrayList<FileIOAccountCsvResultData>();
        Map<String, TurbineUser> existedUserMap = this.getAllUsersFromDB();
        if (existedUserMap == null) {
            existedUserMap = new LinkedHashMap<String, TurbineUser>();
        }
        int ErrCount = 0;
        ArrayList<String> usernameList = new ArrayList<String>();
        int line = 0;
        String ErrorCode = "";
        while (reader.eof != -1) {
            int i;
            int j;
            ++line;
            StringBuilder e_line = new StringBuilder();
            boolean same_user = false;
            boolean b_err = false;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAccountCsvFormData formData = new FileIOAccountCsvFormData();
            formData.initField();
            e_line.append("");
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line.append(",");
                }
                e_line.append("\"");
                e_line.append(this.makeOutputItem(token));
                e_line.append("\"");
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (reader.eof == -1 && j == 0) break;
            ++j;
            while (j < this.sequency.size()) {
                i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken("", i);
                e_line.append(",\"\"");
                ++j;
            }
            if (formData.getUserName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_USER_NAME"))) {
                this.setLineCount(this.getLineCount() - 1);
                ErrorCode = ErrorCode + e_line.toString();
                ErrorCode = ErrorCode + "," + Integer.toString(line) + ",false";
                ErrorCode = ErrorCode + "\n";
                continue;
            }
            if (usernameList.contains(formData.getUserName().getValue())) {
                same_user = true;
                b_err = true;
            } else {
                usernameList.add(formData.getUserName().getValue());
            }
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                b_err = true;
            }
            try {
                String username = formData.getUserName().getValue();
                FileIOAccountCsvResultData data = new FileIOAccountCsvResultData();
                TurbineUser user = new TurbineUser();
                if (existedUserMap.containsKey(username)) {
                    TurbineUser tmpuser2 = existedUserMap.get(username);
                    if ("F".equals(tmpuser2.getDisabled())) {
                        user.setLoginName(username);
                    } else {
                        user.setLoginName(null);
                        b_err = true;
                    }
                } else {
                    user.setLoginName(username);
                    TurbineUser newuser = new TurbineUser();
                    newuser.setLoginName(username);
                    newuser.setDisabled("F");
                    existedUserMap.put(username, newuser);
                }
                user.setPasswordValue(formData.getPassword().getValue());
                user.setFirstName(formData.getFirstName().getValue());
                user.setLastName(formData.getLastName().getValue());
                user.setFirstNameKana(formData.getFirstNameKana().getValue());
                user.setLastNameKana(formData.getLastNameKana().getValue());
                user.setEmail(formData.getEmail().getValue());
                user.setOutTelephone(formData.getOutTelephone().getValue());
                user.setInTelephone(formData.getInTelephone().getValue());
                user.setCellularPhone(formData.getCellularPhone().getValue());
                user.setCellularMail(formData.getCellularMail().getValue());
                data.initField();
                data.setLineCount(line);
                data.setUser(user);
                data.setPostNotFound(formData.getPostNotFound());
                ArrayList<String> postnames = new ArrayList<String>();
                String[] st = formData.getPostName().toString().split("/");
                for (int k = 0; k < st.length; ++k) {
                    postnames.add(st[k]);
                }
                data.setPostName(formData.getPostName().getValue());
                data.setPostNameList(postnames);
                data.setPositionNotFound(formData.getPositionNotFound());
                data.setPositionName(formData.getPositionName().getValue());
                data.setSameUser(same_user);
                data.setIsError(b_err);
                if (b_err) {
                    ErrorCode = ErrorCode + e_line.toString();
                    ErrorCode = ErrorCode + "," + Integer.toString(line) + "," + Boolean.toString(same_user);
                    ErrorCode = ErrorCode + "\n";
                }
                if (ErrCount == 0) {
                    if (!b_err) {
                        if (list.size() < 1000) {
                            list.add(data);
                        }
                    } else {
                        list.add(data);
                        ++ErrCount;
                    }
                } else {
                    if (b_err) {
                        ++ErrCount;
                    }
                    list.add(data);
                }
                if (ErrCount < 100) continue;
                break;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        TurbineUser tmpuser22 = null;
        int count_legitimate_user = 0;
        Collection<TurbineUser> coll = existedUserMap.values();
        for (TurbineUser tmpuser22 : coll) {
            if ("T".equals(tmpuser22.getDisabled())) continue;
            ++count_legitimate_user;
        }
        int max_user = ALEipUtils.getLimitUsers();
        if (max_user > 0 && count_legitimate_user > max_user + 2) {
            this.overMaxUser = true;
        }
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private List<FileIOAccountCsvResultData> readAccountInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        Map<String, TurbineUser> existedUserMap = this.getAllUsersFromDB();
        if (existedUserMap == null) {
            existedUserMap = new LinkedHashMap<String, TurbineUser>();
        }
        ArrayList<FileIOAccountCsvResultData> list = new ArrayList<FileIOAccountCsvResultData>();
        int line = 0;
        while (reader.eof != -1) {
            String token;
            boolean iserror = false;
            boolean same_user = false;
            if (++line > LineLimit) break;
            ArrayList<String> errmsg = new ArrayList<String>();
            FileIOAccountCsvFormData formData = new FileIOAccountCsvFormData();
            formData.initField();
            for (int j = 0; j < this.sequency.size(); ++j) {
                token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            if (this.stats == 2) {
                token = reader.nextToken();
                same_user = Boolean.parseBoolean(token);
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (formData.getUserName().toString().equals(ALLocalizationUtils.getl10n((String)"FILEIO_USER_NAME"))) continue;
            if (reader.eof == -1) break;
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                iserror = true;
            }
            if (this.stats == 2) {
                iserror = true;
            }
            try {
                String username = formData.getUserName().getValue();
                FileIOAccountCsvResultData data = new FileIOAccountCsvResultData();
                data.initField();
                TurbineUser user = new TurbineUser();
                if (existedUserMap.containsKey(username)) {
                    TurbineUser tmpuser2 = existedUserMap.get(username);
                    if ("F".equals(tmpuser2.getDisabled())) {
                        user.setLoginName(username);
                    } else {
                        user.setLoginName(null);
                        iserror = true;
                    }
                } else {
                    user.setLoginName(username);
                    TurbineUser newuser = new TurbineUser();
                    newuser.setLoginName(username);
                    newuser.setDisabled("F");
                    existedUserMap.put(username, newuser);
                }
                user.setPasswordValue(formData.getPassword().getValue());
                user.setFirstName(formData.getFirstName().getValue());
                user.setLastName(formData.getLastName().getValue());
                user.setFirstNameKana(formData.getFirstNameKana().getValue());
                user.setLastNameKana(formData.getLastNameKana().getValue());
                user.setEmail(formData.getEmail().getValue());
                user.setOutTelephone(formData.getOutTelephone().getValue());
                user.setInTelephone(formData.getInTelephone().getValue());
                user.setCellularPhone(formData.getCellularPhone().getValue());
                user.setCellularMail(formData.getCellularMail().getValue());
                data.setUser(user);
                data.setLineCount(line + line_index);
                ArrayList<String> postnames = new ArrayList<String>();
                String[] st = formData.getPostName().toString().split("/");
                for (int k = 0; k < st.length; ++k) {
                    postnames.add(st[k]);
                }
                data.setPostName(formData.getPostName().getValue());
                data.setPostNameList(postnames);
                data.setPostNotFound(formData.getPostNotFound());
                data.setPositionNotFound(formData.getPositionNotFound());
                data.setPositionName(formData.getPositionName().getValue());
                data.setSameUser(same_user);
                data.setIsError(iserror);
                list.add(data);
            }
            catch (RuntimeException e) {
                logger.error((Object)"readError");
            }
            catch (Exception e) {
                logger.error((Object)"readError");
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    private Map<String, TurbineUser> getAllUsersFromDB() {
        LinkedHashMap<String, TurbineUser> map = null;
        try {
            SelectQuery query = Database.query(TurbineUser.class);
            List list = query.fetchList();
            map = new LinkedHashMap<String, TurbineUser>();
            TurbineUser user = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                user = (TurbineUser)list.get(i);
                map.put(user.getLoginName(), user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[ALEipUtils]", (Throwable)ex);
        }
        return map;
    }

    protected Object getResultData(FileIOAccountCsvResultData obj) {
        return obj;
    }

    protected Object getResultDataDetail(FileIOAccountCsvResultData obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public boolean overMaxUser() {
        return this.overMaxUser;
    }

    public String getLineCount2() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_ERROR_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getErrorCount()});
    }

    public String getLineCount3() {
        return ALLocalizationUtils.getl10nFormat((String)"FILEIO_REGISTER_NUMBER", (Object[])new Object[]{this.getLineCount(), this.getNotErrorCount()});
    }
}

