/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.Where;

public class ScheduleCsvUser {
    private ALNumberField user_id;
    private ALStringField name;
    private ALStringField alias_name;
    private ALStringField firstName;
    private ALStringField lastName;

    public ScheduleCsvUser() {
        this.initField();
    }

    public void initField() {
        this.user_id = new ALNumberField();
        this.name = new ALStringField();
        this.alias_name = new ALStringField();
        this.firstName = new ALStringField();
        this.lastName = new ALStringField();
        this.name.setTrim(true);
        this.firstName.setTrim(true);
        this.lastName.setTrim(true);
        this.name.limitMaxLength(16);
        this.firstName.limitMaxLength(20);
        this.lastName.limitMaxLength(20);
    }

    public ALStringField getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName.setValue(firstName);
    }

    public ALStringField getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName.setValue(lastName);
    }

    public void parseFullName(String rawName) {
        String[] value = (rawName = rawName.replace("\u3000", " ")).trim().split(" ");
        if (value.length > 0) {
            this.setLastName(value[0].trim());
        }
        if (value.length > 1) {
            this.setFirstName(value[1].trim());
        }
        this.setAliasName(this.firstName.getValue(), this.lastName.getValue());
    }

    public void setName(String string) {
        this.name.setValue(string);
    }

    public void setAliasName(String firstName, String lastName) {
        this.alias_name.setValue(new StringBuffer().append(lastName).append(" ").append(firstName).toString());
    }

    public ALStringField getName() {
        return this.name;
    }

    public ALStringField getAliasName() {
        return this.alias_name;
    }

    public ALNumberField getUserId() {
        return this.user_id;
    }

    public void setUserId(int number) {
        this.user_id.setValue((long)number);
    }

    public void complement() throws Exception {
        if (this.name.getValue() == null) {
            if (this.lastName.getValue() == null || this.firstName.getValue() == null) {
                return;
            }
            this.complementLoginName();
        } else {
            this.complementUserName();
        }
    }

    public void complementUserName() throws Exception {
        TurbineUser user = (TurbineUser)Database.query(TurbineUser.class).where(Operations.eq((String)"loginName", (Object)this.name.getValue())).where(Operations.eq((String)"disabled", (Object)"F")).fetchSingle();
        if (user == null) {
            user = (TurbineUser)Database.query(TurbineUser.class).where(Operations.eq((String)"email", (Object)this.name.getValue())).where(Operations.eq((String)"disabled", (Object)"F")).fetchSingle();
            if (user == null) {
                this.name.setValue("");
                this.alias_name.setValue("---");
                throw new Exception();
            }
            this.name.limitMaxLength(50);
        }
        this.user_id.setValue((long)user.getUserId().intValue());
        this.firstName.setValue(user.getFirstName());
        this.lastName.setValue(user.getLastName());
        this.setAliasName(this.firstName.getValue(), this.lastName.getValue());
    }

    public void complementLoginName() throws Exception {
        TurbineUser user = (TurbineUser)Database.query(TurbineUser.class).where(new Where[]{Operations.eq((String)"firstName", (Object)this.firstName.getValue()), Operations.and((Where[])new Where[]{Operations.eq((String)"lastName", (Object)this.lastName.getValue())})}).fetchSingle();
        if (user == null) {
            throw new Exception();
        }
        this.user_id.setValue((long)user.getUserId().intValue());
        this.name.setValue("");
    }
}

