/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.providers.MsgJavaProvider;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.EnvelopeEditorFactory;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;

public class MessageRouterServlet
extends HttpServlet {
    private EnvelopeEditor editor = null;
    private String configFilename = null;

    private Object createObject(String string, ClassLoader classLoader) throws ServletException {
        try {
            return classLoader.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException("Can't find class named '" + string + "'.");
        }
        catch (InstantiationException instantiationException) {
            throw new ServletException("Can't instantiate class '" + string + "'.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException("WARNING: Can't access the constructor of the class '" + string + "'.");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><head><title>SOAP Message Router</title></head>");
        printWriter.println("<body><h1>SOAP Message Router</h1>");
        printWriter.println("<p>Sorry, I don't speak via HTTP GET- you have to use");
        printWriter.println("HTTP POST to talk to me.</p></body></html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        HttpSession httpSession = httpServletRequest.getSession();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(servletContext, this.configFilename);
        DeploymentDescriptor deploymentDescriptor = null;
        SOAPContext sOAPContext = new SOAPContext();
        SOAPContext sOAPContext2 = new SOAPContext();
        sOAPContext.setClassLoader(ServerHTTPUtils.getServletClassLoaderFromContext(servletContext));
        try {
            int n;
            TransportMessage transportMessage;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            try {
                sOAPContext.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                sOAPContext.setProperty(Constants.BAG_HTTPSESSION, httpSession);
                sOAPContext.setProperty(Constants.BAG_HTTPSERVLETREQUEST, httpServletRequest);
                sOAPContext.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, httpServletResponse);
                object7 = XMLParserUtils.getXMLDocBuilder();
                object6 = ServerHTTPUtils.readEnvelopeFromRequest((DocumentBuilder)object7, httpServletRequest.getContentType(), httpServletRequest.getContentLength(), (InputStream)httpServletRequest.getInputStream(), this.editor, httpServletResponse, sOAPContext);
                if (object6 == null) {
                    return;
                }
                object5 = ((Envelope)object6).getBody();
                object4 = (Element)((Body)object5).getBodyEntries().elementAt(0);
                if (object4 == null) {
                    throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Message envelope's body is empty!");
                }
                object3 = object4.getNamespaceURI();
                object2 = object4.getLocalName();
                deploymentDescriptor = serviceManager.query((String)object3);
                sOAPContext.setProperty(Constants.BAG_DEPLOYMENTDESCRIPTOR, deploymentDescriptor);
                object = deploymentDescriptor.getProviderType() == 0 ? new MsgJavaProvider() : (deploymentDescriptor.getProviderType() == 3 ? ServerUtils.loadProvider(deploymentDescriptor, sOAPContext) : new MsgJavaProvider());
                object.locate(deploymentDescriptor, (Envelope)object6, null, (String)object2, (String)object3, sOAPContext);
                object.invoke(sOAPContext, sOAPContext2);
                transportMessage = new TransportMessage(null, sOAPContext2, null);
                transportMessage.editOutgoing(this.editor);
                n = 200;
            }
            catch (Throwable throwable) {
                object6 = null;
                object6 = throwable instanceof SOAPException ? (SOAPException)throwable : new SOAPException(String.valueOf(Constants.FAULT_CODE_SERVER) + ".Exception:", "", throwable);
                object5 = new Fault((SOAPException)object6);
                ((Fault)object5).setFaultActorURI(httpServletRequest.getRequestURI());
                if (deploymentDescriptor != null) {
                    deploymentDescriptor.buildFaultRouter(sOAPContext).notifyListeners((Fault)object5, (SOAPException)object6);
                }
                n = 500;
                sOAPContext2 = new SOAPContext();
                object4 = new Response(null, null, (Fault)object5, null, null, "http://schemas.xmlsoap.org/soap/encoding/", sOAPContext2);
                object3 = ((Response)object4).buildEnvelope();
                object2 = new StringWriter();
                ((Envelope)object3).marshall((Writer)object2, ServerHTTPUtils.getSMRFromContext(servletContext), ((RPCMessage)object4).getSOAPContext());
                object = ((StringWriter)object2).toString();
                transportMessage = new TransportMessage((String)object, sOAPContext2, null);
            }
            transportMessage.save();
            httpServletResponse.setStatus(n);
            httpServletResponse.setContentType(transportMessage.getContentType());
            object7 = transportMessage.getHeaderNames();
            while (object7.hasMoreElements()) {
                object6 = (String)object7.nextElement();
                httpServletResponse.setHeader((String)object6, transportMessage.getHeader((String)object6));
            }
            httpServletResponse.setContentLength(transportMessage.getContentLength());
            object6 = httpServletResponse.getOutputStream();
            transportMessage.writeTo((OutputStream)object6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ServletException("Error building response envelope: " + exception);
        }
    }

    public void init() throws ServletException {
        Object object;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String string = servletConfig.getInitParameter("EnvelopeEditorFactory");
        if (string != null && (object = (EnvelopeEditorFactory)this.createObject(string, classLoader)) != null) {
            try {
                String string2;
                Properties properties = new Properties();
                Enumeration enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if ("EnvelopeEditorFactory".equals(string2) || "XMLParser".equals(string2)) continue;
                    ((Hashtable)properties).put(string2, servletConfig.getInitParameter(string2));
                }
                string2 = servletContext.getRealPath("");
                if (string2 != null) {
                    ((Hashtable)properties).put("SOAPServerContextPath", string2);
                }
                this.editor = object.create(properties);
            }
            catch (SOAPException sOAPException) {
                throw new ServletException("Can't create editor", (Throwable)sOAPException);
            }
        }
        if ((object = servletConfig.getInitParameter("ConfigFile")) != null) {
            this.configFilename = object;
        }
        if ((object = servletConfig.getInitParameter("XMLParser")) != null) {
            XMLParserUtils.refreshDocumentBuilderFactory((String)object, true, false);
        }
        ServerHTTPUtils.setServletClassLoaderIntoContext(servletContext, classLoader);
    }
}

