/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.todo;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.cayenne.om.portlet.EipTTodoCategory;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.todo.ToDoCategoryResultData;
import com.aimluck.eip.todo.ToDoResultData;
import com.aimluck.eip.todo.util.ToDoUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ToDoSelectData
extends ALAbstractMultiFilterSelectData<EipTTodo, EipTTodo>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ToDoSelectData.class.getName());
    private String currentTab;
    private List<ToDoCategoryResultData> categoryList;
    private List<ALEipGroup> postList;
    private int todoSum;
    private String scheduleUrl;
    private String target_group_name;
    private String target_user_id;
    private List<ALEipGroup> myGroupList;
    private int login_user_id;
    private String aclPortletFeature;
    private boolean hasAclListTodoOther;
    private boolean hasAclDetailTodoOther;
    private boolean hasAclEditTodoOther;
    private boolean hasAclDeleteTodoOther;
    private int table_colum_num;
    private final String filterType = "";
    private final String categoryId = "";
    private ALStringField target_keyword;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (rundata.getParameters().getString("entityid") != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)rundata.getParameters().getString("entityid"));
        }
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"updateDate");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"list");
            this.currentTab = "list";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        this.login_user_id = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        int view_uid = ToDoUtils.getViewId(rundata, context, this.login_user_id);
        this.aclPortletFeature = view_uid == this.login_user_id ? "todo_todo_self" : "todo_todo_other";
        this.hasAclListTodoOther = aclhandler.hasAuthority(this.login_user_id, "todo_todo_other", 1);
        this.hasAclDetailTodoOther = aclhandler.hasAuthority(this.login_user_id, "todo_todo_other", 2);
        this.hasAclEditTodoOther = aclhandler.hasAuthority(this.login_user_id, "todo_todo_other", 8);
        this.hasAclDeleteTodoOther = aclhandler.hasAuthority(this.login_user_id, "todo_todo_other", 16);
        this.postList = ALEipUtils.getMyGroups((RunData)rundata);
        this.target_keyword = new ALStringField();
        super.init(action, rundata, context);
    }

    public void loadCategoryList(RunData rundata) {
        this.categoryList = ToDoUtils.getCategoryList(rundata);
    }

    public ResultList<EipTTodo> selectList(RunData rundata, Context context) {
        try {
            if (ToDoUtils.hasResetFlag(rundata, context)) {
                ToDoUtils.resetFilter(rundata, context, ((Object)((Object)this)).getClass().getName());
                this.target_keyword.setValue("");
            }
            if (ToDoUtils.hasResetKeywordFlag(rundata, context)) {
                ToDoUtils.resetKeyword(rundata, context, ((Object)((Object)this)).getClass().getName());
            }
            if (ToDoUtils.hasResetTargetFlag(rundata, context)) {
                ToDoUtils.resetTarget(rundata, context, ((Object)((Object)this)).getClass().getName());
            }
            this.target_group_name = ToDoUtils.getTargetGroupName(rundata, context);
            this.target_user_id = ToDoUtils.getTargetUserId(rundata, context);
            this.target_keyword.setValue(ToDoUtils.getTargetKeyword(rundata, context));
            this.setMyGroupList(new ArrayList<ALEipGroup>());
            this.getMyGroupList().addAll(ALEipUtils.getMyGroups((RunData)rundata));
            SelectQuery<EipTTodo> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.setPageParam(list.getTotalCount());
            this.todoSum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTTodo> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTTodo.class);
        if (this.target_user_id != null && !this.target_user_id.equals("") && !this.target_user_id.equals("all")) {
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.target_user_id));
            query.andQualifier(exp1);
        }
        if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            Expression exp = ExpressionFactory.matchExp((String)"turbineUser.turbineUserGroupRole.turbineGroup.groupName", (Object)this.target_group_name);
            query.andQualifier(exp);
        }
        if (this.target_keyword != null && !this.target_keyword.getValue().equals("")) {
            String[] spstr;
            String keyword = "%" + this.target_keyword.getValue() + "%";
            Expression exp = ExpressionFactory.likeExp((String)"todoName", (Object)keyword);
            Expression exp2 = ExpressionFactory.likeExp((String)"note", (Object)keyword);
            String first_name = keyword;
            String last_name = keyword;
            char[] c = new char[]{'\u3000'};
            String wspace = new String(c);
            String keyword2 = this.target_keyword.getValue().replaceAll(wspace, " ");
            if (keyword2.contains(" ") && (spstr = keyword2.split(" ")).length == 2) {
                first_name = "%" + spstr[1] + "%";
                last_name = "%" + spstr[0] + "%";
            }
            Expression exp3 = ExpressionFactory.likeExp((String)"turbineUser.firstName", (Object)first_name);
            Expression exp4 = ExpressionFactory.likeExp((String)"turbineUser.firstNameKana", (Object)first_name);
            Expression exp5 = ExpressionFactory.likeExp((String)"turbineUser.lastName", (Object)last_name);
            Expression exp6 = ExpressionFactory.likeExp((String)"turbineUser.lastNameKana", (Object)last_name);
            query.andQualifier(exp.orExp(exp2).orExp(exp3).orExp(exp4).orExp(exp5).orExp(exp6));
        }
        if ("list".equals(this.currentTab)) {
            Expression exp3 = ExpressionFactory.noMatchExp((String)"state", (Object)100);
            query.andQualifier(exp3);
        } else if ("complete".equals(this.currentTab)) {
            Expression exp4 = ExpressionFactory.matchExp((String)"state", (Object)100);
            query.andQualifier(exp4);
        }
        Expression exp5 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        if (this.target_user_id != null && (this.target_user_id.equals("all") || this.target_user_id.equals(String.valueOf(this.login_user_id)))) {
            Expression exp6 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            Expression exp7 = ExpressionFactory.matchExp((String)"userId", (Object)this.login_user_id);
            query.andQualifier(exp5.orExp(exp6.andExp(exp7)));
        } else {
            query.andQualifier(exp5);
        }
        if (!this.hasAclListTodoOther) {
            Expression exp8 = ExpressionFactory.matchExp((String)"userId", (Object)this.login_user_id);
            query.andQualifier(exp8);
        }
        return this.buildSelectQueryForFilter((SelectQuery<EipTTodo>)query, rundata, context);
    }

    protected void parseFilterMap(String key, String val) {
        super.parseFilterMap(key, val);
        HashSet unUse = new HashSet();
        for (Map.Entry pair : this.current_filterMap.entrySet()) {
            if (!((List)pair.getValue()).contains("0")) continue;
            unUse.add(pair.getKey());
        }
        for (String unusekey : unUse) {
            this.current_filterMap.remove(unusekey);
        }
    }

    protected SelectQuery<EipTTodo> buildSelectQueryForFilter(SelectQuery<EipTTodo> query, RunData rundata, Context context) {
        super.buildSelectQueryForFilter(query, rundata, context);
        if (this.current_filterMap.containsKey("post")) {
            List postIds = (List)this.current_filterMap.get("post");
            boolean existPost = false;
            for (int i = 0; i < this.postList.size(); ++i) {
                String pid = this.postList.get(i).getName().toString();
                if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                existPost = true;
                break;
            }
            Map map = ALEipManager.getInstance().getPostMap();
            for (Map.Entry entry : map.entrySet()) {
                String pid = ((ALEipPost)entry.getValue()).getGroupName().toString();
                if (!pid.equals(((String)postIds.get(0)).toString())) continue;
                existPost = true;
                break;
            }
            if (existPost) {
                HashSet<Integer> userIds = new HashSet<Integer>();
                for (String post : postIds) {
                    List userId = ALEipUtils.getUserIds((String)post);
                    userIds.addAll(userId);
                }
                if (userIds.isEmpty()) {
                    userIds.add(-1);
                }
                Expression expression = ExpressionFactory.inExp((String)"userId", userIds);
                query.andQualifier(expression);
            } else {
                this.current_filterMap.remove("post");
            }
        }
        return query;
    }

    protected Object getResultData(EipTTodo record) {
        try {
            EipTTodoCategory category = record.getEipTTodoCategory();
            if (category == null) {
                return null;
            }
            ToDoResultData rd = new ToDoResultData();
            rd.initField();
            rd.setTodoId(record.getTodoId().intValue());
            rd.setCategoryId((int)category.getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTTodoCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setUserId(record.getUserId().longValue());
            rd.setUserName(ALEipUtils.getALEipUser((int)record.getUserId()).getAliasName().getValue());
            rd.setLoginUserId(this.login_user_id);
            rd.setTodoName(ALCommonUtils.compressString((String)record.getTodoName(), (int)this.getStrLength()));
            if (!ToDoUtils.isEmptyDate(record.getStartDate())) {
                rd.setStartDate(ALDateUtil.format((Date)record.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
            }
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
            }
            rd.setState(record.getState().intValue());
            rd.setStateImage(ToDoUtils.getStateImage(record.getState().intValue()));
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriority(record.getPriority().intValue());
            rd.setPriorityImage(ToDoUtils.getPriorityImage(record.getPriority().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setUpdateDate(record.getUpdateDate());
            rd.setPublicFlag("T".equals(record.getPublicFlag()));
            rd.setLimitState(ToDoUtils.getLimitState(record.getEndDate()));
            rd.setIsSelfTodo(record.getUserId() == this.login_user_id);
            rd.setAclListTodoOther(this.hasAclListTodoOther);
            rd.setAclDetailTodoOther(this.hasAclDetailTodoOther);
            rd.setAclEditTodoOther(this.hasAclEditTodoOther);
            rd.setAclDeleteTodoOther(this.hasAclDeleteTodoOther);
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    public EipTTodo selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        String js_peid = rundata.getParameters().getString("sch");
        if (js_peid != null && !js_peid.equals("")) {
            this.scheduleUrl = this.getPortletURItoSchedule(rundata, js_peid);
        }
        EipTTodo todo = ToDoUtils.getEipTTodo(rundata, context, true);
        return todo;
    }

    protected String getPortletURItoSchedule(RunData rundata, String schedulePortletId) {
        int prev = rundata.getParameters().getInt("prev");
        if (prev == 2) {
            return ALEipUtils.getPortletURI((RunData)rundata, (String)schedulePortletId);
        }
        return ALEipUtils.getPortletURItoTopPage((RunData)rundata, (String)schedulePortletId);
    }

    protected Object getResultDataDetail(EipTTodo record) {
        try {
            ToDoResultData rd = new ToDoResultData();
            rd.initField();
            rd.setTodoName(record.getTodoName());
            rd.setTodoId(record.getTodoId().longValue());
            rd.setCategoryId(record.getEipTTodoCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTTodoCategory().getCategoryName());
            rd.setUserId(record.getUserId().longValue());
            rd.setUserName(ALEipUtils.getALEipUser((int)record.getUserId()).getAliasName().getValue());
            if (!ToDoUtils.isEmptyDate(record.getStartDate())) {
                rd.setStartDate(ALDateUtil.format((Date)record.getStartDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
            }
            if (!ToDoUtils.isEmptyDate(record.getEndDate())) {
                rd.setEndDate(ALDateUtil.format((Date)record.getEndDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
            }
            rd.setStateString(ToDoUtils.getStateString(record.getState().intValue()));
            rd.setPriorityString(ToDoUtils.getPriorityString(record.getPriority().intValue()));
            rd.setNote(record.getNote());
            rd.setCreateUserId(record.getCreateUserId().longValue());
            rd.setCreateUserName(ALEipUtils.getALEipUser((int)record.getCreateUserId()).getAliasName().getValue());
            rd.setLoginUserId(this.login_user_id);
            rd.setPublicFlag("T".equals(record.getPublicFlag()));
            rd.setAddonScheduleFlg("T".equals(record.getAddonScheduleFlg()));
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5(E)"));
            rd.setUpdateDate(record.getUpdateDate());
            rd.setIsSelfTodo(record.getUserId() == this.login_user_id);
            rd.setAclListTodoOther(this.hasAclListTodoOther);
            rd.setAclDetailTodoOther(this.hasAclDetailTodoOther);
            rd.setAclEditTodoOther(this.hasAclEditTodoOther);
            rd.setAclDeleteTodoOther(this.hasAclDeleteTodoOther);
            if (record.getUserId() != this.login_user_id && !this.hasAclDetailTodoOther) {
                throw new ALPermissionException();
            }
            return rd;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"todo", (Throwable)ex);
            return null;
        }
    }

    public List<ToDoCategoryResultData> getCategoryList() {
        return this.categoryList;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public int getTodoSum() {
        return this.todoSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("todo_name", "todoName");
        map.putValue("state", "state");
        map.putValue("priority", "priority");
        map.putValue("end_date", "endDate");
        map.putValue("category_name", "eipTTodoCategory.categoryName");
        map.putValue("category", "CATEGORY_ID");
        map.putValue("user_name", "turbineUser.lastNameKana");
        map.putValue("updateDate", "updateDate");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public String getScheduleUrl() {
        return this.scheduleUrl;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public void setTargetGroupName(String target_group_name) {
        this.target_group_name = target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List<ALEipUser> getUsers() {
        if (this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all")) {
            return ALEipUtils.getUsers((String)this.target_group_name);
        }
        return ALEipUtils.getUsers((String)"LoginUser");
    }

    public void setTargetUserId(String target_user_id) {
        this.target_user_id = target_user_id;
    }

    protected boolean doCheckAclPermission(RunData rundata, Context context, int defineAclType) throws ALPermissionException {
        if (defineAclType == 0) {
            return true;
        }
        String pfeature = this.getAclPortletFeature();
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        if (!this.hasAuthority) {
            throw new ALPermissionException();
        }
        return true;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setMyGroupList(List<ALEipGroup> myGroupList) {
        this.myGroupList = myGroupList;
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public int getTableColumNum() {
        return this.table_colum_num;
    }

    public void setTableColumNum(int table_colum_num) {
        this.table_colum_num = table_colum_num;
    }

    public List<ALEipGroup> getPostList() {
        return this.postList;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public void setFiltersPSML(VelocityPortlet portlet, Context context, RunData rundata) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)portlet.getPortletConfig().getInitParameter("p12f-filters"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)portlet.getPortletConfig().getInitParameter("p12g-filtertypes"));
    }

    public String getCategoryId() {
        return "";
    }
}

