/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cellular.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALServletUtils;
import java.security.Principal;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellularUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellularUtils.class.getName());
    public static final String CABINET_PORTLET_NAME = "Cellular";

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = "1";
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            SelectQuery query = Database.query(EipMCompany.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"cellular", (Throwable)ex);
        }
        return result;
    }

    public static String getCellularUrl(RunData rundata, Context context) {
        ALBaseUser baseUser;
        String loginUrl = ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.EXTERNAL_LOGIN_URL);
        if (loginUrl != null && loginUrl.length() > 0) {
            return loginUrl;
        }
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        try {
            baseUser = (ALBaseUser)JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(jdata.getJetspeedUser().getUserName()));
        }
        catch (JetspeedSecurityException e) {
            baseUser = (ALBaseUser)rundata.getUser();
        }
        String key = baseUser.getUserName() + "_" + ALCellularUtils.getCheckValueForCellLogin((String)baseUser.getUserName(), (String)baseUser.getUserId());
        EipMCompany record = CellularUtils.getEipMCompany(rundata, context);
        String accessUrl = ALServletUtils.getAccessUrl((String)record.getIpaddress(), (int)record.getPort(), (boolean)true);
        String url = accessUrl != null && accessUrl.length() > 0 ? accessUrl + "?key=" + key : "\u793e\u5916\u304b\u3089\u300eAipo\u300f \u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u305f\u3081\u306e\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        return url;
    }
}

