/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message;

import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoomMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.message.MessageUserResultData;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageRoomMemberListSelectData
extends ALAbstractSelectData<TurbineUser, TurbineUser> {
    private int targetUserId;
    private int userId;
    private EipTMessageRoom room;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
    }

    protected ResultList<TurbineUser> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        if (this.targetUserId > 0) {
            TurbineUser tuser = ALEipUtils.getTurbineUser((int)this.targetUserId);
            if (tuser == null) {
                return new ResultList(new ArrayList());
            }
            ArrayList<TurbineUser> memberList = new ArrayList<TurbineUser>();
            memberList.add(tuser);
            return new ResultList(memberList);
        }
        if (!MessageUtils.isJoinRoom(this.room, this.userId)) {
            return new ResultList(new ArrayList());
        }
        List members = this.room.getEipTMessageRoomMember();
        ArrayList<String> memberNames = new ArrayList<String>();
        for (EipTMessageRoomMember member : members) {
            memberNames.add(member.getLoginName());
        }
        SelectQuery query = Database.query(TurbineUser.class);
        Expression exp = ExpressionFactory.inExp((String)"loginName", memberNames);
        query.setQualifier(exp);
        List memberList = query.orderAscending("eipMUserPosition.position").fetchList();
        return new ResultList(memberList);
    }

    protected TurbineUser selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(TurbineUser model) throws ALPageNotFoundException, ALDBErrorException {
        MessageUserResultData rd = new MessageUserResultData();
        rd.initField();
        rd.setUserId(model.getUserId().intValue());
        rd.setFirstName(model.getFirstName());
        rd.setLastName(model.getLastName());
        rd.setFirstNameKana(model.getFirstNameKana());
        rd.setLastNameKana(model.getLastNameKana());
        rd.setHasPhoto("T".equals(model.getHasPhoto()));
        Date photoModified = model.getPhotoModified();
        if (photoModified != null) {
            rd.setPhotoModified(photoModified.getTime());
        }
        return rd;
    }

    protected Object getResultDataDetail(TurbineUser model) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public void setRoom(EipTMessageRoom room) {
        this.room = room;
    }

    public int getRoomId() {
        return this.room.getRoomId();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setTargetUserId(int targetUserId) {
        this.targetUserId = targetUserId;
    }

    public int getTargetUserId() {
        return this.targetUserId;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

