/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message.util;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTMessage;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRead;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoomMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.message.MessageMockPortlet;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.push.ALPushService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.template.BaseJetspeedLink;
import org.apache.jetspeed.util.template.ContentTemplateLink;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageUtils {
    public static final String MESSAGE_PORTLET_NAME = "Message";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MessageUtils.class.getName());
    public static final String FOLDER_FILEDIR_MESSAGE = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final String CATEGORY_KEY = JetspeedResources.getString((String)"aipo.message.categorykey", (String)"");
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");

    public static void setupContext(RunData rundata, Context context) {
        MessageMockPortlet portlet = new MessageMockPortlet();
        context.put("portlet", (Object)portlet);
        context.put("jslink", (Object)new BaseJetspeedLink(rundata));
        context.put("clink", (Object)new ContentTemplateLink(rundata));
    }

    public static void setupContext(RunData rundata, Context context, String portletId) {
        MessageMockPortlet portlet = new MessageMockPortlet(portletId);
        context.put("portlet", (Object)portlet);
        context.put("jslink", (Object)new BaseJetspeedLink(rundata));
        context.put("clink", (Object)new ContentTemplateLink(rundata));
    }

    public static EipTMessage getMessage(int messageId) {
        return (EipTMessage)Database.get(EipTMessage.class, (Object)messageId);
    }

    public static EipTMessageRoom getRoom(int roomId) {
        return (EipTMessageRoom)Database.get(EipTMessageRoom.class, (Object)roomId);
    }

    public static EipTMessageRoom getRoom(int userId, int targetUserId) {
        EipTMessageRoomMember model = (EipTMessageRoomMember)Database.query(EipTMessageRoomMember.class).where(Operations.eq((String)"userId", (Object)userId)).where(Operations.eq((String)"targetUserId", (Object)targetUserId)).fetchSingle();
        if (model != null) {
            return model.getEipTMessageRoom();
        }
        return null;
    }

    public static EipTMessageRoom getRoom(RunData rundata, Context context) throws ALPageNotFoundException {
        Integer roomId = null;
        try {
            try {
                roomId = rundata.getParameters().getInteger("entityid");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (roomId == null) {
                throw new ALPageNotFoundException();
            }
            return (EipTMessageRoom)Database.get(EipTMessageRoom.class, (Object)roomId);
        }
        catch (ALPageNotFoundException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error((Object)"MessageUtils.getRoom", t);
            return null;
        }
    }

    public static boolean isJoinRoom(int roomId, int userId) {
        EipTMessageRoom room = MessageUtils.getRoom(roomId);
        if (room == null) {
            return false;
        }
        return MessageUtils.isJoinRoom(room, userId);
    }

    public static boolean isJoinRoom(EipTMessageRoom room, int userId) {
        List list = room.getEipTMessageRoomMember();
        for (EipTMessageRoomMember member : list) {
            if (member.getUserId() != userId) continue;
            return true;
        }
        return false;
    }

    public static boolean isJoinRoom(EipTMessageFile file, int userId) {
        return MessageUtils.isJoinRoom(file.getRoomId(), userId);
    }

    public static boolean isJoinRoom(EipTMessage message, int userId) {
        EipTMessageRoom room = message.getEipTMessageRoom();
        if (room == null) {
            return false;
        }
        return MessageUtils.isJoinRoom(room, userId);
    }

    public static ResultList<EipTMessage> getMessageList(int roomId, int cursor, int limit, boolean isLatest) {
        StringBuilder select = new StringBuilder();
        select.append("select");
        select.append(" t1.message_id, ");
        select.append(" t1.room_id,  ");
        select.append(" t1.user_id, ");
        select.append(" t1.message, ");
        select.append(" t1.create_date, ");
        select.append(" t1.member_count, ");
        select.append(" t2.last_name, ");
        select.append(" t2.first_name, ");
        select.append(" t2.has_photo, ");
        select.append(" t2.photo_modified, ");
        select.append(" (select count(*) from eip_t_message_read t3 where t3.message_id = t1.message_id and t3.room_id = t1.room_id and t3.is_read = 'F') as unread ");
        StringBuilder count = new StringBuilder();
        count.append("select count(t1.message_id) AS c ");
        StringBuilder body = new StringBuilder();
        body.append("  from eip_t_message t1, turbine_user t2 where t1.user_id = t2.user_id and t1.room_id = #bind($room_id) ");
        if (cursor > 0) {
            if (isLatest) {
                body.append(" and t1.message_id > #bind($cursor) ");
            } else {
                body.append(" and t1.message_id < #bind($cursor) ");
            }
        }
        StringBuilder last = new StringBuilder();
        last.append(" order by t1.create_date desc ");
        if (limit > 0) {
            last.append(" limit ");
            last.append(limit);
        }
        SQLTemplate query = Database.sql(EipTMessage.class, (String)(select.toString() + body.toString() + last.toString())).param("room_id", (Object)roomId);
        if (cursor > 0) {
            query.param("cursor", (Object)cursor);
        }
        List fetchList = query.fetchListAsDataRow();
        ArrayList<EipTMessage> list = new ArrayList<EipTMessage>();
        for (DataRow row : fetchList) {
            Long unread = (Long)row.get((Object)"unread");
            String lastName = (String)row.get((Object)"last_name");
            String firstName = (String)row.get((Object)"first_name");
            String hasPhoto = (String)row.get((Object)"has_photo");
            Date photoModified = (Date)row.get((Object)"photo_modified");
            EipTMessage object = (EipTMessage)Database.objectFromRowData((DataRow)row, EipTMessage.class);
            object.setUnreadCount(unread.intValue());
            object.setFirstName(firstName);
            object.setLastName(lastName);
            object.setHasPhoto(hasPhoto);
            if (photoModified != null) {
                object.setPhotoModified(Long.valueOf(photoModified.getTime()));
            }
            list.add(object);
        }
        return new ResultList(list, -1, -1, list.size());
    }

    public static ResultList<EipTMessageRoom> getRoomList(int userId, String keyword) {
        return MessageUtils.getRoomList(userId, keyword, -1, -1);
    }

    public static ResultList<EipTMessageRoom> getRoomList(int userId) {
        return MessageUtils.getRoomList(userId, null, -1, -1);
    }

    protected static ResultList<EipTMessageRoom> getRoomList(int userId, String keyword, int page, int limit) {
        StringBuilder select = new StringBuilder();
        boolean isMySQL = Database.isJdbcMySQL();
        boolean isSearch = keyword != null && keyword.length() > 0;
        select.append("select");
        select.append(" t2.room_id, ");
        select.append(" t2.name, ");
        select.append(" t2.has_photo, ");
        select.append(" t2.photo_modified, ");
        select.append(" t4.user_id, ");
        select.append(" t4.last_name, ");
        select.append(" t4.first_name, ");
        select.append(" t4.has_photo as user_has_photo, ");
        select.append(" t4.photo_modified as user_photo_modified, ");
        select.append(" t2.auto_name, ");
        select.append(" t2.room_type, ");
        select.append(" t2.last_message, ");
        select.append(" last_update_date, ");
        select.append(" (select count(*) from eip_t_message_read t3 where t3.room_id = t2.room_id and t3.user_id = #bind($user_id) and t3.is_read ='F') as unread ");
        StringBuilder count = new StringBuilder();
        count.append("select count(t2.room_id) AS c ");
        StringBuilder body = new StringBuilder();
        body.append("  from eip_t_message_room_member t1, eip_t_message_room t2, turbine_user t4 where t1.user_id = #bind($user_id) and t1.room_id = t2.room_id and t1.target_user_id = t4.user_id ");
        if (isSearch) {
            if (isMySQL) {
                body.append(" and ((t2.room_type='G' and t2.name like #bind($keyword)) or (t2.room_type='O' and CONCAT(t4.last_name,t4.first_name) like #bind($keyword))) ");
            } else {
                body.append(" and ((t2.room_type='G' and t2.name like #bind($keyword)) or (t2.room_type='O' and (t4.last_name || t4.first_name) like #bind($keyword))) ");
            }
        }
        StringBuilder last = new StringBuilder();
        last.append(" order by t2.last_update_date desc ");
        SQLTemplate countQuery = Database.sql(EipTMessageRoom.class, (String)(count.toString() + body.toString())).param("user_id", (Object)userId);
        if (isSearch) {
            countQuery.param("keyword", (Object)("%" + keyword + "%"));
        }
        int countValue = 0;
        if (page > 0 && limit > 0) {
            List fetchCount = countQuery.fetchListAsDataRow();
            for (DataRow row : fetchCount) {
                countValue = ((Long)row.get((Object)"c")).intValue();
            }
            int offset = 0;
            if (limit > 0) {
                int num = (int)Math.ceil((double)countValue / (double)limit);
                if (num > 0 && num < page) {
                    page = num;
                }
                offset = limit * (page - 1);
            } else {
                page = 1;
            }
            last.append(" LIMIT ");
            last.append(limit);
            last.append(" OFFSET ");
            last.append(offset);
        }
        SQLTemplate query = Database.sql(EipTMessageRoom.class, (String)(select.toString() + body.toString() + last.toString())).param("user_id", (Object)userId);
        if (isSearch) {
            query.param("keyword", (Object)("%" + keyword + "%"));
        }
        List fetchList = query.fetchListAsDataRow();
        ArrayList<EipTMessageRoom> list = new ArrayList<EipTMessageRoom>();
        for (DataRow row : fetchList) {
            Long unread = (Long)row.get((Object)"unread");
            Integer tUserId = (Integer)row.get((Object)"user_id");
            String lastName = (String)row.get((Object)"last_name");
            String firstName = (String)row.get((Object)"first_name");
            String hasPhoto = (String)row.get((Object)"user_has_photo");
            Date photoModified = (Date)row.get((Object)"user_photo_modified");
            EipTMessageRoom object = (EipTMessageRoom)Database.objectFromRowData((DataRow)row, EipTMessageRoom.class);
            object.setUnreadCount(unread.intValue());
            object.setUserId(tUserId);
            object.setFirstName(firstName);
            object.setLastName(lastName);
            object.setUserHasPhoto(hasPhoto);
            if (photoModified != null) {
                object.setUserPhotoModified(Long.valueOf(photoModified.getTime()));
            }
            list.add(object);
        }
        if (page > 0 && limit > 0) {
            return new ResultList(list, page, limit, countValue);
        }
        return new ResultList(list, -1, -1, list.size());
    }

    public static ResultList<TurbineUser> getUserList(String groupName) {
        return MessageUtils.getUserList(groupName, null, -1, -1);
    }

    public static ResultList<TurbineUser> getUserList(String groupName, String keyword) {
        return MessageUtils.getUserList(groupName, keyword, -1, -1);
    }

    public static ResultList<TurbineUser> getUserList(String groupName, String keyword, int page, int limit) {
        StringBuilder select = new StringBuilder();
        boolean isMySQL = Database.isJdbcMySQL();
        boolean isSearch = keyword != null && keyword.length() > 0;
        String keywordKana = "";
        select.append("select distinct t2.user_id, t2.login_name, t2.last_name, t2.first_name, t2.last_name_kana, t2.first_name_kana, t2.has_photo, t2.photo_modified, (t2.last_name_kana = '') ");
        StringBuilder count = new StringBuilder();
        count.append("select count(distinct t2.user_id) AS c ");
        StringBuilder body = new StringBuilder();
        body.append(" from turbine_user_group_role t1, turbine_user t2, turbine_group t3 where t1.user_id = t2.user_id and t1.group_id = t3.group_id and t2.user_id > 3 and t2.disabled = 'F' and t3.group_name = #bind($group_name)");
        if (isSearch) {
            keywordKana = ALStringUtil.convertHiragana2Katakana((String)keyword);
            if (isMySQL) {
                body.append(" and ( (CONCAT(t2.last_name,t2.first_name) like #bind($keyword)) or (CONCAT(t2.last_name_kana,t2.first_name_kana) like #bind($keywordKana)) ) ");
            } else {
                body.append(" and ( ((t2.last_name || t2.first_name)    like #bind($keyword)) or ((t2.last_name_kana || t2.first_name_kana)    like #bind($keywordKana)) ) ");
            }
        }
        StringBuilder last = new StringBuilder();
        last.append(" order by (t2.last_name_kana = ''), t2.last_name_kana, t2.first_name_kana ");
        SQLTemplate countQuery = Database.sql(TurbineUser.class, (String)(count.toString() + body.toString())).param("group_name", (Object)groupName);
        if (isSearch) {
            countQuery.param("keyword", (Object)("%" + keyword + "%"));
            countQuery.param("keywordKana", (Object)("%" + keywordKana + "%"));
        }
        int countValue = 0;
        if (page > 0 && limit > 0) {
            List fetchCount = countQuery.fetchListAsDataRow();
            for (DataRow row : fetchCount) {
                countValue = ((Long)row.get((Object)"c")).intValue();
            }
            int offset = 0;
            if (limit > 0) {
                int num = (int)Math.ceil((double)countValue / (double)limit);
                if (num > 0 && num < page) {
                    page = num;
                }
                offset = limit * (page - 1);
            } else {
                page = 1;
            }
            last.append(" limit ");
            last.append(limit);
            last.append(" offset ");
            last.append(offset);
        }
        SQLTemplate query = Database.sql(TurbineUser.class, (String)(select.toString() + body.toString() + last.toString())).param("group_name", (Object)groupName);
        if (isSearch) {
            query.param("keyword", (Object)("%" + keyword + "%"));
            query.param("keywordKana", (Object)("%" + keywordKana + "%"));
        }
        List list = query.fetchList();
        if (page > 0 && limit > 0) {
            return new ResultList(list, page, limit, countValue);
        }
        return new ResultList(list, -1, -1, list.size());
    }

    public static ResultList<TurbineUser> getReadUserList(int messageId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select t1.user_id, t1.last_name, t1.first_name, t1.has_photo, t1.photo_modified from turbine_user t1, eip_t_message_read t2 where t1.user_id = t2.user_id and t2.message_id = #bind($message_id) and t2.is_read = 'T';");
        SQLTemplate query = Database.sql(TurbineUser.class, (String)sql.toString()).param("message_id", (Object)messageId);
        List list = query.fetchList();
        return new ResultList(list, -1, -1, list.size());
    }

    public static void read(EipTMessageRoom room, int userId, int lastMessageId) {
        SQLTemplate countQuery = Database.sql(EipTMessageRead.class, (String)"select count(*) as c from eip_t_message_read where room_id = #bind($room_id) and user_id = #bind($user_id) and is_read = 'F' and message_id <= #bind($message_id)").param("room_id", (Object)room.getRoomId()).param("user_id", (Object)userId).param("message_id", (Object)lastMessageId);
        int countValue = 0;
        List fetchCount = countQuery.fetchListAsDataRow();
        for (DataRow row : fetchCount) {
            countValue = ((Long)row.get((Object)"c")).intValue();
        }
        if (countValue > 0) {
            String sql = "update eip_t_message_read set is_read = 'T' where room_id = #bind($room_id) and user_id = #bind($user_id) and is_read = 'F' and message_id <= #bind($message_id)";
            Database.sql(EipTMessageRead.class, (String)sql).param("room_id", (Object)room.getRoomId()).param("user_id", (Object)userId).param("message_id", (Object)lastMessageId).execute();
            ArrayList<String> recipients = new ArrayList<String>();
            List members = room.getEipTMessageRoomMember();
            for (EipTMessageRoomMember member : members) {
                if (member.getUserId() == userId) continue;
                recipients.add(member.getLoginName());
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("roomId", String.valueOf(room.getRoomId()));
            ALPushService.pushAsync((String)"messagev2_read", params, recipients);
        }
    }

    public static List<EipTMessageFile> getEipTMessageFilesByRoom(int roomId) {
        return Database.query(EipTMessageFile.class).where(Operations.eq((String)"roomId", (Object)roomId)).fetchList();
    }

    public static List<EipTMessageFile> getEipTMessageFilesByOwner(int userId) {
        return Database.query(EipTMessageFile.class).where(Operations.eq((String)"ownerId", (Object)userId)).fetchList();
    }

    public static EipTMessageFile getEipTMessageFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[MessageUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            SelectQuery query = Database.query(EipTMessageFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = query.fetchList();
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[MessageUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMessageFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MessageUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return ALStorageService.getDocumentPath((String)FOLDER_FILEDIR_MESSAGE, (String)(CATEGORY_KEY + ALStorageService.separator() + uid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileuploadLiteBean> getFileuploadList(RunData rundata) {
        String[] fileids = rundata.getParameters().getStrings("attachments");
        if (fileids == null) {
            return null;
        }
        ArrayList<String> hadfileids = new ArrayList<String>();
        ArrayList<String> newfileids = new ArrayList<String>();
        for (int j = 0; j < fileids.length; ++j) {
            if (fileids[j].trim().startsWith("s")) {
                hadfileids.add(fileids[j].trim().substring(1));
                continue;
            }
            newfileids.add(fileids[j].trim());
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        int fileid = 0;
        if (newfileids.size() > 0) {
            String folderName = rundata.getParameters().getString("folderName");
            if (folderName == null || folderName.equals("")) {
                return null;
            }
            int length = newfileids.size();
            for (int i = 0; i < length; ++i) {
                if (newfileids.get(i) == null || ((String)newfileids.get(i)).equals("")) continue;
                try {
                    fileid = Integer.parseInt((String)newfileids.get(i));
                }
                catch (Exception e) {
                    continue;
                }
                if (fileid == 0) {
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName("photo");
                    filebean.setFileName("");
                    fileNameList.add(filebean);
                    continue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(ALStorageService.getTmpFile((int)ALEipUtils.getUserId((RunData)rundata), (String)folderName, (String)(fileid + ".txt")), FILE_ENCODING));
                    String line = reader.readLine();
                    if (line == null || line.length() <= 0) continue;
                    filebean = new FileuploadLiteBean();
                    filebean.initField();
                    filebean.setFolderName(fileids[i]);
                    filebean.setFileId(fileid);
                    filebean.setFileName(line);
                    fileNameList.add(filebean);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"message", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"message", (Throwable)e);
                    }
                }
            }
        }
        if (hadfileids.size() > 0) {
            ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
            for (int k = 0; k < hadfileids.size(); ++k) {
                try {
                    fileid = Integer.parseInt((String)hadfileids.get(k));
                    hadfileidsValue.add(fileid);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                SelectQuery reqquery = Database.query(EipTMessageFile.class);
                Expression reqexp1 = ExpressionFactory.inDbExp((String)"FILE_ID", hadfileidsValue);
                reqquery.setQualifier(reqexp1);
                List requests = reqquery.fetchList();
                int requestssize = requests.size();
                for (int i = 0; i < requestssize; ++i) {
                    EipTMessageFile file = (EipTMessageFile)requests.get(i);
                    filebean = new FileuploadBean();
                    filebean.initField();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(file.getFileName());
                    filebean.setFlagNewFile(false);
                    fileNameList.add(filebean);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"[MessageUtils] Exception.", (Throwable)ex);
            }
        }
        return fileNameList;
    }

    public static Map<Integer, Long> getReadCountList(int roomId, int userId, int minMessageId, int maxMessageId) {
        SQLTemplate query = Database.sql(EipTMessageRead.class, (String)"select message_id, is_read, count(*) as c from eip_t_message_read where room_id = #bind($room_id) and user_id <> #bind($user_id) and message_id >= #bind($min_message_id) and message_id <= #bind($max_message_id) group by message_id, is_read order by message_id desc").param("room_id", (Object)roomId).param("user_id", (Object)userId).param("min_message_id", (Object)minMessageId).param("max_message_id", (Object)maxMessageId);
        List fetchList = query.fetchListAsDataRow();
        HashMap<Integer, MessageReadEntry> maps = new HashMap<Integer, MessageReadEntry>();
        HashMap<Integer, Long> result = new HashMap<Integer, Long>();
        for (DataRow row : fetchList) {
            Long count = (Long)row.get((Object)"c");
            Integer messageId = (Integer)row.get((Object)"message_id");
            String isRead = (String)row.get((Object)"is_read");
            MessageReadEntry read = (MessageReadEntry)maps.get(messageId);
            if (read == null) {
                read = new MessageReadEntry();
            }
            if ("T".equals(isRead)) {
                read.setRead(count);
            } else {
                read.setUnread(count);
            }
            maps.put(messageId, read);
        }
        for (Map.Entry next : maps.entrySet()) {
            MessageReadEntry value = (MessageReadEntry)next.getValue();
            if (value.getUnread() == null) {
                result.put((Integer)next.getKey(), -1L);
                continue;
            }
            result.put((Integer)next.getKey(), value.getRead() == null ? Long.valueOf(0L) : value.getRead());
        }
        return result;
    }

    public static class MessageReadEntry {
        private Long read;
        private Long unread;

        public Long getRead() {
            return this.read;
        }

        public void setRead(Long read) {
            this.read = read;
        }

        public Long getUnread() {
            return this.unread;
        }

        public void setUnread(Long unread) {
            this.unread = unread;
        }
    }
}

