/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.fop.afp.fonts.CharacterSetType;

public abstract class CharactersetEncoder {
    private final CharsetEncoder encoder;

    private CharactersetEncoder(String encoding) {
        this.encoder = Charset.forName(encoding).newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    final boolean canEncode(char c) {
        return this.encoder.canEncode(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final EncodedChars encode(CharSequence chars) throws CharacterCodingException {
        ByteBuffer bb;
        CharsetEncoder charsetEncoder = this.encoder;
        synchronized (charsetEncoder) {
            bb = this.encoder.encode(CharBuffer.wrap(chars));
        }
        if (bb.hasArray()) {
            return this.getEncodedChars(bb.array(), bb.limit());
        }
        bb.rewind();
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        return this.getEncodedChars(bytes, bytes.length);
    }

    abstract EncodedChars getEncodedChars(byte[] var1, int var2);

    public static EncodedChars encodeSBCS(CharSequence chars, String encoding) throws CharacterCodingException {
        CharactersetEncoder encoder = CharactersetEncoder.newInstance(encoding, CharacterSetType.SINGLE_BYTE);
        return encoder.encode(chars);
    }

    static CharactersetEncoder newInstance(String encoding, CharacterSetType charsetType) {
        switch (charsetType) {
            case DOUBLE_BYTE_LINE_DATA: {
                return new EbcdicDoubleByteLineDataEncoder(encoding);
            }
            case DOUBLE_BYTE: {
                return new DefaultEncoder(encoding, true);
            }
        }
        return new DefaultEncoder(encoding, false);
    }

    public static class EncodedChars {
        private final byte[] bytes;
        private final int offset;
        private final int length;
        private final boolean isDBCS;

        private EncodedChars(byte[] bytes, int offset, int length, boolean isDBCS) {
            if (offset < 0 || length < 0 || offset + length > bytes.length) {
                throw new IllegalArgumentException();
            }
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
            this.isDBCS = isDBCS;
        }

        private EncodedChars(byte[] bytes, boolean isDBCS) {
            this(bytes, 0, bytes.length, isDBCS);
        }

        public void writeTo(OutputStream out, int offset, int length) throws IOException {
            if (offset < 0 || length < 0 || offset + length > this.bytes.length) {
                throw new IllegalArgumentException();
            }
            out.write(this.bytes, this.offset + offset, length);
        }

        public int getLength() {
            return this.length;
        }

        public boolean isDBCS() {
            return this.isDBCS;
        }

        public byte[] getBytes() {
            byte[] copy = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
            return copy;
        }
    }

    private static final class DefaultEncoder
    extends CharactersetEncoder {
        private final boolean isDBCS;

        private DefaultEncoder(String encoding, boolean isDBCS) {
            super(encoding);
            this.isDBCS = isDBCS;
        }

        EncodedChars getEncodedChars(byte[] byteArray, int length) {
            return new EncodedChars(byteArray, this.isDBCS);
        }
    }

    private static final class EbcdicDoubleByteLineDataEncoder
    extends CharactersetEncoder {
        private EbcdicDoubleByteLineDataEncoder(String encoding) {
            super(encoding);
        }

        EncodedChars getEncodedChars(byte[] byteArray, int length) {
            if (byteArray[0] == 14 && byteArray[length - 1] == 15) {
                return new EncodedChars(byteArray, 1, length - 2, true);
            }
            return new EncodedChars(byteArray, true);
        }
    }
}

