/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Node;

public final class FunctionCall
extends Expr {
    final XPathFunctionResolver resolver;
    final String name;
    final List args;

    public final Object evaluate(Node context, int pos, int len) {
        int arity;
        QName qname;
        XPathFunction function;
        if (this.resolver != null && (function = this.resolver.resolveFunction(qname = QName.valueOf(this.name), arity = this.args.size())) != null) {
            if (function instanceof Expr) {
                if (function instanceof Function) {
                    ((Function)((Object)function)).setArguments(this.args);
                }
                return ((Expr)((Object)function)).evaluate(context, pos, len);
            }
            ArrayList values = new ArrayList(arity);
            int i = 0;
            while (i < arity) {
                Expr arg = (Expr)this.args.get(i);
                values.add(arg.evaluate(context, pos, len));
                ++i;
            }
            try {
                return function.evaluate(values);
            }
            catch (XPathFunctionException e) {
                e.printStackTrace(System.err);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Invalid function call: " + this.toString());
    }

    public final Expr clone(Object context) {
        int len = this.args.size();
        ArrayList args2 = new ArrayList(len);
        int i = 0;
        while (i < len) {
            args2.add(((Expr)this.args.get(i)).clone(context));
            ++i;
        }
        XPathFunctionResolver r = this.resolver;
        if (context instanceof XPathFunctionResolver) {
            r = (XPathFunctionResolver)context;
        }
        return new FunctionCall(r, this.name, args2);
    }

    public final boolean references(QName var) {
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (!((Expr)i.next()).references(var)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append('(');
        int len = this.args.size();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.args.get(i));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public FunctionCall(XPathFunctionResolver resolver, String name) {
        this(resolver, name, Collections.EMPTY_LIST);
    }

    public FunctionCall(XPathFunctionResolver resolver, String name, List args) {
        this.resolver = resolver;
        this.name = name;
        this.args = args;
    }
}

