package org.cdavies.itunes;

import org.cdavies.itunes.request.*;

public interface ItunesConnection {
	
	public boolean isConnected();
	public void connect() throws NoServerPermissionException;
	public void disconnect();
	
	public int getRequestNumber();
	
	public Database[] getDatabases();
	public Track[] getTracklist(int databaseId);
	
	public String getServerName();
	public int getPort();
	public int getSessionId();
	
}
