/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.params;

import gnu.javax.crypto.jce.params.DEREncodingException;
import java.math.BigInteger;

class DERReader {
    static final int UNIVERSAL = 1;
    static final int APPLICATION = 2;
    static final int CONTEXT_SPECIFIC = 3;
    static final int PRIVATE = 4;
    byte[] source;
    int pos;

    public void init(String string) {
        this.init(string.getBytes());
    }

    public void init(byte[] byArray) {
        this.source = byArray;
        this.pos = 0;
    }

    public boolean hasMorePrimitives() {
        boolean bl = false;
        if (this.pos < this.source.length) {
            bl = true;
        }
        return bl;
    }

    public BigInteger getBigInteger() throws DEREncodingException {
        return new BigInteger(this.getPrimitive());
    }

    private final byte[] getPrimitive() throws DEREncodingException {
        byte by;
        int n = this.pos;
        if ((0x20 & (by = this.source[n++])) != 0) {
            throw new DEREncodingException();
        }
        int n2 = this.translateLeadIdentifierByte(by);
        int n3 = 0x1F & by;
        int n4 = this.source[n];
        long l = 0x7F & n4;
        if ((0x80 & n4) != 0) {
            n4 = (byte)(n4 & 0x7F);
            l = 0L;
            int n5 = 0;
            while (n5 < n4) {
                l <<= 8;
                l += (long)(this.source[++n] < 0 ? 256 + this.source[n] : this.source[n]);
                ++n5;
            }
            ++n;
        } else {
            ++n;
        }
        byte[] byArray = new byte[(int)l];
        System.arraycopy(this.source, n, byArray, 0, (int)l);
        this.pos = (int)((long)n + l);
        return byArray;
    }

    private final int translateLeadIdentifierByte(byte by) {
        if ((0x3F & by) == by) {
            return 1;
        }
        if ((0x7F & by) == by) {
            return 2;
        }
        if ((0xBF & by) == by) {
            return 3;
        }
        return 4;
    }

    private final int getIdentifier(int n) {
        while ((0x80 & this.source[n]) != 0) {
            ++n;
        }
        return n;
    }

    public DERReader() {
        this.source = null;
        this.pos = 0;
    }

    public DERReader(byte[] byArray) {
        this.init(byArray);
    }
}

