/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyModifier;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ProjectTestFixtures;

@Incubating
public interface TestFixturesDependencyModifiers {
    @Nested
    public TestFixturesDependencyModifier getTestFixtures();

    @Incubating
    public static abstract class TestFixturesDependencyModifier
    extends DependencyModifier {
        protected void modifyImplementation(ModuleDependency dependency) {
            if (dependency instanceof ExternalDependency) {
                String group = dependency.getGroup();
                String name = dependency.getName() + "-test-fixtures";
                dependency.capabilities(capabilities -> capabilities.requireCapability((Object)new DefaultImmutableCapability(group, name, null)));
            } else if (dependency instanceof ProjectDependency) {
                ProjectDependency projectDependency = (ProjectDependency)Cast.uncheckedCast((Object)dependency);
                projectDependency.capabilities((Action)new ProjectTestFixtures(projectDependency.getDependencyProject()));
            } else {
                throw new IllegalStateException("Unknown dependency type: " + dependency.getClass());
            }
        }
    }
}

