/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.declarative.dsl.schema.AnalysisSchema;
import org.gradle.declarative.dsl.schema.DataType;
import org.gradle.declarative.dsl.schema.DataTypeRef;
import org.gradle.internal.declarativedsl.analysis.TypeRefContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/SchemaTypeRefContext;", "Lorg/gradle/internal/declarativedsl/analysis/TypeRefContext;", "schema", "Lorg/gradle/declarative/dsl/schema/AnalysisSchema;", "(Lorg/gradle/declarative/dsl/schema/AnalysisSchema;)V", "getSchema", "()Lorg/gradle/declarative/dsl/schema/AnalysisSchema;", "resolveRef", "Lorg/gradle/declarative/dsl/schema/DataType;", "dataTypeRef", "Lorg/gradle/declarative/dsl/schema/DataTypeRef;", "declarative-dsl-core"})
public final class SchemaTypeRefContext
implements TypeRefContext {
    @NotNull
    private final AnalysisSchema schema;

    public SchemaTypeRefContext(@NotNull AnalysisSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
    }

    @NotNull
    public final AnalysisSchema getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public DataType resolveRef(@NotNull DataTypeRef dataTypeRef) {
        DataType dataType;
        Intrinsics.checkNotNullParameter((Object)dataTypeRef, (String)"dataTypeRef");
        DataTypeRef dataTypeRef2 = dataTypeRef;
        if (dataTypeRef2 instanceof DataTypeRef.Name) {
            dataType = (DataType)MapsKt.getValue((Map)this.schema.getDataClassesByFqName(), (Object)((DataTypeRef.Name)dataTypeRef).getFqName());
        } else if (dataTypeRef2 instanceof DataTypeRef.Type) {
            dataType = ((DataTypeRef.Type)dataTypeRef).getDataType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dataType;
    }
}

