/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.text.DecimalFormat;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractHostPlugin;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;

public class HostProcess
implements Runnable {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$core$scanner$HostProcess == null ? (class$org$parosproxy$paros$core$scanner$HostProcess = HostProcess.class$("org.parosproxy.paros.core.scanner.HostProcess")) : class$org$parosproxy$paros$core$scanner$HostProcess);
    private static DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private SiteNode startNode = null;
    private boolean isStop = false;
    private PluginFactory pluginFactory = null;
    private ScannerParam scannerParam = null;
    private HttpSender httpSender = null;
    private ThreadPool threadPool = null;
    private Scanner parentScanner = null;
    private String hostAndPort = "";
    private Analyser analyser = null;
    private Kb kb = null;
    private HashMap mapPluginStartTime = new HashMap();
    private long hostProcessStartTime = 0L;
    static /* synthetic */ Class class$org$parosproxy$paros$core$scanner$HostProcess;

    public HostProcess(String string, Scanner scanner, ScannerParam scannerParam, ConnectionParam connectionParam) {
        this.hostAndPort = string;
        this.parentScanner = scanner;
        this.scannerParam = scannerParam;
        this.httpSender = new HttpSender(connectionParam, true);
        this.threadPool = new ThreadPool(scannerParam.getThreadPerHost());
    }

    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
    }

    public void stop() {
        this.isStop = true;
        this.getAnalyser().stop();
    }

    public void run() {
        this.hostProcessStartTime = System.currentTimeMillis();
        this.getAnalyser().start(this.startNode);
        Plugin plugin = null;
        while (!this.isStop && this.getPluginFactory().existPluginToRun()) {
            plugin = this.getPluginFactory().nextPlugin();
            if (plugin != null) {
                this.processPlugin(plugin);
                continue;
            }
            Util.sleep(1000);
        }
        this.threadPool.waitAllThreadComplete(300000);
        this.notifyHostProgress(null);
        this.notifyHostComplete();
        this.getHttpSender().shutdown();
    }

    private void processPlugin(Plugin plugin) {
        log.info("start host " + this.hostAndPort + " | " + plugin.getCodeName());
        this.mapPluginStartTime.put(new Long(plugin.getId()), new Long(System.currentTimeMillis()));
        if (plugin instanceof AbstractHostPlugin) {
            this.scanSingleNode(plugin, this.startNode);
        } else if (plugin instanceof AbstractAppPlugin) {
            this.traverse(plugin, this.startNode);
            this.threadPool.waitAllThreadComplete(600000);
            this.pluginCompleted(plugin);
        }
    }

    private PluginFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = new PluginFactory();
        }
        return this.pluginFactory;
    }

    private void traverse(Plugin plugin, SiteNode siteNode) {
        if (siteNode == null || plugin == null) {
            return;
        }
        this.scanSingleNode(plugin, siteNode);
        for (int i = 0; i < siteNode.getChildCount() && !this.isStop(); ++i) {
            try {
                this.traverse(plugin, (SiteNode)siteNode.getChildAt(i));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void scanSingleNode(Plugin plugin, SiteNode siteNode) {
        Thread thread = null;
        Plugin plugin2 = null;
        HttpMessage httpMessage = null;
        try {
            if (siteNode == null) {
                return;
            }
            httpMessage = siteNode.getHistoryReference().getHttpMessage();
            plugin2 = (Plugin)plugin.getClass().newInstance();
            plugin2.setConfig(plugin.getConfig());
            plugin2.init(httpMessage, this);
            this.notifyHostProgress(plugin.getName() + ": " + httpMessage.getRequestHeader().getURI().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        do {
            if ((thread = this.threadPool.getFreeThreadAndRun(plugin2)) != null) continue;
            Util.sleep(200);
        } while (thread == null);
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public boolean isStop() {
        return this.isStop || this.parentScanner.isStop();
    }

    private void notifyHostProgress(String string) {
        int n = 0;
        n = this.getPluginFactory().totalPluginToRun() == 0 ? 100 : 100 * this.getPluginFactory().totalPluginCompleted() / this.getPluginFactory().totalPluginToRun();
        this.parentScanner.notifyHostProgress(this.hostAndPort, string, n);
    }

    private void notifyHostComplete() {
        long l = System.currentTimeMillis() - this.hostProcessStartTime;
        String string = decimalFormat.format((double)l / 1000.0) + "s";
        log.info("completed host " + this.hostAndPort + " in " + string);
        this.parentScanner.notifyHostComplete(this.hostAndPort);
    }

    public void alertFound(Alert alert) {
        this.parentScanner.notifyAlertFound(alert);
    }

    public Analyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = new Analyser(this.getHttpSender());
        }
        return this.analyser;
    }

    void pluginCompleted(Plugin plugin) {
        Object v = this.mapPluginStartTime.get(new Long(plugin.getId()));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isStop) {
            stringBuffer.append("stopped host/plugin ");
        } else {
            stringBuffer.append("completed host/plugin ");
        }
        stringBuffer.append(this.hostAndPort + " | " + plugin.getCodeName());
        if (v != null) {
            long l = (Long)v;
            long l2 = System.currentTimeMillis() - l;
            String string = decimalFormat.format((double)l2 / 1000.0) + "s";
            stringBuffer.append(" in " + string);
        }
        log.info(stringBuffer.toString());
        this.getPluginFactory().setRunningPluginCompleted(plugin);
        this.notifyHostProgress(null);
    }

    Kb getKb() {
        if (this.kb == null) {
            this.kb = new Kb();
        }
        return this.kb;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

