/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class ProxyListenerLog
implements ProxyListener {
    private ViewDelegate view = null;
    private Model model = null;
    private HistoryList historyList = null;
    private Pattern pattern = null;
    private boolean isFirstAccess = true;

    public ProxyListenerLog(Model model, ViewDelegate viewDelegate, HistoryList historyList) {
        this.model = model;
        this.view = viewDelegate;
        this.historyList = historyList;
    }

    public void setFilter(String string) {
        this.pattern = string == null || string.equals("") ? null : Pattern.compile(string, 10);
    }

    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpMessage httpMessage2 = this.model.getSession().getSiteTree().pollPath(httpMessage);
        if (httpMessage2 != null && !httpMessage2.getResponseHeader().isEmpty() && HttpStatusCode.isSuccess(httpMessage2.getResponseHeader().getStatusCode())) {
            return;
        }
        if (httpMessage.getRequestHeader().getHeader("If-Modified-Since") != null) {
            httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        }
        if (httpMessage.getRequestHeader().getHeader("If-None-Match") != null) {
            httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        }
    }

    public void onHttpResponseReceive(final HttpMessage httpMessage) {
        int n = 1;
        if (this.isSkipImage(httpMessage.getRequestHeader()) || this.isSkipImage(httpMessage.getResponseHeader())) {
            if (httpMessage.getResponseHeader().getStatusCode() == 200) {
                n = 6;
            } else {
                return;
            }
        }
        final int n2 = n;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ProxyListenerLog.this.addHistory(httpMessage, n2);
            }
        });
        thread.start();
    }

    public boolean isSkipImage(HttpHeader httpHeader) {
        return httpHeader.isImage() && !this.model.getOptionsParam().getViewParam().isProcessImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistory(HttpMessage httpMessage, int n) {
        Object object;
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(this.model.getSession(), n, httpMessage);
        }
        catch (Exception exception) {
            return;
        }
        if (n != 1 && n != 6) {
            return;
        }
        Object object2 = this.historyList;
        synchronized (object2) {
            if (n == 1) {
                if (this.pattern == null) {
                    this.addHistoryInEventQueue(historyReference);
                } else {
                    object = new StringBuffer();
                    ((StringBuffer)object).append(httpMessage.getRequestHeader().toString());
                    ((StringBuffer)object).append(httpMessage.getRequestBody().toString());
                    if (!httpMessage.getResponseHeader().isEmpty()) {
                        ((StringBuffer)object).append(httpMessage.getResponseHeader().toString());
                        ((StringBuffer)object).append(httpMessage.getResponseBody().toString());
                    }
                    if (this.pattern.matcher(((StringBuffer)object).toString()).find()) {
                        this.addHistoryInEventQueue(historyReference);
                    }
                }
            }
        }
        object2 = historyReference;
        object = httpMessage;
        if (EventQueue.isDispatchThread()) {
            this.model.getSession().getSiteTree().addPath((HistoryReference)object2, httpMessage);
            if (this.isFirstAccess) {
                this.isFirstAccess = false;
                this.view.getSiteTreePanel().expandRoot();
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable((HistoryReference)object2, (HttpMessage)object){
                    private final /* synthetic */ HistoryReference val$ref;
                    private final /* synthetic */ HttpMessage val$finalMsg;
                    {
                        this.val$ref = historyReference;
                        this.val$finalMsg = httpMessage;
                    }

                    public void run() {
                        ProxyListenerLog.this.model.getSession().getSiteTree().addPath(this.val$ref, this.val$finalMsg);
                        if (ProxyListenerLog.this.isFirstAccess) {
                            ProxyListenerLog.this.isFirstAccess = false;
                            ProxyListenerLog.this.view.getSiteTreePanel().expandRoot();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addHistoryInEventQueue(final HistoryReference historyReference) {
        if (EventQueue.isDispatchThread()) {
            this.historyList.addElement(historyReference);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ProxyListenerLog.this.historyList.addElement(historyReference);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

