<?php

/**
 * PluginPost
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginPost extends BasePost {

    protected $buzzConfigService;
    protected $buzzTimeZoneUtility;

    public function getEmployeeFirstLastName() {
        if ($this->getEmployeeNumber() != '') {
            return $this->getEmployeePostAdded()->getFirstAndLastNames();
        } else {
            return 'Admin';
        }
    }

    /**
     * 
     * @return BuzzConfigService
     */
    private function getBuzzConfigService() {
        if (!$this->buzzConfigService) {
            $this->buzzConfigService = new BuzzConfigService();
        }

        return $this->buzzConfigService;
    }

    public function getDate() {
        return set_datepicker_date_format($this->getPostTime());
    }

    public function getTime() {
        $timeFormat = $this->getBuzzConfigService()->getTimeFormat();
        return date($timeFormat, strtotime($this->getPostTime()));
    }

    public function __call($method, $arguments) {
        if ($method == 'getPostTime') {
            $offset = sfContext::getInstance()->getUser()->getUserTimeZoneOffsetForBuzz();
            $postTime = parent::__call($method, $arguments);
            if(!isset($offset) || is_null($offset)){
                return $postTime;
            }
            $date = gmdate('Y-m-d H:i:s',strtotime($postTime));
            $given = new DateTime($date,new DateTimeZone('+0:00'));
            $given->setTimezone(new DateTimeZone($this->getBuzzTimezoneUtility()->getTimeZoneFromClientOffset($offset)));
            return $given->format("Y-m-d H:i:s");
        }
        return parent::__call($method, $arguments);
    }


    public function getBuzzTimezoneUtility() {
        if(!$this->buzzTimeZoneUtility instanceof BuzzTimezoneUtility) {
            $this->buzzTimeZoneUtility = new BuzzTimezoneUtility();
        }
        return $this->buzzTimeZoneUtility;
    }

}
