/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class RuleBasedCollator
extends Collator {
    static final CollationElement SPECIAL_UNKNOWN_SEQ = new CollationElement("", Short.MAX_VALUE, 0, 0, 0, null, false);
    private String rules;
    private Object[] ce_table;
    HashMap prefix_tree;
    private int last_primary_value;
    private int last_tertiary_value;
    private boolean inverseAccentComparison;

    static int findPrefixLength(String prefix, String s) {
        int len = prefix.length();
        int index = 0;
        while (index < len && index < s.length()) {
            if (prefix.charAt(index) != s.charAt(index)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private final void mergeRules(int offset, String starter, ArrayList main, ArrayList patch) throws ParseException {
        int insertion_point = -1;
        int max_length = 0;
        int i = 0;
        while (i < patch.size()) {
            int j = 0;
            while (j < main.size()) {
                CollationSorter rule1 = (CollationSorter)patch.get(i);
                CollationSorter rule2 = (CollationSorter)main.get(j);
                if (rule1.textElement.equals(rule2.textElement)) {
                    main.remove(j);
                    continue;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < main.size()) {
            CollationSorter sorter = (CollationSorter)main.get(i);
            int length = RuleBasedCollator.findPrefixLength(starter, sorter.textElement);
            if (length > max_length) {
                max_length = length;
                insertion_point = i + 1;
            }
            ++i;
        }
        if (insertion_point < 0) {
            throw new ParseException("no insertion point found for " + starter, offset);
        }
        if (max_length < starter.length()) {
            CollationSorter sorter = (CollationSorter)patch.get(0);
            CollationSorter expansionPrefix = (CollationSorter)main.get(insertion_point - 1);
            sorter.expansionOrdering = starter.substring(max_length);
            main.add(insertion_point, sorter);
            patch.remove(0);
            ++insertion_point;
        }
        i = 0;
        while (i < patch.size()) {
            main.add(i + insertion_point, patch.get(i));
            ++i;
        }
    }

    private final int subParseString(boolean stop_on_reset, ArrayList v, int base_offset, String rules) throws ParseException {
        boolean bl = false;
        if (base_offset == 0) {
            bl = true;
        }
        boolean ignoreChars = bl;
        int operator = -1;
        StringBuffer sb = new StringBuffer();
        boolean doubleQuote = false;
        boolean eatingChars = false;
        boolean nextIsModifier = false;
        boolean isModifier = false;
        int i = 0;
        block10: while (i < rules.length()) {
            char c = rules.charAt(i);
            int type = -1;
            if (eatingChars || (c < '\t' || c > '\r') && c != ' ') {
                isModifier = nextIsModifier;
                nextIsModifier = false;
                if (eatingChars && c != '\'') {
                    doubleQuote = false;
                    sb.append(c);
                } else if (doubleQuote && eatingChars) {
                    sb.append(c);
                    doubleQuote = false;
                } else {
                    switch (c) {
                        case '!': {
                            throw new ParseException("Modifier '!' is not yet supported by Classpath", i + base_offset);
                        }
                        case '<': {
                            type = 0;
                            break;
                        }
                        case ';': {
                            type = 1;
                            break;
                        }
                        case ',': {
                            type = 2;
                            break;
                        }
                        case '=': {
                            type = 3;
                            break;
                        }
                        case '\'': {
                            eatingChars ^= true;
                            doubleQuote = true;
                            break;
                        }
                        case '@': {
                            if (ignoreChars) {
                                throw new ParseException("comparison list has not yet been started. You may only use(<,;=&)", i + base_offset);
                            }
                            nextIsModifier = true;
                            type = 5;
                            break;
                        }
                        case '&': {
                            type = 4;
                            if (!stop_on_reset) break;
                            break block10;
                        }
                        default: {
                            if (operator < 0) {
                                throw new ParseException("operator missing at " + (i + base_offset), i + base_offset);
                            }
                            if (!eatingChars && (c >= '!' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~')) {
                                throw new ParseException("unquoted punctuation character '" + c + '\'', i + base_offset);
                            }
                            sb.append(c);
                            break;
                        }
                    }
                    if (type >= 0) {
                        if (operator < 0) {
                            operator = type;
                        } else {
                            if (sb.length() == 0 && !isModifier) {
                                throw new ParseException("text element empty at " + (i + base_offset), i + base_offset);
                            }
                            if (operator == 4) {
                                String subrules = rules.substring(i);
                                ArrayList sorted_rules = new ArrayList();
                                int idx = this.subParseString(true, sorted_rules, base_offset + i, subrules);
                                this.mergeRules(base_offset + i, sb.toString(), v, sorted_rules);
                                sb.setLength(0);
                                operator = -1;
                                type = -1;
                                if (idx < 0) break;
                                i += idx - 1;
                            } else {
                                CollationSorter sorter = new CollationSorter();
                                if (operator == 0) {
                                    ignoreChars = false;
                                }
                                sorter.comparisonType = operator;
                                sorter.textElement = sb.toString();
                                sorter.hashText = sorter.textElement.hashCode();
                                sorter.offset = base_offset + rules.length();
                                sorter.ignore = ignoreChars;
                                sb.setLength(0);
                                v.add(sorter);
                                operator = type;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (operator >= 0) {
            CollationSorter sorter = new CollationSorter();
            int pos = rules.length() + base_offset;
            if (sb.length() != 0 && nextIsModifier || sb.length() == 0 && !nextIsModifier && !eatingChars) {
                throw new ParseException("text element empty at " + pos, pos);
            }
            if (operator == 0) {
                ignoreChars = false;
            }
            sorter.comparisonType = operator;
            sorter.textElement = sb.toString();
            sorter.hashText = sorter.textElement.hashCode();
            sorter.offset = base_offset + pos;
            sorter.ignore = ignoreChars;
            v.add(sorter);
        }
        if (i == rules.length()) {
            return -1;
        }
        return i;
    }

    public Object clone() {
        return super.clone();
    }

    private final ArrayList parseString(String rules) throws ParseException {
        ArrayList v = new ArrayList();
        this.subParseString(false, v, 0, rules);
        return v;
    }

    private final void buildCollationVector(ArrayList parsedElements) throws ParseException {
        int primary_seq = 0;
        short last_tertiary_seq = 0;
        short secondary_seq = 0;
        short tertiary_seq = 0;
        short equality_seq = 0;
        boolean inverseComparisons = false;
        boolean DECREASING = false;
        boolean INCREASING = true;
        boolean secondaryType = true;
        ArrayList v = new ArrayList();
        int i = 0;
        while (i < parsedElements.size()) {
            block12: {
                CollationSorter elt = (CollationSorter)parsedElements.get(i);
                boolean ignoreChar = false;
                switch (elt.comparisonType) {
                    case 0: {
                        ++primary_seq;
                        if (inverseComparisons) {
                            secondary_seq = Short.MAX_VALUE;
                            secondaryType = false;
                        } else {
                            secondary_seq = 0;
                            secondaryType = true;
                        }
                        tertiary_seq = 0;
                        equality_seq = 0;
                        inverseComparisons = false;
                        break;
                    }
                    case 1: {
                        secondary_seq = !secondaryType ? (short)((short)(secondary_seq - 1)) : (short)((short)(secondary_seq + 1));
                        tertiary_seq = 0;
                        equality_seq = 0;
                        break;
                    }
                    case 5: {
                        inverseComparisons = true;
                        break block12;
                    }
                    case 2: {
                        tertiary_seq = (short)(tertiary_seq + 1);
                        if (primary_seq == 0) {
                            last_tertiary_seq = tertiary_seq;
                        }
                        equality_seq = 0;
                        break;
                    }
                    case 3: {
                        equality_seq = (short)(equality_seq + 1);
                        break;
                    }
                    case 4: {
                        throw new ParseException("Invalid reached state 'RESET'. Internal error", elt.offset);
                    }
                    default: {
                        throw new ParseException("Invalid unknown state '" + elt.comparisonType + '\'', elt.offset);
                    }
                }
                v.add(new CollationElement(elt.textElement, primary_seq, secondary_seq, tertiary_seq, equality_seq, elt.expansionOrdering, elt.ignore));
            }
            ++i;
        }
        this.inverseAccentComparison = inverseComparisons;
        this.ce_table = v.toArray();
        this.last_primary_value = primary_seq + 1;
        this.last_tertiary_value = last_tertiary_seq + 1;
    }

    private final void buildPrefixAccess() {
        this.prefix_tree = new HashMap();
        int i = 0;
        while (i < this.ce_table.length) {
            CollationElement e = (CollationElement)this.ce_table[i];
            this.prefix_tree.put(e.key, e);
            ++i;
        }
    }

    public int compare(String source, String target) {
        CollationElement ord1block = null;
        CollationElement ord2block = null;
        boolean advance_block_1 = true;
        boolean advance_block_2 = true;
        CollationElementIterator cs = this.getCollationElementIterator(source);
        CollationElementIterator ct = this.getCollationElementIterator(target);
        while (true) {
            short tert2;
            short sec2;
            if (advance_block_1 && (ord1block = cs.nextBlock()) != null && ord1block.ignore) continue;
            if (advance_block_2) {
                ord2block = ct.nextBlock();
                if (ord2block != null && ord2block.ignore) {
                    advance_block_1 = false;
                    continue;
                }
            } else {
                advance_block_2 = true;
            }
            if (!advance_block_1) {
                advance_block_1 = true;
            }
            if (ord1block == null) {
                if (ord2block == null) {
                    return 0;
                }
                return -1;
            }
            int ord1 = ord1block.getValue();
            if (ord2block == null) {
                return 1;
            }
            int ord2 = ord2block.getValue();
            if (ord1 == ord2) {
                if (this.getStrength() != 3 || ord1block.key.equals(ord2block.key)) continue;
                return ord1block.key.compareTo(ord2block.key);
            }
            int prim1 = CollationElementIterator.primaryOrder(ord1);
            int prim2 = CollationElementIterator.primaryOrder(ord2);
            if (prim1 == 0 && this.getStrength() < 2) {
                advance_block_2 = false;
                continue;
            }
            if (prim2 == 0 && this.getStrength() < 2) {
                advance_block_1 = false;
                continue;
            }
            if (prim1 < prim2) {
                return -1;
            }
            if (prim1 > prim2) {
                return 1;
            }
            if (this.getStrength() == 0) continue;
            short sec1 = CollationElementIterator.secondaryOrder(ord1);
            if (sec1 < (sec2 = CollationElementIterator.secondaryOrder(ord2))) {
                return -1;
            }
            if (sec1 > sec2) {
                return 1;
            }
            if (this.getStrength() == 1) continue;
            short tert1 = CollationElementIterator.tertiaryOrder(ord1);
            if (tert1 < (tert2 = CollationElementIterator.tertiaryOrder(ord2))) {
                return -1;
            }
            if (tert1 > tert2) {
                return 1;
            }
            if (this.getStrength() != 2) break;
        }
        return ord1block.key.compareTo(ord2block.key);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    CollationElement getDefaultElement(char c) {
        int v = this.inverseAccentComparison && c >= '\u02b9' && c <= '\u0361' ? 865 - (c - 697) : (int)c;
        return new CollationElement("" + c, this.last_primary_value + v, 0, 0, 0, null, false);
    }

    CollationElement getDefaultAccentedElement(char c) {
        int v = this.inverseAccentComparison && c >= '\u02b9' && c <= '\u0361' ? 865 - (c - 697) : (int)c;
        return new CollationElement("" + c, 0, 0, (short)(this.last_tertiary_value + v), 0, null, false);
    }

    public CollationElementIterator getCollationElementIterator(String source) {
        return new CollationElementIterator(this, source);
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator source) {
        StringBuffer expand = new StringBuffer("");
        char c = source.first();
        while (c != (char)-1) {
            this.decomposeCharacter(c, expand);
            c = source.next();
        }
        return this.getCollationElementIterator(expand.toString());
    }

    public CollationKey getCollationKey(String source) {
        CollationElementIterator cei = this.getCollationElementIterator(source);
        ArrayList vect = new ArrayList();
        int ord = cei.next();
        cei.reset();
        while (ord != -1) {
            if (CollationElementIterator.primaryOrder(ord) == 0) {
                ord = cei.next();
                continue;
            }
            switch (this.getStrength()) {
                case 0: {
                    ord = CollationElementIterator.primaryOrder(ord);
                    break;
                }
                case 1: {
                    ord = CollationElementIterator.primaryOrder(ord) << 8;
                    ord |= CollationElementIterator.secondaryOrder(ord);
                }
            }
            vect.add(new Integer(ord));
            ord = cei.next();
        }
        Object[] objarr = vect.toArray();
        byte[] key = new byte[objarr.length * 4];
        int i = 0;
        while (i < objarr.length) {
            int j = (Integer)objarr[i];
            key[i * 4] = (byte)((j & 0xFF000000) >> 24);
            key[i * 4 + 1] = (byte)((j & 0xFF0000) >> 16);
            key[i * 4 + 2] = (byte)((j & 0xFF00) >> 8);
            key[i * 4 + 3] = (byte)(j & 0xFF);
            ++i;
        }
        return new CollationKey(this, source, key);
    }

    public String getRules() {
        return this.rules;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public RuleBasedCollator(String rules) throws ParseException {
        if (rules.equals("")) {
            throw new ParseException("empty rule set", 0);
        }
        this.rules = rules;
        this.buildCollationVector(this.parseString(rules));
        this.buildPrefixAccess();
    }

    static final class CollationSorter {
        static final int GREATERP = 0;
        static final int GREATERS = 1;
        static final int GREATERT = 2;
        static final int EQUAL = 3;
        static final int RESET = 4;
        static final int INVERSE_SECONDARY = 5;
        int comparisonType;
        String textElement;
        int hashText;
        int offset;
        boolean ignore;
        String expansionOrdering;

        CollationSorter() {
        }
    }

    static final class CollationElement {
        String key;
        int primary;
        short secondary;
        short tertiary;
        short equality;
        boolean ignore;
        String expansion;

        final int getValue() {
            return (this.primary << 16) + (this.secondary << 8) + this.tertiary;
        }

        CollationElement(String key, int primary, short secondary, short tertiary, short equality, String expansion, boolean ignore) {
            this.key = key;
            this.primary = primary;
            this.secondary = secondary;
            this.tertiary = tertiary;
            this.equality = equality;
            this.ignore = ignore;
            this.expansion = expansion;
        }
    }
}

