/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.campagnelab.goby.counts.CountIndexBuilder;
import org.campagnelab.goby.counts.CountsWriter;
import org.campagnelab.goby.counts.CountsWriterI;
import org.campagnelab.goby.counts.compound.CompoundDataOutput;
import org.campagnelab.goby.counts.compound.CompoundFileWriter;

public class CountsArchiveWriter
implements Closeable {
    public static final String COUNT_ARCHIVE_MODIFIER_DEFAULT = "counts";
    private final CompoundFileWriter compoundWriter;
    private CountsWriterI currentCountsWriterI;
    private String currentId;
    private ByteArrayOutputStream stream;
    private long totalBitsWritten;
    private int totalTransitions;
    private long totalBasesSeen;
    private long totalSitesSeen;
    private CountIndexBuilder indexBuilder = new CountIndexBuilder();
    private boolean verbose = false;

    public CountsArchiveWriter(String basename) throws IOException {
        this(basename, COUNT_ARCHIVE_MODIFIER_DEFAULT);
    }

    public CountsArchiveWriter(String basename, String countArchiveModifier) throws IOException {
        String physicalFilename = basename + "." + countArchiveModifier;
        File tobedeleted = new File(physicalFilename);
        FileUtils.deleteQuietly((File)tobedeleted);
        this.compoundWriter = new CompoundFileWriter(physicalFilename);
    }

    public CountsWriterI newCountWriter(int referenceIndex, String identifier) throws IOException {
        this.stream = new ByteArrayOutputStream(100000);
        this.currentCountsWriterI = new CountsWriter(this.stream, 1);
        this.currentId = Integer.toString(referenceIndex) + "," + identifier;
        return this.currentCountsWriterI;
    }

    public CountsWriterI newCountWriter(int countInfoIndex) throws IOException {
        return this.newCountWriter(countInfoIndex, String.valueOf(countInfoIndex));
    }

    public void returnWriter(CountsWriterI writerI) throws IOException {
        assert (writerI == this.currentCountsWriterI) : "You must return the current counts writer.";
        writerI.close();
        this.totalBitsWritten += writerI.getNumberOfBitsWritten();
        this.totalTransitions += writerI.getNumberOfTransitions();
        this.totalBasesSeen += writerI.getNumberOfBasesSeen();
        this.totalSitesSeen += writerI.getNumberOfSitesSeen();
        byte[] bytes = this.stream.toByteArray();
        CompoundDataOutput part = this.compoundWriter.addFile(this.currentId);
        part.write(bytes);
        part.close();
        this.compoundWriter.finishAddFile();
        CompoundDataOutput indexPart = this.compoundWriter.addFile("#index:" + this.currentId);
        this.indexBuilder.buildIndex(bytes, indexPart);
        indexPart.close();
        this.compoundWriter.finishAddFile();
        this.currentId = null;
        this.currentCountsWriterI = null;
    }

    @Override
    public void close() throws IOException {
        CompoundDataOutput statsFile = this.compoundWriter.addFile("#stats");
        statsFile.writeUTF("totalBasesSeen");
        statsFile.writeLong(this.totalBasesSeen);
        statsFile.writeUTF("totalSitesSeen");
        statsFile.writeLong(this.totalSitesSeen);
        statsFile.writeUTF("END");
        statsFile.close();
        this.compoundWriter.finishAddFile();
        if (this.verbose) {
            System.out.println("Global statististics:%n");
            System.out.printf("Bits written: %d %n", this.totalBitsWritten);
            System.out.printf("Number of transitions: %d %n", this.totalTransitions);
            System.out.printf("Bits per transitions: %2.2g %n", (double)this.totalBitsWritten / (double)this.totalTransitions);
        }
        this.compoundWriter.close();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

