/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class MetalTreeUI
extends BasicTreeUI {
    private PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    private TreeSelectionListener treeSelectionListener;
    private MouseListener mouseListener;
    private KeyListener keyListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeExpansionListener treeExpansionListener;
    private TreeModelListener treeModelListener;

    public static ComponentUI createUI(JComponent component) {
        return new MetalTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return super.getHorizontalLegBuffer();
    }

    public void installUI(JComponent c) {
        TreePath path;
        this.tree = (JTree)c;
        this.configureLayoutCache();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.tree.setFont(defaults.getFont("Tree.font"));
        this.tree.setForeground(defaults.getColor("Tree.foreground"));
        this.tree.setBackground(defaults.getColor("Tree.background"));
        this.tree.setOpaque(true);
        this.tree.setScrollsOnExpand(defaults.getBoolean("Tree.scrollsOnExpand"));
        this.rightChildIndent = defaults.getInt("Tree.rightChildIndent");
        this.leftChildIndent = defaults.getInt("Tree.leftChildIndent");
        this.setRowHeight(defaults.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(defaults.getInt("Tree.rowHeight"));
        this.tree.requestFocusInWindow(false);
        this.setExpandedIcon(defaults.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(defaults.getIcon("Tree.collapsedIcon"));
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellEditor(this.createDefaultCellEditor());
        this.createdCellEditor = true;
        TreeModel mod = this.tree.getModel();
        this.setModel(mod);
        this.treeSelectionModel = this.tree.getSelectionModel();
        this.drawingCache = new Hashtable();
        this.nodeDimensions = this.createNodeDimensions();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.mouseListener = this.createMouseListener();
        this.keyListener = this.createKeyListener();
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        this.componentListener = this.createComponentListener();
        this.cellEditorListener = this.createCellEditorListener();
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.treeModelListener = this.createTreeModelListener();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
        this.installKeyboardActions();
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.tree.addFocusListener(this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.addComponentListener(this.componentListener);
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (mod != null && !this.tree.isExpanded(path = new TreePath(mod.getRoot()))) {
            this.toggleExpandState(path);
        }
        this.completeUIInstall();
    }

    public void uninstallUI(JComponent c) {
        TreeModel tm;
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
        this.uninstallKeyboardActions();
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce != null) {
            tce.removeCellEditorListener(this.cellEditorListener);
        }
        if ((tm = this.tree.getModel()) != null) {
            tm.removeTreeModelListener(this.treeModelListener);
        }
        this.tree = null;
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
    }

    protected boolean isLocationInExpandControl(int row, int rowLevel, int mouseX, int mouseY) {
        return super.isLocationInExpandControl(this.tree.getPathForRow(row), mouseX, mouseY);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }
}

