// A demonstration program for portable graphics under rlab.
pgdemo = function()
{

// set things up
  xpgopen();

// make some superimposed 2-D plots
  xpgclear();
  xpgwindow(1, 1, 1, 14, 9);
  xpgaxes(1, 0, 20, 11, "x-axis", 0, 15, 16, "y-axis");
  x = [0:20];
  y = [0:15]';
  a = y*x;
  b = sin(a/30.);
  xpgconto(1, .2, 5, b, x, y);
  xpgfill(1, -.2, .2, 14, b, x, y);
  xpggrid(1, 3, 3, b, x, y);
  xpglabel(1, 2, 14, "Contour, fill, and grid plots");
  xpgpause();

// make a 3-D plot
  xpgclear();
  xpgwindow(1, 0, 0, 7.5, 7.5);
  xpgpview(1, 5., 5., 5., 0., 0., 0., 3.);
  for (j in -2:2:0.05) {
    xx = [j, j];
    yy = [-2, 2];
    zz = [.5*sin(2.5*j), -.5*sin(2.5*j)];
    xpgpline(1, 9, xx, yy, zz);
  }
  xpgplabel(1, 0., 0., 1., "Funny 3-D plot");

// make a surface perspective plot on the same page
  xpgwindow(2, 7.5, 2.5, 15, 10);
  xpgpview(2, 40, -40, 20, 10, 7.5, 0,3);
  xpgpaxes(2, 0, 20, 1 , "x-axis", 0, 15, 1, "y-axis", -1, 1, 2, "z-axis");
  xpgpsurface(2, 13, b, x, y);
  xpgplabel(2, 0., 0., 4.,"Surface perspective plot");
  xpgpause();

// make some ordinary plots
  xpgclear();
  xpgwindow(1, 0, 0, 7.5, 7.5);
  xpgaxes(1, 0, 20, 5, "x", -1, 1, 5, "sin(x/3)");
  s = sin(x/3);
  c = cos(x/3);
  xpgline(1, 13, x, s);
  for (i in 1:21) {
    xpgmark(1, 5, x[i], s[i], .5);
  }
  xpglabel(1, 1, 0.8, "Plot of sine function");
  xpgwindow(2, 7.5, 0, 15, 7.5);
  xpgaxes(2, 0, 20, 5, "x", -1, 1, 5, "cos(x/3)");
  xpgline(2, 12, x, c);
  for (i in 1:21) {
    xpgmark(2, 8, x[i], c[i], .5);
  }
  xpglabel(2, 1, 0.8, "Plot of cosine function");
  xpgpause();

// make a vector plot
  xpgclear();
  xpgwindow(1, 0, 0, 10, 10);
  xpgaxes(1, -10, 10, 11, "xxx", -10, 10, 11, "yyy");
  xx = ones(21,1)*[-10:10];
  yy = -[-10:10]'*ones(1,21);
  xpgvector(1, .1, .1, yy, xx, [-10:10], [-10:10]');
  xpglabel(1, -8, 8, "Vector plot");
  xpgpause();

// finish up
  xpgclose();
}
