/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private PropertyChangeListener paletteListener;

    public static ComponentUI createUI(JComponent component) {
        return new MetalInternalFrameUI((JInternalFrame)component);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JInternalFrame f = (JInternalFrame)c;
        boolean isPalette = false;
        Boolean p = (Boolean)f.getClientProperty(IS_PALETTE);
        if (p != null) {
            isPalette = p;
        }
        this.setPalette(isPalette);
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new MetalInternalFrameTitlePane(w);
        return this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        MetalInternalFrameTitlePane title = (MetalInternalFrameTitlePane)this.northPane;
        title.setPalette(isPalette);
        if (isPalette) {
            this.frame.setBorder(new MetalBorders.PaletteBorder());
        } else {
            this.frame.setBorder(new MetalBorders.InternalFrameBorder());
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.paletteListener = new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(IS_PALETTE)) {
                    if (Boolean.TRUE.equals(e.getNewValue())) {
                        MetalInternalFrameUI.this.setPalette(true);
                    } else {
                        MetalInternalFrameUI.this.setPalette(false);
                    }
                }
            }
        };
        this.frame.addPropertyChangeListener(this.paletteListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(IS_PALETTE, this.paletteListener);
        this.paletteListener = null;
    }

    public MetalInternalFrameUI(JInternalFrame frame) {
        super(frame);
    }
}

