# NOTE: Derived from web_diary_dir/lib/DateTime/Time.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package DateTime::Time;

#line 162 "web_diary_dir/lib/DateTime/Time.pm (autosplit into web_diary_dir/lib/auto/DateTime/Time/Increment.al)"
################################################################


sub Increment ($$)
{
    my ($self, $quantity) = @_;
    my ($num, $unit) = $quantity =~ /^(\d+)([hms])$/;
#    $num ||= 1;

    if ($quantity eq '1'){
	$num = 1;
	$unit = 's';
    }

#    print "time:$quantity\n";
    
    if ($unit eq 's'){
	my $sec = $self->sec;
	$sec += $num;
	my $min = int($sec / 60);
	$self->sec($sec % 60);
	$self->Increment("${min}m") if $min;
    } elsif ($unit eq 'm'){
	my $min = $self->min;
	$min += $num;
	my $hour = int($min / 60);
	$self->min($min % 60);
	$self->Increment("${hour}h") if $hour;
    } elsif ($unit eq 'h'){
	my $hour = $self->hour;
	$hour += $num;
	my $day = int($hour / 24);
	$self->hour($hour % 24);
	$self->SUPER::Increment("${day}D") if $day;
    } else {
	$self->SUPER::Increment($quantity);
    }
    return $self;
}

# end of DateTime::Time::Increment
1;
