/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j.spi;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.Messages;
import ch.systemsx.cisd.args4j.spi.OptionHandler;
import ch.systemsx.cisd.args4j.spi.Parameters;
import ch.systemsx.cisd.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntOptionHandler
extends OptionHandler {
    private final Setter<? super Integer> setter;

    public IntOptionHandler(Option option, Setter<? super Integer> setter) {
        super(option);
        this.setter = setter;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.set(params.getParameter(0));
        return 1;
    }

    @Override
    public void set(String value) throws CmdLineException {
        try {
            this.set(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.getName(), value));
        }
    }

    protected void set(int value) throws CmdLineException {
        this.setter.addValue((Integer)value);
    }

    @Override
    public String getDefaultMetaVariable() {
        return "N";
    }
}

