/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingException;
import ch.systemsx.cisd.hdf5.h5ar.Utils;

public abstract class NewArchiveEntry {
    private final String parentPath;
    private final String name;
    private final FileLinkType linkType;
    private final String linkTarget;
    private long lastModified;
    private int uid;
    private int gid;
    private short permissions;
    private long size;
    private int crc32;

    public static NewFileArchiveEntry file(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        if (name.length() == 0) {
            throw new ArchivingException(path, "Path does not contain a name.");
        }
        return new NewFileArchiveEntry(parentPath, name);
    }

    public static NewFileArchiveEntry file(String parentPath, String name) {
        return new NewFileArchiveEntry(parentPath, name);
    }

    public static NewSymLinkArchiveEntry symlink(String path, String linkTarget) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        if (name.length() == 0) {
            throw new ArchivingException(path, "Path does not contain a name.");
        }
        return new NewSymLinkArchiveEntry(parentPath, name, linkTarget);
    }

    public static NewSymLinkArchiveEntry symlink(String parentPath, String name, String linkTarget) {
        return new NewSymLinkArchiveEntry(parentPath, name, linkTarget);
    }

    public static NewDirectoryArchiveEntry directory(String path) {
        String normalizedPath = Utils.normalizePath(path);
        String parentPath = Utils.getParentPath(normalizedPath);
        String name = Utils.getName(normalizedPath);
        if (name.length() == 0) {
            throw new ArchivingException(path, "Path does not contain a name.");
        }
        return new NewDirectoryArchiveEntry(parentPath, name);
    }

    public static NewDirectoryArchiveEntry directory(String parentPath, String name) {
        return new NewDirectoryArchiveEntry(parentPath, name);
    }

    private NewArchiveEntry(String parentPath, String name, FileLinkType linkType, String linkTarget) {
        this.parentPath = Utils.normalizePath(parentPath);
        this.name = name;
        this.linkType = linkType;
        this.linkTarget = linkTarget;
        this.size = -1L;
        this.lastModified = System.currentTimeMillis() / 1000L;
        this.uid = Utils.getCurrentUid();
        this.gid = Utils.getCurrentGid();
        this.permissions = (short)493;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public NewArchiveEntry lastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public int getUid() {
        return this.uid;
    }

    public NewArchiveEntry uid(int uid) {
        this.uid = uid;
        return this;
    }

    public int getGid() {
        return this.gid;
    }

    public NewArchiveEntry gid(int gid) {
        this.gid = gid;
        return this;
    }

    public short getPermissions() {
        return this.permissions;
    }

    public NewArchiveEntry permissions(short permissions) {
        this.permissions = permissions;
        return this;
    }

    public int getCrc32() {
        return this.crc32;
    }

    void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public String getName() {
        return this.name;
    }

    public FileLinkType getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public long getSize() {
        return this.size;
    }

    void setSize(long size) {
        this.size = size;
    }

    /* synthetic */ NewArchiveEntry(String string, String string2, FileLinkType fileLinkType, String string3, NewArchiveEntry newArchiveEntry) {
        this(string, string2, fileLinkType, string3);
    }

    public static final class NewDirectoryArchiveEntry
    extends NewArchiveEntry {
        private NewDirectoryArchiveEntry(String parentPath, String name) {
            super(parentPath, name, FileLinkType.DIRECTORY, null, null);
        }

        @Override
        public NewDirectoryArchiveEntry lastModified(long lastModified) {
            super.lastModified(lastModified);
            return this;
        }

        @Override
        public NewDirectoryArchiveEntry uid(int uid) {
            super.uid(uid);
            return this;
        }

        @Override
        public NewDirectoryArchiveEntry gid(int gid) {
            super.gid(gid);
            return this;
        }

        @Override
        public NewDirectoryArchiveEntry permissions(short permissions) {
            super.permissions(permissions);
            return this;
        }
    }

    public static final class NewFileArchiveEntry
    extends NewArchiveEntry {
        private boolean compress;
        private int chunkSize;

        private NewFileArchiveEntry(String parentPath, String name) {
            super(parentPath, name, FileLinkType.REGULAR_FILE, null, null);
        }

        @Override
        public NewFileArchiveEntry lastModified(long lastModified) {
            super.lastModified(lastModified);
            return this;
        }

        @Override
        public NewFileArchiveEntry uid(int uid) {
            super.uid(uid);
            return this;
        }

        @Override
        public NewFileArchiveEntry gid(int gid) {
            super.gid(gid);
            return this;
        }

        @Override
        public NewFileArchiveEntry permissions(short permissions) {
            super.permissions(permissions);
            return this;
        }

        public NewFileArchiveEntry compress() {
            this.compress = true;
            return this;
        }

        public NewFileArchiveEntry compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public boolean isCompress() {
            return this.compress;
        }

        public NewFileArchiveEntry chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public int getChunkSize() {
            return this.chunkSize;
        }
    }

    public static final class NewSymLinkArchiveEntry
    extends NewArchiveEntry {
        private NewSymLinkArchiveEntry(String parentPath, String name, String linkTarget) {
            super(parentPath, name, FileLinkType.SYMLINK, linkTarget, null);
        }

        @Override
        public NewSymLinkArchiveEntry lastModified(long lastModified) {
            super.lastModified(lastModified);
            return this;
        }

        @Override
        public NewSymLinkArchiveEntry uid(int uid) {
            super.uid(uid);
            return this;
        }

        @Override
        public NewSymLinkArchiveEntry gid(int gid) {
            super.gid(gid);
            return this;
        }

        @Override
        public NewSymLinkArchiveEntry permissions(short permissions) {
            super.permissions(permissions);
            return this;
        }
    }
}

