<?php

/**
 * BaseReviewerRating
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                $id                                          Type: integer(6), primary key
 * @property float              $rating                                      Type: decimal
 * @property int                $kpiId                                       Type: integer(11)
 * @property int                $reviewId                                    Type: integer(11)
 * @property int                $reviewerId                                  Type: integer(11)
 * @property string             $comment                                     Type: clob(65532)
 * @property PerformanceReview  $performanceReview                           
 * @property Reviewer           $reviewer                                    
 * @property Kpi                $kpi                                         
 *  
 * @method int                  getId()                                      Type: integer(6), primary key
 * @method float                getRating()                                  Type: decimal
 * @method int                  getKpiid()                                   Type: integer(11)
 * @method int                  getReviewid()                                Type: integer(11)
 * @method int                  getReviewerid()                              Type: integer(11)
 * @method string               getComment()                                 Type: clob(65532)
 * @method PerformanceReview    getPerformanceReview()                       
 * @method Reviewer             getReviewer()                                
 * @method Kpi                  getKpi()                                     
 *  
 * @method ReviewerRating       setId(int $val)                              Type: integer(6), primary key
 * @method ReviewerRating       setRating(float $val)                        Type: decimal
 * @method ReviewerRating       setKpiid(int $val)                           Type: integer(11)
 * @method ReviewerRating       setReviewid(int $val)                        Type: integer(11)
 * @method ReviewerRating       setReviewerid(int $val)                      Type: integer(11)
 * @method ReviewerRating       setComment(string $val)                      Type: clob(65532)
 * @method ReviewerRating       setPerformanceReview(PerformanceReview $val) 
 * @method ReviewerRating       setReviewer(Reviewer $val)                   
 * @method ReviewerRating       setKpi(Kpi $val)                             
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseReviewerRating extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_reviewer_rating');
        $this->hasColumn('id', 'integer', 6, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 6,
             ));
        $this->hasColumn('rating as rating', 'decimal', null, array(
             'type' => 'decimal',
             'notnull' => false,
             ));
        $this->hasColumn('kpi_id as kpiId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('review_id as reviewId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('reviewer_id as reviewerId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('comment as comment', 'clob', 65532, array(
             'type' => 'clob',
             'length' => 65532,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('PerformanceReview as performanceReview', array(
             'local' => 'review_id',
             'foreign' => 'id'));

        $this->hasOne('Reviewer as reviewer', array(
             'local' => 'reviewer_id',
             'foreign' => 'id'));

        $this->hasOne('Kpi as kpi', array(
             'local' => 'kpi_id',
             'foreign' => 'id'));
    }
}