package TDS::Admin::WriteServer::FTP;

use strict;
use vars qw(@ISA);

use File::Copy;

use JConv;

use TDS::Collection;
use TDS::Admin::WriteServer;
use TDS::Admin::FTP;

@ISA = qw(TDS::Admin::WriteServer);

attributes qw();
################################################################
sub Write($$)
{
    my ($self, $content) = @_;

    $self->SUPER::Write($content);
    
    # Kanji-code convert
    #jconv(\$body, $TDS::Collection::TdfJcode);
    *conv_i2t = mkjconv('auto', $TDS::Collection::TdfJcode || 'euc');
    conv_i2t(\$content);
    $content =~ s/\r\n/\n/g;    # convert newline
    $content =~ s/\r/\n/g;

    # ftp put
    my $ftp = new TDS::Admin::FTP;
    my $base_type = $self->GetBaseType;
    my $typedir = $self->GetTypeDir;

    if ($base_type eq 'web_dir'){
	$ftp->SetPutDirOnWebDir($typedir);
    } elsif ($base_type eq 'diary_dir'){
	$ftp->SetPutDirOnDiaryDir($typedir);
    } elsif ($base_type eq 'customize_dir'){
	$ftp->SetPutDirOnCustomizeDir($typedir);
    } else {
	die "illegal type: $base_type";
    }
    $ftp->filename($self->GetOutputFilename);
    $ftp->WriteTmpFile($content);
    $ftp->Put;
}
sub GetWriteFilename($)
{
    my $self = shift;

    my $dir = TDS::Admin::FTP->GetPutDir($self->GetBaseType,
					 $self->GetTypeDir);
    return "$dir/" . $self->GetOutputFilename;
}
sub GetTypeDir($)
{
    my $self = shift;

    if ($self->additional_path){
	return ($self->additional_path);
    } else {
	return $self->type;
    }
}
1;
