# Contributing to Ruby

This guide outlines ways to get started with contributing to Ruby:

* [Reporting issues](contributing/reporting_issues.md): How to report issues, how to request features, and how backporting works
* [Building Ruby](contributing/building_ruby.md): How to build Ruby on your local machine for development
* [Testing Ruby](contributing/testing_ruby.md): How to test Ruby on your local machine once you've built it
* [Making changes to Ruby](contributing/making_changes_to_ruby.md): How to submit pull requests
  to change Ruby's documentation, code, test suite, or standard libraries
* [Making changes to Ruby standard libraries](contributing/making_changes_to_stdlibs.md): How to build, test, and contribute to Ruby standard libraries
* [Making changes to Ruby documentation](contributing/documentation_guide.md): How to make changes to Ruby documentation
* [Benchmarking Ruby](https://github.com/ruby/ruby/tree/master/benchmark#make-benchmark): How to benchmark Ruby
