/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.rendering;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/rendering/WidthRange;", "", "min", "", "max", "(II)V", "getMax", "()I", "getMin", "component1", "component2", "copy", "div", "divisor", "equals", "", "other", "hashCode", "plus", "extra", "toString", "", "mordant"})
public final class WidthRange {
    private final int min;
    private final int max;

    public WidthRange(int min, int max) {
        this.min = min;
        this.max = max;
        if (!(this.min <= this.max)) {
            boolean bl = false;
            String string = "Range min cannot be larger than max";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    @NotNull
    public final WidthRange plus(int extra) {
        return extra == 0 ? this : new WidthRange(this.min + extra, this.max + extra);
    }

    @NotNull
    public final WidthRange plus(@NotNull WidthRange other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new WidthRange(this.min + other.min, this.max + other.max);
    }

    @NotNull
    public final WidthRange div(int divisor) {
        return divisor == 1 ? this : new WidthRange(this.min / divisor, this.max / divisor);
    }

    public final int component1() {
        return this.min;
    }

    public final int component2() {
        return this.max;
    }

    @NotNull
    public final WidthRange copy(int min, int max) {
        return new WidthRange(min, max);
    }

    public static /* synthetic */ WidthRange copy$default(WidthRange widthRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = widthRange.min;
        }
        if ((n3 & 2) != 0) {
            n2 = widthRange.max;
        }
        return widthRange.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "WidthRange(min=" + this.min + ", max=" + this.max + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.min);
        result = result * 31 + Integer.hashCode(this.max);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WidthRange)) {
            return false;
        }
        WidthRange widthRange = (WidthRange)other;
        if (this.min != widthRange.min) {
            return false;
        }
        return this.max == widthRange.max;
    }
}

