;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Multidimensional Scaling and Multivariate Regression Example

;;This script does a Multidimensional Scaling analysis of Cola Dissimilarity
;;Judgments followed by a multivariate regression analysis that projects 
;;Cola Ratings into the Multidimensional Scaling space.

;;Load Data Objects

(when *guidemap* (send *guidemap* :close))  
(show-workmap)

(load-data (strcat *examples-data-dir-name* "coladism.lsp"))
(load-data (strcat *examples-data-dir-name* "colarats.lsp"))
      
;;Perform Multidimensional Scaling of the Dissimilarity Data

(multidimensional-scaling :data colas)
(create-data)

;;Normalize and summarize the mds solution and the ratings data. 

(normalize-data :data colaratings)
(normalize-data :data coefs-mds-colas)
;;Then merge the standardized ratings and mds coordinates

(setcd norm-colaratings)
(merge-variables "rats-coords")

;;Do Multivariate Multiple Regression 
;;Scores on the first 5 components are predictors, ratings are responses.
;;Report the results and create output data objects.

(multiple-regression 
      :data rats-coords 
      :responses   (send colaratings :variables)
      :predictors '("Dim0" "Dim1" "Dim2"))

(create-data :scores t :coefs t :input t)
(visualize-model)
(report-model)
(setcm mds-colas)
(visualize-model)
(report-model)
(vista-message "Multidimensional Scaling Example Finished. 

You are viewing the MDS Visualization. The Multivariate Regression Visualization is underneath it.")