#############################################################################
##
#W  sml256.c               GAP library of groups           Hans Ulrich Besche
##                                               Bettina Eick, Eamonn O'Brien
##
Revision.sml256_c :=
    "@(#)$Id: sml256.c,v 1.1 1998/07/18 16:56:18 gap Exp $";

SMALL_GROUP_LIB[ 256 ][ 3 ] :=
[ 2537931861116334995434916283359, 643883601009703174839256236767,
9942810552156539953275224795, 12418690630727300503073473243,
2545214996788944591846488687579, 3179040296903059292594840290267,
162903025597066520798212841868219, 41701277893875687549042183475645371,
10675527140832176012521092616160365503, 643748767853159693619017288635,
643748767853159702415110310843, 164799684570408838888099959278527,
162903025597066523085197027593147, 2732934948053037021133022372903287589887,
699631222402135010194124218393164584668159, 163529442599758037051378594040507
, 41863537305538057451446566469585599, 164163267899872151752126945643195,
42025796582367270814838144479873727, 1270165770544675946784769460923,
1270165770544675955580862483131, 325162437259436999698532511271615,
1903991070658790647533121063611, 487421714088650363090110521559743,
9942810552156469584531063517, 2545214996788944521477744526301,
649680846413300053985544730887133, 164797093199986268634306366835389,
42188055859196484770321132094130879, 42188055859196484772572931907816127,
42188055714691921084481315178449853, 10800142262961131797627155387867368383,
42188055714691921084490111271472061, 42188055859196335460292458717547261,
10800142262961131648317126714490784765, 2545359501352056178730449535711,
649680990917863165642797435896543, 651575039177969797463393095943135,
166318296681804813820264541600138207, 2545359501352065185929704276703,
651575039177969806470592350684127, 166318296681804813829271740854879199,
2545244011008615272577937474525, 649680875427519724736644923835357,
2545253682415172189611335123933, 649680885098926281653678321484765,
651582466818205509745042490688479, 651584942698284080505592288936927,
166318306585325128103306740793131999, 2545244011008615307762309563357,
2545253682415172224795707212765, 649680885098926281688862693573597,
2732935109648807570044343723314329652157,
699631388070094737931351993107170291059647,
2732935109648807570044343732110422674365,
699631388070094737931203248315434521562109,
42188055724363327641398348576099261, 42188055724363327641407144669121469,
10800142265437011876197915937665616831,
10800142265437011876200167737479302079,
10800140368778038533866412008689290173,
10800140368778038533866420804782312381,
2764835934407177864669801412926638312383,
2764835934407177864669803664726451997631,
2732935109648826912857457557381124950973,
2732935109648826912857457566177217973181,
699631388070099689691509134628269887556543,
699631388070099689691509136880069701241791,
10800302628054867747229803586699578301,
2764877472782046143290829656897272073151,
2764877472782046143290831908697085758399,
10800302628064539153786720620097227709,
2764877472784522023369400417447070321599,
10800302628064539153786729416190249917,
699631388230452442712692676378790926207933,
179105635386995825334449325152909179005160383,
699631388230452442712692676387587019230141, 638806225756552375649149490056,
163534393793677408166207779083146, 163534393793677408166207779083148,
163534393793232362556687222166408, 41864804811067484814511954380051340,
10717390031633276112515060346798592910,
10675688771090394468044942151425038232,
2732976325399140983819505190789784377242,
2732976325399140983819505190789784377244,
2732976325399140869887835856253171652504,
699641939302180062691285979200836913452956,
179108336461358096048969210675414274814367646,
325157369442698086070236765981608, 83240286577330710033980646124391338,
83240286577330710033980646124391340, 83240286577330710033980646124391337,
21309513363796661768699045441877281707,
21309513363796661768699045441877281709,
2743568448731275202968343985472509546424,
702353522875206451959896060280995941945274,
702353522875206451959896060280995941945276,
702353522875206451959896060280995941945273,
179802501856052851701733391431934994636050363,
179802501856052851701733391431934994636050365,
10717064886681843875709794578406284200,
2743568610990552032181707412097484430250,
2743568610990552032181707412097484430252,
179108315152658566423357755926764450024234936,
45851728679080593004379585517251699231144779706,
45851728679080593004379585517251699231144779708,
163534393793677408166310858298250, 41864804811181416490549320034128782,
41864804811181416490549354393867150, 41864804811067484814512057459266442,
41864804811067484814512091819004810, 10717390031633276112515060449877808014,
2732976325399140983819505190892863592346,
2732976325399140983819505190927223330714,
699641939302180091857793328842312854378398,
699641939302180062691285979200939992668058,
179108336461358096048969210675414377893582750,
179108336461358096048969210675414412253321118,
163534393793677408166310858298252, 163534393793677408166345218036620,
41864804811181416490575605233980302, 41864804811181416490584401327002510,
41864804811067484814512057459266444, 41864804811067484814512091819004812,
10717390031633276112515086735077659534,
10717390031633276112515095531170681742,
2732976325399140983819505190892863592348,
2732976325399140983819505190927223330716,
699641939302180091857793328868598054229918,
699641939302180091857793328877394147252126,
699641939302180062691285979200939992668060,
699641939302180062691285979200974352406428,
179108336461358096048969210675440663093434270,
179108336461358096048969210675449459186456478,
41701909262072298436410212774679436, 41701909262072298436410247134417804,
10675688771090508399721014495292789646,
10675688771090508399721023291385811854,
10717390031633276112508331369996326812,
2743651848098118684802132830744569026462,
10717390031633276112508331404356065180,
2743651848098089518294783180609974032284,
2743651848098089518294783180644333770652,
702374873113110916683464494244974950471582,
83240286577330710033980680484129708, 21309513363796661768699054237970303918,
83240286577330710033980714843868076, 21309513363796661768699054237970303917,
5455235421131945412786957884954430901167,
21309513363796661768699063034063326125,
702353522875206451959896060281030301683644,
179802501856052851701733391431943790729072574,
702353522875206451959896060281064661422012,
179802501856052851701733391431943790729072573,
46029440475149530035643748206577610460140638143,
179802501856052851701733391431952586822094781,
699641856065072525205172903432393143327660,
179108315152658566452524263278692669632781230,
699641856065072525205172903432427503066028,
179802512489876810514434494867854901254528956,
46029443197408463491695230686170854746634821566,
179802512489876810514434494867854935614267324,
10675688771090508399721014598372004750,
10675688771090508399721023394465026958,
10675688771090508399721014632731743118,
10675688771090508399721023428824765326,
2743651848098118684802132830847648241566,
2743651848098118684802132830882007979934,
2743651848098118684802132839643741263774,
702374873113110916683464494236281936664478,
702374873113110916683464494245078029686686,
702374873113110916683464494245112389425054,
41701909262072298436410350213632908, 41701909262072298436410384573371276,
10675688771090508399721049679664878478,
10675688771090508399721058475757900686,
10675688771090394468044968608423596940,
10675688771090394468044968642783335308,
2732976325399140983819511963781411492750,
2732976325399140983819511972577504514958,
10717390031633276112508331507435280284,
10717390031633276112508331541795018652,
2743651848098118684802132865928941115294,
2743651848098118684802132874725034137502,
2743651848098089518294783180747412985756,
2743651848098089518294783180781772724124,
702374873113110916683464494271363229538206,
702374873113110916683464494280159322560414, 163534393793677408166310858298249
, 41864804811181416490549320034128779, 41864804811181416490549320034128781,
41864804811067484814512057459266441, 10717390031633276112515060449877808013,
2743651848098118684803855448909024449423,
2732976325399140983819505190892863592345,
699641939302180091857793328842312854378395,
699641939302180091857793328842312854378397,
699641939302180062691285979200939992668057,
179108336461358096048969210675414377893582749,
45851734134107672588536117932906054480527742879,
41864804811181416490575708313195403, 10717390031662442621580626057325810575,
10717390031662442621580634853418832783,
10717390031633276112515086838156874635,
10717390031633276112515095634249896843,
2743651848098118684803855475297303516047,
699641939302180091857793328868701133445019,
699641939302180091857793328877497226467227,
179108336461358103515595092183632218774673311,
179108336461358096048969210675440766172649371,
45851734134107672588536117932906080868806809503,
45851734134107672588536117932906089664899831711,
41864804811181416490575708313195405, 41864804811181416490584504406217613,
10717390031662442621587355068487799695,
10717390031662442621589606868301484943,
10717390031633276112515086838156874637,
10717390031633276112515095634249896845,
2743651848098118684803862204308465505167,
2743651848098118684803864456108279190415,
699641939302180091857793328868701133445021,
699641939302180091857793328877497226467229,
179108336461358103515595092190361229936662431,
179108336461358103515595092192613029750347679,
179108336461358096048969210675440766172649373,
179108336461358096048969210675449562265671581,
45851734134107672588536117932912809879968798623,
45851734134107672588536117932915061679782483871,
10675688771090508399721014598372004749,
10675688771090508399721023394465026957,
2732976325399170150328579710923008217999,
2732976325399170150328581962722821903247,
2743651848098118684802132830847648241565,
702374873113118383309346004670738259351455,
2743651848098118684802132839643741263773,
702374873113110916683464494236281936664477,
702374873113110916683464494245078029686685,
179807967516956394670966910526713715905124255,
2732976325399170150328579737311287284623,
2732976325399170150328581989111100969871,
2732976325399170150328579746107380306831,
2732976325399170150328581997907193992079,
702374873113118383309346004697126538418079,
702374873113118383309346004705922631440287,
702374873113118383309346006948926352103327,
179807967516956394670966910524488304370505631,
179807967516956394670966910526740104184190879,
179807967516956394670966910526748900277213087,
10675688771090508399721049782744093581,
10675688771090508399721058578837115789,
2732976325399170150328588718122262958991,
2732976325399170150328590969922076644239,
2732976325399140983819511963884490707853,
2732976325399140983819511972680583730061,
699641939302180091857795062728169392034703,
699641939302180091857795064979969205719951,
2743651848098118684802132866032020330397,
2743651848098118684802132874828113352605,
702374873113118383309346013677937514092447,
702374873113118383309346015929737327777695,
702374873113110916683464494271466308753309,
702374873113110916683464494280262401775517,
179807967516956394670966910533469115346179999,
179807967516956394670966910535720915159865247,
83240286577330710033980680484129705, 21309513363796661768699045476237020075,
21309513363796661768699045476237020077, 83240286577330710033980714843868073,
21309513363796661768699045510596758443,
21309513363796661768699045510596758445,
702353522875206451959896060281030301683641,
179802501856052851701733391431935028995788733,
179802501856052851701733391431935028995788731,
46029440475149530035643748206575358694686691263,
21309513363796661768699054272330042285,
5455235421131945412786957884988790639535,
21309513363796661768699063068423064493,
21309513363796661768699054306689780653,
5455235421131945412786957885023150377903,
21309513363796661768699063102782802861,
179802501856052851701733391431943825088810941,
179802501856052851701733391431952621181833149,
46029440475149530035643748206577610494500376511,
46029440475149530035643748206579862294314061759,
2743568611624377332295822104221541702569,
702353564575840597067730458636931485113259,
702353564575840597067730458636931485113261,
45851728679122131379247864138279934577484210105,
11738042541855265633087453219399663208052232003515,
11738042541855265633087453219399663208052232003517,
179108315152820825729353476639832619628075949,
45851728679122131386714490019797106841061923759,
179108315152820825729353476639841415721098157,
46029443208042287457974557669399059600862584765,
11783537461258825589241486763366159214037630689215,
46029443208042287457974557669399068396955606973,
179108325703083165898040819274986671236814808,
45851731379989290469898449734396587866880055258,
45851731379989290469898449734396587866880055257,
11738043233277258360294003132005526493951549609947,
179111047962018533415419932828754362687133656,
45852428278276744554347502804161116878161680345,
5465827384098792582081897770756145909688,
1399251810329290901012965829313606850940860,
1399251810329290901012965829313606850940858,
358208463444298470659319252304283387338919870,
1399251810329290901012965829313606850940857,
358208463444298470659319252304283387338919869,
358208463444298470659319252304283387338919867,
91701366641740408488785728589896547192261545919,
8188086319466309961195451556039782272952,
2096150097783375350066035598346217759936444,
2096150097783375350066035598346217759936441,
536614425032544089616905113176631780041789373,
1399251810329290901012965829313641210679228,
1399251810329290901012965829313675570417596,
358208463444298470659319252304292183431942078,
358208463444298470659319252304300979524964286,
358208463444298470659319252304292183431942077,
358208463444298470659319252304300979524964285,
91701366641740408488785728589898798992075231167,
91701366641740408488785728589901050791888916415,
2096150097783375350066035598346252119674812,
2096150097783375350066035598346286479413180,
536614425032544089616905113176640576134811581,
536614425032544089616905113176649372227833789,
1399251810329290901012965829313641210679226,
358208463444298470659319252304283421698658238,
1399251810329290901012965829313675570417594,
358208463444298470659319252304283456058396606,
358208463444298470659319252304292183431942075,
91701366641740408488785728589896555988354568127,
358208463444298470659319252304300979524964283,
91701366641740408488785728589896564784447590335,
2096150097783375350066035598346252119674810,
536614425032544089616905113176631814401527742,
536614425032544089616905113176640576134811579,
137373292808331286941927708973217744520289161151,
358208463444298470659319252304292217791680446,
358208463444298470659319252304301013884702654,
358208463444298470659319252304292252151418814,
358208463444298470659319252304301048244441022,
91701366641740408488785728589898807788168253375,
91701366641740408488785728589901059587981938623,
91701366641740408488785728589898816584261275583,
91701366641740408488785728589901068384074960831,
536614425032544089616905113176640610494549950,
536614425032544089616905113176649406587572158,
137373292808331286941927708973219996320102846399,
137373292808331286941927708973222248119916531647,
45852428278276744551871622725590356431442647001,
11738221639238846605279135417751131220194373244891,
45851731379989290472374329812967348519757518809,
11738043233277258360927828432119641194802980427739,
1399251810329290901012965829313641210679225,
358208463444298470659319252304283421698658237,
358208463444298470659319252304283421698658235,
91701366641740408488785728589896547226621284287,
1399251810329290901012965829313675570417593,
358208463444298470659319252304283456058396605,
358208463444298470659319252304283456058396603,
91701366641740408488785728589896547260981022655,
2096150097783375350066035598346252119674809,
536614425032544089616905113176631814401527741,
2096150097783375350066035598346286479413177,
536614425032544089616905113176631848761266109,
358208463444298470659319252304292217791680445,
358208463444298470659319252304301013884702653,
91701366641740408488785728589898799026434969535,
91701366641740408488785728589901050826248654783,
358208463444298470659319252304292252151418813,
358208463444298470659319252304301048244441021,
91701366641740408488785728589898799060794707903,
91701366641740408488785728589901050860608393151,
536614425032544089616905113176640610494549949,
536614425032544089616905113176649406587572157,
536614425032544089616905113176640644854288317,
536614425032544089616905113176649440947310525,
358208463444298470659319252304292217791680443,
91701366641740408488785728589896556022714306495,
358208463444298470659319252304301013884702651,
91701366641740408488785728589896564818807328703,
358208463444298470659319252304292252151418811,
91701366641740408488785728589896556057074044863,
358208463444298470659319252304301048244441019,
91701366641740408488785728589896564853167067071,
536614425032544089616905113176640610494549947,
137373292808331286941927708973217744554648899519,
536614425032544089616905113176640644854288315,
137373292808331286941927708973217744589008637887,
91701366641740408488785728589898807822527991743,
91701366641740408488785728589901059622341676991,
91701366641740408488785728589898816618621013951,
91701366641740408488785728589901068418434699199,
91701366641740408488785728589898807856887730111,
91701366641740408488785728589901059656701415359,
91701366641740408488785728589898816652980752319,
91701366641740408488785728589901068452794437567,
137373292808331286941927708973219996354462584767,
137373292808331286941927708973222248154276270015,
137373292808331286941927708973219996388822323135,
137373292808331286941927708973222248188636008383,
41863532237987538460314086192191450, 10717064252924809845840274670886066142,
41863532237987538460314120551929818, 10717064252924809845840274705245804510,
10717064252924809845840406096885323739,
2743568448748751320535110315778517243871,
10717064252924809845840414892978345947,
2743568448748751320535110324574610266079, 41863532237987538460314223631144922
, 10717064252924809845840274808325019614,
10717064252924809845840441281257412571,
2743568448748751320535110350962889332703, 41863532237987538460314257990883290
, 10717064252924809845840274842684757982, 325157369708917429827249268330426,
83240286645482862035775846516527035, 325157369708917429827283628068794,
83239647829436946122923612525580218, 21309349844335858207468444840368295867,
83239647829436946122923646885318586, 2743568285211843565913884208654031265786
, 702353481014231952873954357415463687823355,
2743568285211843565913884208688391004154, 83240286645482862035618169677156286
, 21309513381243612681118251471175946175, 83240286645482862035618204036894654
, 21309349844335858207468287163528925118,
5455193560149979701111881513897224589247,
21309349844335858207468287197888663486,
10717064252924809845840441384336627675,
2743568448748751320535110351065968547807,
10717064252924809845840441418696366043,
2743568448748751320535110351100328286175,
10717064252924809845840450180429649883,
2743568448748751320535110359862061570015, 83240286645482862035775880876265403
, 83240286645482862035775915236003771, 83240286645482862035784676969287611,
21309349844335858207468444874728034235,
21309349844335858207468444909087772603,
21309349844335858207468453670821056443,
21309513381243612681118251505535684543,
21309513381243612681118251539895422911,
21309513381243612681118260301628706751,
5455193560149979701111881513931584327615,
5455193560149979701111881513965944065983,
5455193560149979701111881522727677349823,
705075739949599460581660777814337328783355,
705075739949599460581660777823133421805563,
179802491097614394642870659226979517712113658,
46029437720989285028574888762106756565700780027,
325157369708917429827317987807162, 325157369708917429827352347545530,
83240286645482862035793438702571451, 83240286645482862035802234795593659,
83239647829436946122923681245056954, 83239647829436946122923715604795322,
21309349844335858207468462432554340283,
21309349844335858207468471228647362491, 83240286645482862035618238396633022,
83240286645482862035618272756371390, 21309513381243612681118269063361990591,
21309513381243612681118277859455012799,
21309349844335858207468287232248401854,
21309349844335858207468287266608140222,
5455193560149979701111881531489410633663,
5455193560149979701111881540285503655871,
10717550391939251569445797695089301466,
2743692900336448401778124078548542052318,
10717550391939251569445797729449039834,
2743692900336448401778124078582901790686,
2743692900336448401778124209974541309915,
702385382486130790855199764108458445527007,
2743692900336448401778124218770634332123,
702385382486130790855199764117254538549215,
10717550391939251569445797832528254938,
2743692900336448401778124078685981005790,
2743692900336448401778124245158913398747,
702385382486130790855199764143642817615839,
10717550391939251569445797866887993306,
2743692900336448401778124078720340744158,
2743692900336448401778124245261992613851,
702385382486130790855199764143745896830943,
2743692900336448401778124245296352352219,
702385382486130790855199764143780256569311,
2743692900336448401778124254058085636059,
702385382486130790855199764152541989853151, 163536908925619979183004965670846
, 41865448684958714670849305570447295, 163536908925619979183039325409214,
41701911777204241007426975599447998, 10675689414964285697901305787813220287,
41701911777204241007427009959186366, 10675689414964285549167606509460267006,
2732976490230857100586907266456186003455,
10675689414964285549167606543820005374,
2732934624782471993256164465963605975038,
2732934624782471993256164465997965713406,
699631263944312830273578103295513576103935, 163536908925619979200597151715262
, 41865448684958714675352905197817791, 163536908925619979200631511453630,
163536908925619979209393244737470, 41701911777204241007444567785492414,
10675689414964285697905809387440590783, 41865448684958861672844845650024415,
41865448684958861672853641743046623, 41865448684958861675096645463709663,
10675689414964285844903301327892797407, 166317036382040104666385294737561566,
166317036382040104666394090830583774, 166317036382040104666385329097299934,
42577161313802266794594635487169763295,
42577161313802266794596887286983448543,
42577161313802266794594644283262785503,
42577161313802266794594635590248978399,
42577161313802266794596887390062663647,
42577161313802266794594644386342000607,
42577161313802266794594635624608716767,
42577161313802266794596887424422402015,
42577161313802266794594644420701738975, 148735952212037992527,
37927667815169199702223, 37927667815169199718479,
2485627191727355709557343439, 636310927305842056457908962511,
2485627191727355709559554127, 2361764241246003396819, 40140696104203165106643
, 40140696104203165122771, 2486156096766646251130259675,
636311456210881346999481878747, 2486156096766646251130194651,
636311456210881346999481813723, 9711547253021236562821843,
2485591625823781786361086675, 9711547253021236562790611,
2486156096766646251130290395, 636311456210881346999481893339,
641272887774584288732103318251, 164165859270293571125109512477423,
162900549716987947680310113622763, 164165859270292422707204533000955,
41702540727548913450951175166778107, 641272887775160749484406741739,
162900549716988524141062417046251, 162898073836909374667960501738219,
41701906902248799908207579491277551, 162898073836909951128712805161707,
41701906902248946907951216677952251, 162898073836909376919760315390699,
41701906902248800484668331794668271, 162898073836909953380512618814187,
41701906902248948058620921471081199, 41701906902248799336250426815191803,
41701906902248946910203016491604731, 9747113183581298306912899,
2495260974990022049060164231, 2495260819379395924341117571,
638786769761118566313812382343, 2495260974990022049060164259,
638786769761118566313812382371, 638786809597438854241892504243,
163529413058846346186018456162995, 641262649839689326863610616459,
164163238358960460886766807751311, 164163238319124140598838727629451,
42025789009695779986512396758899343, 164163238358960460886766807751323,
42025789019893877980221985274272415, 42025789009695779986512396758899355,
10758601986482119676540383252763990687, 164163238358960460886766807751339,
42025789009695779986512396758899371, 604611672745665139572951,
10276018229662698537222615, 10276018229662698537238743,
636455960772288426977599228127, 162895732789985651818555609532639,
41701273076948685250823076043557855, 10675525239356275668481279558286330847,
162898064165502849276124499855575, 604611654731266630090983,
10276018211648300027756775, 10276018211648300027740647,
2486156096782408849826023655, 636311456210897109598177626599,
636455960772270412579089681135, 162895732789985633804157099985647,
41701904426368720776748876089608431, 10675687496157224803255896187991050735,
41701273076948685232808677536284911, 10675525870705695704007205358332396015,
162898064165502831261725990404839, 604611654731266630090967,
10276018211648300027756759, 10276018211648300027740631,
2486156096782408849826023639, 636455960772270412579089681119,
162895732789985633804157099985631, 41701904426368720776748876089608415,
41701273076948685232808677536284895, 162898064165502831261725990404823,
2485627347380730571553802375, 2485627347382982371367487623,
636320598720478395763626641799, 636320598720480647563440327047,
636320600925440773324221483159, 162898073272438443062494868310423,
162898082943844999979528265960079, 162898082943845002231328079645327,
41701909233059845599850730254273423, 41701909233059845602102530067958671,
41701909233624315968506242533722799, 41701909233624315970758042347408047,
10675688763663320469535533951541873583,
10675688763663320469537785751355558831, 41701909233624315968506242533722783,
10675688763663320469535533951541873567, 164165859270293586887708208274159,
164165859270293589139508021959407, 41702540727548914615131678842051311,
41702540727548914617383478655736559, 164165859270441160840297884687087,
41702540727549062189084268518464239, 42026459973194860222016650207042303,
10675850426252521843452473132449815295, 41701906902248800500430930490465007,
41701906902248948074383520166877935, 41701906902248948076635319980563183,
10675688166975692630089081554439543551,
699631263453697530735102375550346511604463,
699631263453697530735102377802146325289711,
699631263453697530735249949502936188017391,
179105603444146567868186057117143891874765567,
179105603444146567868223836049006849036475135, 604611690760063649054951,
10276018247677097046720743, 10276018247677097046704615,
636455960772306441376108740847, 162895732789985669832954119029231,
41701904426368720812777673108572399, 10675687496157224803291924985010014703,
162898064165502867290523009337575, 41701904281864159439474692196452839,
604611690760063649054935, 10276018247677097046720727,
10276018247677097046704599, 636455960772306441376108740831,
162895732789985669832954119029215, 41701904426368720812777673108572383,
162898064165502867290523009337559, 42026422980027148116021581428656351,
42026422980027295689974171105069279, 163532033970179512719356503359711,
41864163703197935333594355349160415, 163532033970327086671946179772639,
163532033970327088923745993457887, 41864163703198082907546945025573343,
41864200696328163115199691034558719, 10717225908018633653259199395559473663,
699631305153697850542823264974696124613599,
179105614119346649738924817267031948576261119, 1189817262283704762849,
38968749125240866488801, 9710375306042274264253409,
2485590453876802824062518241, 2485856078346795960775115241,
9710375306042274265235937, 162895587985405824888287138120169,
162895587985405824888287141201385, 9747113165672315508364161,
2495260970412086502153655171, 2495260970412086502153655173,
2495260819361486941542568833, 638786769756540630766905873285,
163529413057674401450059911811975, 641262649835111391316704138121,
164163238357788516150808263431051, 164163238357788516150808263431053,
164163238319119562663291821151113, 42025789009694608041776438214579085,
10758601986481819658694741914932138895, 164163238357788516150808263431081,
42025789019593860134580647442420651, 42025789019593860134580647442420653,
42025789009694608041776438214579113, 10758601986481819658694741914932138925,
2754202108539345832625853903954627449775, 636320560933476187689895269249,
162898063598969904022344917259141, 41702538106597740590907262456009609,
10675849755289021591272232920458433421,
10675849755289021591272232920458433449,
2733017537353989527365691601369078928301, 162895597390297890178828521837457,
41701272931916259885753831998493589, 41701272931916259885753831998493587,
10675525870570562530752954722022462359,
10675526504385963392774851261146239897,
2732934785122806628550361896583837160349,
2732934785122806628550361896583837160347,
699631304991438496908892645499192712795039, 162898063637638857518657455657877
, 41701904281336295429702826642789269, 10675525870560663278660159308886643605
, 10675525870560663278660168104979665813,
2732934622863529799337000756805639541655,
2732934622863529799337003008605453226903, 636320561084526796046600377221,
162898063637638859761661174223751, 41702538106636409544403574992311181,
10675849755298920843367288929500959631,
10675849755298920843365045925780296621,
2733017537356523735901451730731225224111, 638786808425494135875467252681,
163529422956926498757868700079051, 163529422956926498757868700079053,
163529422956926494271861258753001, 162900539517717428279207182898121,
41702538116535661637207784151225321, 10675849757833129379125166491763643371,
10675849757833129379125166491763643373, 41701272931916259885771424112415689,
10675525870570562530752972314136384489, 41701904281336295429711622668851145,
10675687496022091630006149151239477195,
10675687496022091630001663143798151145,
2732975998981655457280425738560340269037,
2732934461238068370985657027559058413513,
699631222076945502972328194542859242018793,
10675525870570562530752972314141561817,
2732934622866064007872756400160277566457,
699631263453712386015425638414778536072189,
2732934461871903570351864523720545965017,
699631222239207314010077318046207212688349,
699631222239207314010077315803203492025337, 162898073345783274065732060779393
, 41701906776520518160801130731475845, 41701906776520518160801130731475873,
10675688134789252649165063190429766565,
10675688134789252649165063190429766563,
2732976162506048678186256150473192182695,
10675688768614514094326276422339105673,
2732976324765315608147526737841974645645,
2732976324765315608147526737841974645643,
2732976324765315569478573250325532365705,
699641939139920785786514752057059445035915,
179108336419819721161347776526580941088609167,
2732976324765315608147526737841974645673,
699641939139920785786514752057059445035945,
10675525873055847350340658052367325057,
2732934623502296921687208435128137357187,
2732934623502296921687208435128137357217,
699631263616588011951925359366525265581987,
179105603485846531059692891997804190091122599,
179105592852023832421066884903944995325842329,
45851031770118101099783223283317088315747062681,
45851031770118101099793122535409892524974904249,
11737864133150233881547039369064932460115134747579,
11737864133150233881544505160529174582552803136441,
769252663830133727660900690200439985435426946005849023,
179105592893561573464045391817488217608000409,
45851031780751762806795620305276957429207372699,
45851031780751762806795620305276957429207372701,
45851031780751762806795620305276957429207372729,
11737864135872451278539678798150901075598646678461, 304593219250318974386659,
9975999776167352372052451, 2485856078346927902174479843,
636311156192461628650526098915, 636379156056779871648948945395,
2553855942665170900591051755, 636379156056779871648942670827,
162895655985270143263226957137899, 41701270524263891171507197590915051,
41701287932229156641714793309275131, 2495260970412218444022814083,
638786808425494250225217312135, 638786769756540762708775032195,
163529413057674401582001780970887, 164163238357788516282750134654355,
42025789019593860134712589313643927, 42025789009694608041908380085802387,
10758601986481819658694873856803362199, 42025789019593860134712589313643955,
10758601989016028194452751419134973367,
10758601986481819658694873856803362227,
2754202108539345832625854035896498673079, 163529422691302026636078016894859,
41863529742499022303570878309357451, 10758601988948028330708717373203945371,
2754202108539277832762110001850567645083,
2754202109170695252661397976095052011451,
705075739786055125187100126802300154959803, 163529422956926498889810105603539
, 41863532276973183682120077709153751, 163529422956926498898606198625747,
41863532276973183682128873802175959, 41863532276973182533702172729677299,
41702538116535661639582729281476051, 41702538116535661639591525374498259,
10675849757833129379125298433173231091,
2733017538005281121056042727581952251383,
10717064245497169610121369151128737755,
10717064245497169610121377947221759963,
2743568446847275419897041847704885401595,
2733017537987873155937570011823608960987,
2733017537987873155937570020619701983195,
699652489724895527919870891863696125990907,
702353480850056268059358738941743717357019,
179802491097614404623195837130929074559194591,
179802491097614404623195543135945399813215739,
702353480850056200059493846489792806852563,
179802491097614387215230423514811736490448883, 636320827599018545683919672267
, 41701270465935433410181232567916491, 10675525239279470952398515277144396763
, 2495527484906114327567668171, 2495527484906123123660690379,
636320827599020815075919287243, 638855036134778692638250898411,
162898131865348142084216261202923, 162895597656812384206653933754315,
41701273000143969170328186899142635, 41701273000143969170328186901238747,
10675525888036856106417440626040640507,
10675525888036856106417449422133662715, 304593219250318974386661,
9975999776167352372052453, 2485856078346927902174479845,
636311156192461628650526098917, 636379156056779871648948945397,
162895655985270143263226957267957, 41701270524263891171507197591045109,
636311156192461628650524115941, 2495260970412218444022814085,
638786808425527895281027257735, 638786769756540762708775032197,
163529413057674435227057590916487, 164163238357788516282750134654357,
42025789019593860168357645123589527, 42025789009694608041908380085802389,
10758601986481819658728518912613307799, 42025789019593860134712589313643957,
10758601989016028194486396474944918967,
10758601986481819658694873856803362229,
2754202108539345832625887680952308618679, 41863529742764646804974863204357519
, 10717063611613541037700283738070603151, 163529422956926498889810105603541,
163529422956926498898606198625749, 41863532276973183715765133519099351,
41863532276973182533702172729677301, 41702538116535661639582729281476053,
10675849757833129379125298433173231093,
2733017538005281121056076372637762196983,
2732975998981587457416679584656001210325,
699641855739286389098669365791673391650805,
2732975998979121248744665758731787638229,
699641855738655039678633821869067025323509,
702353480850056200059493846489792806852565,
179802491097614387215230423514811736490448885, 77975864128116979253903847,
2553855942698877529052168679, 41701287932229156675421421768410103,
10675525254211556139905877904011183095, 41705744371337117048565925131847679,
10675529710650664100279022407374620671,
699631222081419408374011835293700834116095,
2732934623514821393174957290436822177759,
2732934623514821393174957299232915199967, 42026440311187698669826830743115743
, 42026440311187698669835626836137951, 10675850406590514681900283312985888735
, 10758768719664012925493913063773968383,
2733017704087171720632490772517919676415,
10675688147313685468536909327165822943, 77975864128257716742259175,
2553855942699018266540524007, 41705744371337117048706662624396287,
10675529710650664100279163144867169279, 77975864110172949488599527,
2553855942680933499286864359, 653787121322265841843354731503,
162913063950535629233421365036015, 162898131865348729786375448117735,
162898131865348729786375447122895, 162898131865348732038175260808143,
638855036135942873141926171599, 638855036135942881938019193807,
638855036135945124941739856847, 162898131865349306264719936476111,
163546889250503322920676833104879, 41701921757529124351164647466882031,
10675525888036856107009646384851850207, 304593219144765858120163,
9975999776061799255785955, 636379156056779766095826420715,
2485856078346822349055132131, 41701270524263891171401644471583723,
636379156056779766095828485619, 10675525254211556139872065722431604731,
163529422956926498784256979145675, 163529422956926498793053072167883,
41863532276973183682014524582695887, 41863532276973182533596619603219435,
10675525870570562530757484709856777163,
2732934622866064007872760912555992781803,
2732975998981655457280425764948617238491,
699641855739303797063788989071583399417823,
699641855739303797063787840653678419941371,
41701904291235547524794019985396683, 10675687498556300165761818894218466283,
2732975999630412842435014395650374013935,
2732934461238078270237752109956374959051,
699631222076948037180863954698609662333931,
699631263453063628630271619551002286790619,
179105603443984288929349534019606362840274939,
46030134629951937909836152876062102354765649883,
11783714465267696104918055136271891447554969540575,
46030134629951937909836152876062111150858672091,
11783714465267696104918055136271891456351062562783,
11783714465267696104918055135976748045975244085243,
46208540591540183528793738735781529242861672411,
11829386391434286983371197116360064730907551307743,
11829386391434286983371197116211918821165198841851,
46030831538873215958088652850488579098305468379,
11783892873951543285270695129429926092321437620219,
46209237500461461577046238710208005986401490907,
46209237500461461577046238710208014782494513115,
11829564800118134163723837109665096867511392376827,
3004984739642401245742991609346606943488459345991643,
769276093348454718910205851992731229950103529130006523,
3004939067716234655027431569495699250805595753125851,
769264401335356071687022481790898713625798611983374331,
3004984918048373467811943020959336355131833636591579,
769276139020383607759857413365589959330807347523590139,
196934691589218203586523497821591029588675439692457940991,
3004939246122206877096382981108428662448970043725787,
769264447007284960536674043163757443006502430376957947,
196931698433864949897388555049921905409653380902920099839,
2495336380701886215047156099, 638806113459676115781228237191,
638806112422080538632271253891, 163534364780052611134590593094023,
638806113459676115781228237219, 163534364780052611134590593094051,
41701909233058673639378561228936595, 10675688763663020451674156403229005207,
10675688763662754827206406270237103507,
2732976323497665235764833249909315556759,
10675688763663020451674156403229005235,
2732976323497665235764833249909315556787,
699641938815402232355933561187467468576667,
179108336336742971483118991657236400568375199,
179108336336742971415119127913202354637363099,
45851734102206200682270496745773047515773523871,
179108336336742971483118991657236400568375227,
45851734102206200682270496745773047515773523899, 304593219285503346475491,
9975999776202536744141283, 636379156056779906833314906603,
41701270524263891171542381966197235,
699631221914703692436838065086175368151547, 162895587985405825055412909573603
, 2732934460604311298581398858318352713195, 2553855942665206084963140587,
636379156056779906833314759659, 636311156192461663834894140387,
2732934460621719263846869065914070926331,
699631221914686284471572594878579651871731,
10675525236803590874401998864206858219,
2732934460604243298717080615319931946979, 163531957165462833280901288722923,
163531957165463409741653592146411, 41864181034358632846733990506693103,
163531957165463409750449685168619, 41864181034358632846742786599715311,
179105592851698697518301319393738978215035387,
179105592851698697518301466967691567891448315,
179105592851698697518301466967700363984470523,
699631263453694978050307742344490448815595,
699631263453694978050308318805242752239083,
699631263453694978050308318814038845261291,
41864163626393218651904100320838635, 10717225888356663974840320353051771887,
41864163626393219228364852624262123, 41864163626393219228373648717284331,
45851031770034862108246029803226234883916923899,
45851031770034862108246029950800187473593336827,
45851031770034862108246029950800196269686359035,
179105603444145896972913515372182923950655467,
179105603444145896972913515948643676254078955,
179105603444145896972913515948652472347101163,
46030137341577211585273448000667963032579047931,
46030137341577211585273448148241915622255460859,
11783715159443766165830002725949883269964287672831,
46030137341577211585273448148241924418348483067,
11783715159443766165830002725949883278760380695039,
11783893565405354406358695865661039587063777166843,
11783893565405354406358695865808613539653453579771,
3016676752743770728027826141647005019021951005853183,
11783893565405354406358695865808613548449546601979,
3016676752743770728027826141647005019030747098875391,
46209242923712008279163443657828960465776509435,
46209242923712008279163443805402913055452922363,
46209242923712008279163443805402921851545944571,
11829387782508685870024270182550042969520211461627,
11829387782508685870024270182697616922109887874555,
11829387782508685870024270182697616930905980896763,
11783715159443766161373563579915432609124219061243,
11783715159443766161373563580063006561713895474171,
11783715159443766161373563580063006570509988496379,
3016676752743770728023369702501117565852948310231035,
3016676752743770728023369702501265139805537986643963,
3016676752743770728023369702501265139814334079666171,
11829566188470274115009402468295645443860142195707,
3028368944248390173442407031883685186498863291663359,
11829566188470274115009402468443219396449818608635,
11829566188470274115009402468443219405245911630843,
3028323272322223582721756727624555434269958116706299,
775250757714489237176769722271886191125979944766113791,
3028323272322223582721756727624703008222547793119227,
3028323272322223582721756727624703008231343886141435,
41701906776520518160968256972723587, 10675688134789252649165230316671014279,
10675688134789213980211742800228734339,
2732976162506038778934163513390205588871,
10675688134789252649165230316671014307,
2732976162506038778934163513390205588899,
2732975999617888447542758805120603985299,
699641855902179442570946211467405739234711,
699641855902179423038066493609120275453331,
179108315110957932297745022321291321630872983,
699641855902179442570946211467405739234739,
179108315110957932297745022321291321630873011,
45851728668322478432039409691106509004639278491,
11738042539090554478597088463715451940640000300443,
11738042539090554478602088880923223661718732510651,
3004938890007181946522134753516345214756526599935423,
3004938890007181946520854646711155654160371149952443,
769264355841838578309338789558055847422411545460856255,
2495527484906149511939757003, 2495527484906158308032779211,
636320827599020850260291376075, 636320827599020859056384398283,
638855036134778727822622987243, 162898131865348142119400633291755,
162895597656812381990038488126411, 41701273000143969168111571453514731,
41701273000143969168120367546536939, 2732934460606787178659397679307662889947
, 2732934460606787178659397688103755912155,
699631221915337517736804610355525856596987,
179105592810159673892637396772634661194273755,
45851031759400876516515173573173134982338810875,
45851031759400876516515173573173143778431833083,
10675525236745262416642942291183474635,
10675525236745262416642951087276496843,
2732934460606787178659397679307660793835,
699631221914686226143114833570206812706763,
179105592810159673892637396772634661192177643,
179105592810159673892637396772643457285199851,
162898073270376461106504081511299, 41701906757216374000621706111521671,
162898073270376461115300174533507, 41701906757216374000630502204543879,
41701906757216374000621706111521699, 10675688129847391744116513425794175911,
41701906757216374000630502204543907, 10675688129847391744116522221887198119,
41702543058396566686083004261372811, 10675851022949521071594605752156066703,
41702543058396566686091800354395019, 10675851022949521071594614548249088911,
10675851022949521071594605752156066731,
2733017861875077394328176429213197702063,
10675851022949521071594614548249088939,
2733017861875077394328176438009290724271,
179105592810321933101238900853835625510966163,
45851031759442414873917158618539276790163542935,
179105592810321933101238900853844421603988371,
45851031759442414873917158618539285586256565143,
45851031759442414873917158618539276790163542963,
11737864130417258207722792606346012214941223195575,
45851031759442414873917158618539285586256565171,
11737864130417258207722792606346012223737316217783,
77975864128081794881815015, 2553855942698842344680079847,
162913063950535647142266760332791, 2732976003453026650428304090647786210303,
699631263453078560715459126966405717608431,
41863532276973183715791521798165975, 41863532276973183718043321611851223,
41863532276973183715800317891188183, 41863532276973183718052117704873431,
10717064262905134728627756353561040375,
2754202108539345832627045132444290323927,
705075739786072533152219790614606289901047,
699641855900929248593034692588087531280351,
179108315110637887639779241320264479987996671,
45852425555975946305913048802423706983806867423,
11738220942329842254313740455779338284021274712063,
77975864128222532370170343, 2553855942698983082168435175,
162913063950535647283004248688119, 162913063950535647283004248687599,
41705744371337117048671478248114175, 10675529710650664100279127960490887167,
699631222081419408374011835399253950382591,
2732934622880996093060266234489283462639,
2732934622880996093060266234489283462135,
699631222076945561300785992047154866341863,
41863532276973183715932259286521303, 41863532276973183718184059100206551,
41863532276973183715941055379543511, 41863532276973183718192855193228759,
10717064262905134728627897091049395703,
2754202270813554747174301100043451504607,
2754202270813554747174301108839544526815,
705075781328270015201349710012777060374527,
699641855738655039678634434376208533755351,
699641855738655039678634434385004626777559,
179108315069095690157730258398622029381178871,
45852425555975946305913048802423830129109178335,
45852425555975946305913048802423838925202200543,
11738220942329842254313740455779338407166577022975,
10675688147313685616110967469956405215,
10675688147313685616110976266049427423,
2732976165712303442159036604282266720255, 42026440311187698669949976045426655
, 42026440311187698669958772138448863, 10675850406590514681900406458288199647
, 10675850406590514681900415254381221855,
10758768719664012925494036209076279295,
2733017704087171720632490895663221987327,
45851031770034862742071329917948921581960157151,
11737864133128924861970260421207908259159488059391,
11737864133128924861970260421207908267955581081599,
11737864130417258370630826821009150422997109299167,
3004893217386818142881491666102924134711069648345087,
3004893217386818142881491666102924134719865741367295,
77975864110067396372333031, 2553855942680827946170597863,
653787121322265736290238465527, 162913063950535629127868248770039,
162913063950535629127868248785903, 10675529710650664100260972824493066239,
638855036135947253596251231703, 638855036135949505396064916951,
162898131865349310645174261536215, 162898131865349312896974075221463,
163546889250503327301131158164983, 41701921757529124355545101791942135,
10675687513488385500829676088439379935,
10675687513488385500831927888253065183,
2732976003453026612944506622071091009535,
10675687498556300166351772853221807575,
179105603444145914380878780855742988873226207,
41863532276973183697777123278492623, 41863532276973183697785919371514831,
41863532276973183700028923092177871, 10717064262905134728609741955041367023,
2743568285221823890797808813920796055519,
2743568285221823890797811065720609740767,
702353481016786916043941035162119537203199,
10675687498556300166351790445404001231,
10675687498556300166354042245217686479,
2732975999630412842435030158249069810671,
699641855739303797063788428391021975869407,
699641855739303797063788430642821789554655,
179108315069261772048329686639905851467798527, 77975864110208133860688359,
2553855942680968683658953191, 653787121322265877027726820335,
162913063950535629268605737124847, 162913063950535629268605737271791,
162895655985270159061010020991975, 653787121322265877027726820855,
162913063950535629268605737125367, 10675529710650664100261113561981552127,
162898131865348729821559820206567, 2732934461255544563960999529261112213999,
10675687513488385353251360636625044983,
179105592851702520132109165663424140107040255, 638855036135942908326298260431
, 638855036135942917122391282639, 638855036135945160126111945679,
162898131865349306299904308564943, 162898131865349308551704122250191,
162898131865349308560500215272399, 163546889250503322955861205193711,
41701921757529124351199831838970863, 41701273000143969758083122639049679,
41701273000143969760334922452734927, 10675525888036856107005195561778451439,
10675525888036856107005204357871473647,
10675525888036856107007447361592136687,
2732975999630412842435611263338492810207,
2732975999630412842435611272134585832415, 41701906757216374016384304807318407
, 41701906757216374016393100900340615, 41701906757216374018636104621003655,
10675688129847391744132276024489972647,
10675688129847391744132284820582994855,
10675688129847391744134527824303657895,
10675851022949521071610368350851863439,
10675851022949521071610377146944885647,
10675851022949521071612620150665548687,
2733017861875077394328192191811893498799,
2733017861875077394328192200607986521007,
2733017861875077394328194443611707184047,
2732976161238398077958042678700917823383,
2732976161238398077958044930500731508631,
2732976161238398077958044939296824530839,
699641897277029907957254863641428778981303,
699641897277029907957254865893228592666551,
699641897277029907957254865902024685688759,
41864181034358632867000188829439967, 41864181034358632867008984922462175,
41864181034358632869251988643125215, 10675688147313685616097456671072212959,
10675688147313685616099708470885898207,
10675688147313685616099717266978920415,
10717230344795734452026234029236819967,
2732976165712303442159023093483382527999,
2732934623514821393322517855372914628575,
699631263619794276615149642652992376313855,
699631263619794276615149642661788469336063,
699631263619794276615149644904792189999103,
699641855901563073893149942336679458199519,
699641855901563073893149942345475551221727,
45851031770034862742071329917930907183450675167,
45851031770034862742071329917933158983264360415,
41864181034358485288543999526076911, 41864181034358632862496589202489839,
41864181034358632862505385295512047, 41864181034358632864748389016175087,
10717225888356663974856082951747568623,
10717225888356664122430035541423981551,
10717225888356664122430044337517003759,
10717225888356664122432287341237666799,
2743609827419305977412669612565796914687,
2743609827419306015191601475522958624255,
2743609827419306015191603727322772309503,
2743609827419306015191603736118865331711, 77975864110278502604866023,
2553855942681039052403130855, 162913063950535629338974481449455,
653787121322265947396470997999, 162913063950535629338974481302511,
162895655985270159131378765169639, 699631263457534999823419482307616803341823
, 2732934622880996093060248290459514947063,
2754243651385585304395323661072294381055,
2754243651385585342174255524029456090623,
2754243651385585342174257775829269775871, 41864181034358485288614368270254575
, 41864181034358632862566957946667503, 41864181034358632862575754039689711,
41864181034358632864818757760352751, 10717225888356663974856153320491746287,
10717225888356664122430105910168159215,
10717225888356664122432357709981844463, 41701921757529124351252608397088735,
41701921757529124353504408210773983, 10675525888036856107581709090639861727,
10675525888036856107583960890453546975,
10675691969927455535845634056180996095,
2732934627337435163242842493510326704127,
2732934461255544563814002107792482277343,
2732934461255544563814004359592295962591,
699631222081419408336233462053019320489983,
699631222081419408336233464304819134175231,
699631263453712386015426230875624044712927,
41701906757216374016454673551496071, 41701906757216374016463469644518279,
41701906757216374018706473365181319, 10675688129847391744132346393234150311,
10675688129847391744132355189327172519,
10675688129847391744134598193047835559,
10675851022949521071610438719596041103,
10675851022949521071610447515689063311,
10675851022949521071612690519409726351,
2733017861875077394328192262180637676463,
2733017861875077394328192270976730698671,
2733017861875077394328194513980451361711, 638815783976211381832672138184,
163536840697910113749198346441673, 41865431218664989119794810968134603,
10675689397488092720252943553077237720,
2732976485756951736384753549621516883929, 41701911708937862188488129071406024
, 699631263939838915010123856748150119587800,
179105603568598762242591707327526464341270490,
179105592852184824057195122130739251399546872,
11737864130417382660585586404459975510552587263992,
3004893217386849961109910119541753730701494963396601,
769252663651033590044136990602688955059582743253344251,
41701911708937862188488129072389064, 10675689397488092720252961076542757834,
699631263939838915010123856748150120570840,
699631222078846968973418445823268521105368,
179105592852184824057195122130756774862903258,
179105592852184824057195122130756774862903257,
45851031770159314958641951265473734398363162587,
11737864130417382660585586404459975510552588247032,
3004893217386849961109910119541753730701494964379641,
179805213398251656460089890405068472237545432,
46030134629952424053783011943697528924132464602,
11783714465267820557768451057586567404609231771614,
46030134629952424053783011943697528924132464601,
11783714465267820557768451057586567404609231771611,
3016630903108562062788723470742161255579994654365663,
3004939067716234655512941691054652769262093488084984,
769264401335356071811313072909991108931095963167610874,
196931686741851154383696146664957723886360566601126238206,
46030831528239878133280077010782397928893177816,
11783892871229408802119699714760293869827973832666,
769264447007282238402028632891513560008619035622629368,
196931698433864253030919330020227471362206473149610450938,
196931698433864253030919330020227471362206473149610450937,
50414514799069248775915348485178232668724857126330492772347,
46209237489828123118422034163520493058245648344,
769276139020380885625374264846055368843528036788199416,
196934691589217506720095811800590174423943177447996383225,
9747114307264864620661120, 2495261262659805359797193089,
638786883240910172124989376901, 163529413132485764396178314939272,
41863529761916355685421665523911564, 41863529761916355685421665523911561,
10717063619050587055467946391020817293, 162898063712450220455979763649936,
41701904310387256436730835867291025, 10675687503459137647803093998399409557,
2732975998986558293724869228696211607448,
699641855740558923193566522546246535925660,
699641855740558923193566522546246535925657,
179108315069583084337553029771839129561386909,
2732975998979140400453577589994540157864,
699641855738659942516115863038618076892073,
179108315069096945284125660937886243480849325,
45851034481659813139149011058853980474738921400,
11737864827304912163622146831066619001548425318329,
3004893395790057513887269588753054464396412142931901,
41865431218664989119927267769734611, 10717550391978237214667604098923124183,
41865431218664989119936063862756819, 10717550391978237214667612895016146391,
2743568771348362784746960380597366775251,
702353605465180872895221823656475748294103,
699641856225432870166273914278420999722483,
179108315193710814762566122021499324697040375,
179111037452645533512888673851033117153844723,
179111037452645533512888673851041913246866931,
179111037328517186738540450856475939283490291,
705075740272199072046168917411484899892691, 636320674568896461065857091971,
636320674568896461100216830339, 636320674568896469896309852547,
179105592810323837053247167304550824615824819,
179105592810323837053247167304550858975563187,
163536840697910113749713752708564, 163536840697910113749748112446932,
41865431218664989119926752373659093, 41865431218664989119935548466681301,
2732976000880597149087007477647949321716,
2732976000880597149087007477682309060084,
10717065513079542127917813984571514324,
179108315069581816696624208099372773782281716,
45851728657812945074335797273439430118824173045,
699652490049399081493393400568915916019676,
179111037452646164862308710545642505103267805,
180499389509683593793239277795414788423211004,
45852425556100399156240970400891284908190851036,
11829207982771707126415154153179425702140860162044,
3028277243589557024362279463213932979748091822596093,
10758603887947820748946058023925734868,
179111037328517184204331915096232296648433140,
45852425556100399156308970264635467972308262389,
10758601993899560642314237428265735636,
2754202110438287524432444781667424490965,
179111037328032307849744617350159807672440308,
45851728657812945074267797409695264715614248924,
11783536056605116410221289002157041857845332729852,
3016585230490909801016649984552202715608436549279741,
45851728657688816727493449186700707537743894492,
11738042536368337082238322991795381129692755122141,
11783536056573339553447055857070435220310505805820,
46030134629952424053783011943697529439531785716,
11783714465267820557768451057586567536550630350325,
3016630903108562062788723470742161289356991862889975,
46030134629993962431127170643296533959963794932,
46208540602174493005194624673106921014008700404,
11829386394156670209329823916315371779616720510454,
775262358562136089556863565950825981761983753887408124,
198467163791906838926557072883411451331067841025661198333,
50807593930728150765198610658153331540753367302599751491583,
775262358562832987844479907200828186321395593194758140,
772269203387288361968627404545708779742454543783813116,
197700916067145820663968615563701447614068363239140876286,
2485627635034751799434234244, 636320674568896460550461016453,
162898092689637493900813317261703, 41701272960967220892791153186917780,
10675525878007608548554535110612962710,
10675525878007608548554535110612962709,
2732934624769947788429960988211680464279,
699631221915327488489246747283400060784052,
179105592810323837053247167304550309219749301,
45851031759442902285631274829964879053914852791,
2732934461238097421946664047288132946828,
699631222076952940018345996105655718628237,
179105592851699952644696575003047757653068687,
699631263454967512145204320334250802007964,
179105603444471683109172306005568099532787614,
179105603444471683109172306005568099532787613,
45851034481784750875948110337425433374612377503,
179105603444471683109172306005436673529466812,
45851034481784750875948110337391788318798368701,
11737864827336896224242716246372297809507637252031,
3004893396489709836971870327129819743426594300485628,
769252709501365718264798803745233854317208173548134397,
196928693632349623875788493758779866705205292460946219007,
11738043236020660491357615026986231620192988291068,
3004939068421289085787549446908475294769438161100797,
3004893397186608124588211577132024302838433607835644,
11738043932918948107698865029190791032032295641084,
3004939246827250715570909447472842504200300842704894,
46208543335025390713268651001572189085268172796,
46209240233313007054518653206131600924575522812,
11829565499728129805956775220769689836725561974781,
3028368767930401230324934456517040598201778093678591,
10717550391978237214701381096128402903,
10717550391978237214703632895942088151,
10717550391978237214701389892221425111,
702353605465180872895221857433472953572823,
179108315193710814762566122055276321902319095,
179108315193710814762566122057528121716004343,
45851728689589802497326327514672961875453435383,
45851728689589802497326327514672970671546457591,
45851728657812945723093182428066324340626511351,
179802491222228880470646251665824019477847511,
162898092689637494033270108670343, 162898092689637494033304468408711,
162898092689637494042100561430919,
45851031759442902285631274829965011510706261431,
45851031759442902285631274829965011545065999799,
3016631080823038021679096952397214937116167099211771,
775250712041868883965569918470071808239856946162917371,
3016676752749204612395290817548236744499779043680251,
775262404054967531188915547948733537927553441319837691,
11829387093766541560971642935024085128968292818939,
3028323096004234639608740591366165754683330187517951,
3016631080823038063217471820675835967629529732767739,
772257556690697744183672786093014007674827058780987391,
11829565499728129805956775220769689855108037238779,
3028368767930401230324934456517040564575104758996991,
11829565499728129805956775220769689863904130260987,
3028368767930401230324934456517040564583900852019199,
3016676752749204653933665685826857775013141677236219,
772269248703796391407018415571675590365031716564918271,
41863532237987538460419364433052133, 10717064252924809845867295993774883303,
41863532237987538460419398792790501, 10717064252924809845867296028134621671,
2743568285211843565915032722903721722357,
2743568285211843565915032722938081460725,
180499400018893703118330627319090426967214573,
11829207985462065076045237032876322915138547468797,
3028277244278288659467580680416338666214166505179647,
2743568448731343355120913234397757850613,
2743568285211775566050140271021530694629,
702353481014214544908835909302686769890279, 638816050490705392237776224725,
638816050490705401033869246933, 638816050490705392272135963093,
10675687503508060322905679892012220917,
10675687503508060322905679926371959285,
699641855740554039698898745863012326951389,
41863537160733475931206956021205461,
699641855740554039698897597462699534600693,
699641855738659991438792114060008853979613,
10717065513079769973456067103266261973,
179108315069581816754952665288855729180199925,
2732976000880655477544771169555836879837,
702353481336849030632038154593547961156605,
10717064252924809845867427935170216423,
10717064252924809845869679734983901671,
10717064252924809845867427969529954791,
702353481014231952874248377133992535015927,
702353481014231952874248377134026894754295,
702353481014214544908835337477406768646631,
46029437721031146020520925613967968578284440055,
11783536753503403868143283986039504258230924037119,
11783536059295598488198146230076967405018094717935,
163536908925620580483511657447895, 163536908925620582735311471133143,
163536908925620580483546017186263, 2732976000898063442663854122994969494007,
2732976000898063442663854123029329232375,
699641856225447802251315002931856479898103,
2743568286472066525907588123347859425751,
10717550406910322401024367183584576479,
179108315193714637376336483376840588344312831,
11738043233287809593664531414155434321612874566139,
3004939067721679255978120042023791134612414566615551,
45852431000576895692140921653786905985833878011,
702364114836920601275826593586032607085019,
702364114836920601275826593586066966823387,
702364114836920601275826593594828700107227,
179805213398251673926611607901817859720200671,
179805213398251673926611607901826655813222879,
179805213398251673926611607901826690172961247,
180504833944641105999526891902119484790786523,
179805213398251656518646194283448790557246939,
179805213398251656518646194283457586650269147,
46209237489828123118470919060265504386957299163,
11829564797395999518328555279427912899049907670495,
10717064252924809845867498578792301031,
10717064252924809845867507374885323239,
10717064252924809845867498613152039399,
46207846404836787998292640593687290587512293871,
705075781325697644065949994773889717586407,
702353522390347544323508468122031288140271,
702353522390347544323508468122065647878639,
702353522875223898910953788129586474010095,
46207846404836787980884675181219591223142501863, 148735952212037992555,
37927667815169199702251, 37927667815169199702379, 37927667815169199718507,
2485627191727355709557343467, 636310927305842056457908962539,
2361764241246003396849, 40140696104203165106673, 40140696104203165122801,
9711547253021236562821873, 2485591625823781786361086705,
2486156096773375262292279545, 636311456210888076010643882489,
10675849755327668546240570666401602209,
2733017537363883147837586029138346973861,
2733017537363883109756622508971396651681,
699652489565154076097695362235217075460773,
2733017537363883147837586029138346973873,
699652489565154085846422023397956362115765,
699652489565154076097695362235217075460785,
179111037328679443481010012732154110850587317,
699652489564520250797581247534468723874473,
179111037328517184204180799368762532840315565,
179111037328517184194432072707599793553660585,
45852425556100399153774610613145485689261382317,
179111037328517184204180799368762532840315577,
45852425556100399156270284638403146946649234109,
45852425556100399153774610613145485689261382329,
11738220942361702183366300316965244274990438144701,
10758605791899600579565101320941836969,
2754203082726297748368665876717818321579,
2754203082726297748368665876717818321581,
2754203082726287999642002470974811003561,
705075989177929727908352632508108320791213,
180499453229550010344538273922014286826429103,
10758605160550180544021169918481504937,
2754202921100846219269419437687973321387,
2754202921100846219269419437687973321389,
2754202921100836470542753788941245340329,
705075947801814136458944969907515511003821,
180499442637264418933489912296262527520856751,
2754202921100846219269414951680531995321,
705075947801816632132970227568772898855611,
705075947801816632132970227568772898855613,
705075947801814136458944965421508069677753,
180499442637264418933489911147844622541380285,
46207857315139691246973417253848161927297227455,
2754202920467020919155304745735714740907,
705075947639557355303758012603895961066159,
705075947639554859629731606524733593737899,
180499442595726044065211291268027352980118191,
705075947639557355303756864185990981589691,
180499442595726682957761757229309244274350783,
180499442595726044065211290119609448000641723,
46207857304505867280694090270617714241147493055,
2754203083360123048482780586262262946475,
705075989340191500411591827778692301691567,
705075989340189004737565995908482424101547,
180499453271088385212816894950267053553212079,
705075740759613193814159302057729713232553,
180499389634460977616424781326717363024026285,
180499389634460977616424781326717363024026283,
46207843746422010269804744019639583490587220655,
705075740597987742285060053375696147569321,
180499389593084862024975373664116770214238891,
180499389593084862024975373659630762772912825,
46207843735829724678393695656865413826302171835,
41865431218513873392387203304692457, 10717550391939551588451062748117637867,
10717550391939551588451062748117637869,
10717550389443877562033768567146994409,
2743692899697632655880644691891742759661,
702385382322593959905445041062988258663151,
10717550391939551588439847729514322681,
2743692899697632655880633476873139444473,
10717066146914590378402405622615612137,
2743568933610135136871015778091696364269,
2743568933610135136871002320069372386041,
702353647004194595038976593876461430479611,
702353647004194595038976593876461430479613, 604611645829620491616499,
10276018202746653889266163, 10276018202746653889282291,
2630660659869437042068816635, 636455960773984137790420435707,
638816350509710719138333203179, 638816350509710727934426225387,
163536985730485901421044832410351, 162898093179723074110716343507691,
163536985730483030376282383719163, 41701911854009104058620253017496315,
162898093179723076380108343286507, 41701911854009107506143359955704559,
604611645829620491616501, 10276018202746653889266165,
10276018202746653889282293, 162895597956830808516563449218037,
41701270466235451836760534082995189, 604611645759251747438837,
10276018202676285145088501, 2486156096773436834943353333,
636455960773984067421676274429, 162895732789987347458999686562813,
10717550391939551588451124320768793325,
2743692900336525206643487764818927459055,
2743692900336525206643490016618741144303,
2743692900336380701932230224212149050349,
702385382486113459694650937337012273191919,
2743692900336380701932230233008242072557,
2743692900336525206640601019030434126589,
702385382486113459694648050591223779859453,
179108315235249179592491420961264733429144557,
179108315235249179592491420961273529522166765, 154780581350467887985328375,
2630660659921228437783577079, 41865431218512701443147713818827752,
10717550391939251569445814771869195242,
10717550391939251569445814771869195244,
10717550391939251569445814771869195241,
2743692900336448401778128581632763272171,
2743692900336448401778128581632763272173,
2732976000880596996799335316042831862760,
699641856225432831180629840906998922058729,
699641980354410954948888379360566680395768,
179108346970729204466915425116305103895568380,
179108346970729204466915425116305103895568377,
45851736824506676343530348829774106630979756029,
10675849755317997876382612379160349088,
2733017537361407456353948768933277665698,
2733017537361407456353948768933277665697,
699652489564520308826610884846787310717347,
179111037328517199049712096832396061587114920,
45852425556100402956726296789093391634521230252,
45852425556100402956726296789093391634521230249,
11738220942361703156921931978007908258305654754221,
3004984561236460884580485934845883470078466913046456,
769276047676533986452604399320546168340087397424664506,
769276047676533986452604399320546168340087397424664505,
196934668205192700531866726226059819095062373608398884795,
10717550391939251569445815287279525362,
2743692900336448401778128582148173602294,
2743692900336448401778128713574172859891,
702385382486130790855200917029963056553463,
10717550391939251569445815321639263730,
2743692900336448401778128582182533340662,
702385382486113382889785578154341519335418,
702385382486113382889785578154375879073786,
179810657916445026019785108007520255657123835, 638816050490705304689152367594
, 163536908925620558000457364020203, 638816050490705304723512105962,
162898092879704068696267162672106, 41701911777204241586244427997797355,
162898092879704068696301522410474, 10675687503508060324054010248365613050,
2732976000898063442957826623615419817979,
10675687503508060324054010282725351418,
2743692900336448401778128714089568935411,
702385382486130790855200917030478452628983,
2743692900336448401778128714123928673779,
702385382486130790855200917030512812367351,
2743692900336448401778128722885661957619,
702385382486130790855200917039274545651191,
179813380175380393527492815580832250128769019,
179813380175380393527492815580841046221791227,
10717550391939251569445815287279525364,
10717550391939251569445815321639263732,
2743692900336448401778128713574172859894,
2743692900336448401778128713574172859893,
2743692900336448401778128722370265882101,
702385382486130790855200950675018866499063,
702396016145921346381646438961749894962676,
179813380133355864673701488374208003440713205,
10717876826939881319376069364379820030,
2743776467696609617760273757315591577599,
10717876826939881319376069398739558398,
2732976812194447589026372928818525528062,
2732976812194447589026372928852885266430,
699642063921778582790751469786372981678079, 163536908925620557895557082782702
, 41865448684958862821262647550286831, 163536908925620557895591442521070,
163536908925620557904353175804910, 41701911777204241586139527716559854,
10675689414964285846051719129793059823, 41865448684958862830235177829015031,
41865448684958862830243973922037239, 41865448684958862832486977642700279,
10675689414964285846060691660071788023, 148735952212037992569,
37927667815169199702265, 37927667815169199718521,
2743694035512570160355183185339523505912,
702385673091217961050926895446952249892601,
179810732311351798029037285234419810204884731,
702385673091217961050926895446952249892604,
702385673091217960486455367062137321529336,
179810732311351797884532573967907188543823866, 580999811180789775,
4613955547866071175, 1185205576265277374607, 1182899733256063680655,
1187511419274491068559, 303416660479922571068039, 77674669115816189752263311,
2323866272535675267, 594925519640455020935, 594925519640455020939,
594916512441200279943, 152300939774628552769935, 594916512441200279947,
152298642938818593816975, 594912008841572909447, 152300935271028925399439,
594921016040827650439, 152300944278228180140431, 594912008841572909451,
152297490017313986969999, 594930023240082391435, 152302101703332414357903,
152297481010114732229007, 152302092696133159616911, 152299786853123945922959,
594909757041759224203, 152296913556561683546511, 594927771440268706187,
152301516235380856193423, 152301534249779365675407, 152303831085589324628367,
303414370390647240672131, 77674078835759564929909639,
77674078835759564929909643, 77674078826752365675168647,
19884564181961195294119969679, 77674078826752365675168651,
19884564179664359484161016719, 77674078822248766047798151,
19884564181956691694492599183, 77674078831255965302539143,
19884564181965698893747340175, 19884564181983713292256822159,
19884564179650848685278905231, 19884564179668863083788387215,
77674078822248766047798155, 19884564178511437979554169743,
77674078840263164557280139, 19884564180808273789513122703,
19884564185419959807940510607, 303414370390647240672133,
77674078820058538885268359, 77674078820023354513179527,
19884564181954466282957980559, 1182915486989947011459,
302826380423297748730247, 302826380423297748730251,
77523553404118094988738959, 302826389430497003471239,
77523553395110895733997967, 77523553413125294243479951,
77523551098275085775045007, 77523555709961104202432911,
77523555718968303457173903, 302826366912498866618763,
77523549945353581168198031, 77523554557039599595585935,
77523552242189391127150991, 77523552260203789636632975,
77523549931842782286086543, 77523549949857180795568527,
77523554543528800713474447, 77523554561543199222956431,
77523552237685791499780495, 77523552255700190009262479,
77523556849371809927168399, 77523552246692990754521487,
77523552264707389264003471, 77523556858379009181909391,
77523550508303534589510031, 77523550526317933098992015,
77523555138003951526379919, 77523557443846960740073871,
77826372848989101774390147, 19923551449356963925553365895,
5100429171035389511613716415375, 5100429171035407526012225897359,
19923551449343453126671254407, 19923551449361467525180736391,
5100429171035403022412598526863, 5100429171037708865421812220815,
1161999106965520769, 297471832990179934595, 297471832990179934597,
76152789307093069873543, 297471832990179934601, 76152789271908697784711,
76152789342277441962375, 76152789271908697784715, 76152780299893815132551,
76152789271908697784717, 76152798349476696703367, 19495114053635049267413391,
297471868174552023433, 19495116368520442107937167, 76152775743517629628807,
19495114049113857453998479, 297471780213621801353, 76152775796294187762059,
76152775796294187762061, 19495110603877734701613455,
19495110603948103445791119, 19495110594905719818961295, 297471771417528779145
, 76152773544494374076813, 76152791558892883558795,
19495114639138185197666703, 19495110027416982398189967,
76152791594077255647627, 19495114639103000825577871,
19495114639173369569755535, 76152800566092138299787,
19495118097937883390296463, 299768668800138888065, 76740779274442561831811,
76740779274442561831813, 19645639494318902835430279, 76740779274442561831817,
19645639494318902835430283, 76740779239258189742979,
19645639494283718463341447, 19645639494283718463341451,
19645639494354087207519115, 76740779239258189742981,
19645639485311703580689287, 19645639494283718463341453,
5029283710536693533621896079, 5029283710554707932131378063,
19645639485276519208600455, 19645639485346887952778119,
5029283710536658349249807247, 5029283710554672747759289231,
76740779239258189742985, 19645639485311703580689291,
19645639485311703580689293, 5029283708239857723662943119,
76740779309626933920649, 19645639503326102090171275,
19645639503326102090171277, 5029283712851543742090331023,
19645639485276519208600459, 19645639485346887952778123,
5029283708239822539290854287, 5029283708239892908035031951,
19645639503290917718082443, 19645639503361286462260107,
5029283712851508557718242191, 5029283712851578926462419855,
76740779221666003698563, 76740779292034747876227, 19645639494266126277297031,
19645639494266126277297035, 19645639494336495021474699,
19645639485258927022556039, 19645639485329295766733703,
5029283710536640757063762831, 5029283710536711125807940495,
5029283710554725524317422479, 19645639485258927022556043,
19645639485329295766733707, 5029283708239804947104809871,
5029283708239875315848987535, 19645639485294111394644875,
19645639485364480138822539, 5029283708239840131476898703,
19645639503308509904126859, 19645639503378878648304523,
5029283712851596518648464271, 19645639480755327395185543,
19645639480825696139363207, 19645639498769725904667527,
5029283710532137157436392335, 5029283710532207526180569999,
5029283708226294148222698383, 5029283708226364516966876047,
5029283708244308546732180367, 5029283708244378915476358031,
5029283708226329332594787215, 5029283708226399701338964879,
5029283708244343731104269199, 5029283712838015351022175119,
5029283712838085719766352783, 5029283712856100118275834767,
76740779221666003698569, 19645639480808103953318795,
19645639480808103953318797, 76740779292034747876233,
19645639498822502462800779, 5029283711698622237483484047,
19645639480772919581229963, 19645639480843288325407627,
5029283707086901034684007311, 5029283707086971403428184975,
19645639498787318090711947, 19645639498857686834889611,
5029283711698587053111395215, 5029283711698657421855572879,
19645639480772919581229965, 5029283707077929019801355151,
19645639498787318090711949, 5029283711689615038228743055,
5029283711707629436738225039, 19645639480755327395185547,
19645639480825696139363211, 5029283707086883442497962895,
19645639498769725904667531, 19645639498840094648845195,
5029283711698569460925350799, 5029283707077876243243221903,
5029283707077946611987399567, 5029283711689562261670609807,
5029283711689632630414787471, 5029283711707647028924269455,
76740779212869910676355, 19645639494257330184274823,
19645639494257330184274827, 19645639494327698928452491,
76740779248054282765187, 19645639494292514556363655,
19645639494292514556363659, 19645639494362883300541323,
19645639485250130929533831, 5029283710536631960970740623,
5029283710536702329714918287, 5029283710554646359480222607,
5029283710554716728224400271, 19645639485285315301622663,
5029283710536667145342829455, 5029283710554681543852311439,
19645639485250130929533835, 19645639485320499673711499,
5029283708239796151011787663, 5029283708239866519755965327,
19645639503264529439015819, 19645639503334898183193483,
5029283712851482169439175567, 5029283712851552538183353231,
76740779230462096720771, 19645639494274922370319239,
19645639494274922370319243, 19645639494345291114496907,
76740779265646468809603, 19645639494310106742408071,
19645639494310106742408075, 19645639494380475486585739,
19645639485267723115578247, 5029283710536649553156785039,
5029283710536719921900962703, 5029283710554663951666267023,
5029283710554734320410444687, 19645639485302907487667079,
5029283710536684737528873871, 5029283710554699136038355855,
19645639485267723115578251, 19645639485338091859755915,
5029283708239813743197832079, 5029283708239884111942009743,
19645639503282121625060235, 19645639503352490369237899,
5029283712851499761625219983, 5029283712851570130369397647,
19645639480746531302163335, 19645639498760929811645319,
5029283710532128361343370127, 5029283710532198730087547791,
19645639480781715674252167, 19645639498796114183734151,
5029283710532163545715458959, 5029283710532233914459636623,
19645639489753730556904327, 5029283710541135560598111119,
5029283710541205929342288783, 5029283710559149959107593103,
5029283710559220327851770767, 19645639489788914928993159,
5029283710541170744970199951, 5029283710559185143479681935,
5029283708226285352129676175, 5029283708226355720873853839,
5029283708244299750639158159, 5029283708244370119383335823,
5029283712837971370557064079, 5029283712838041739301241743,
5029283712855985769066546063, 5029283712856056137810723727,
19645639480764123488207751, 19645639498778521997689735,
5029283710532145953529414543, 5029283710532216322273592207,
19645639480799307860296583, 19645639498813706369778567,
5029283710532181137901503375, 5029283710532251506645681039,
19645639489771322742948743, 5029283710541153152784155535,
5029283710541223521528333199, 5029283710559167551293637519,
5029283710559237920037815183, 19645639489806507115037575,
5029283710541188337156244367, 5029283710559202735665726351,
5029283708226302944315720591, 5029283708226373313059898255,
5029283708244317342825202575, 5029283708244387711569380239,
5029283712837988962743108495, 5029283712838059331487286159,
5029283712856003361252590479, 5029283712856073729996768143,
19645639480746531302163339, 19645639480816900046341003,
5029283707086874646404940687, 5029283707086945015149118351,
19645639498760929811645323, 19645639498831298555822987,
5029283711698560664832328591, 5029283711698631033576506255,
19645639480781715674252171, 19645639480852084418429835,
5029283707086909830777029519, 5029283707086980199521207183,
19645639498796114183734155, 19645639498866482927911819,
5029283711698595849204417423, 5029283711698666217948595087,
5029283707077867447150199695, 5029283707077937815894377359,
5029283707095881845659681679, 5029283707095952214403859343,
5029283711689553465577587599, 5029283711689623834321765263,
5029283711707567864087069583, 5029283711707638232831247247,
5029283707077902631522288527, 5029283707077973000266466191,
5029283707095917030031770511, 5029283707095987398775948175,
5029283711689588649949676431, 5029283711689659018693854095,
5029283711707603048459158415, 5029283711707673417203336079,
19645639489753730556904331, 19645639489824099301081995,
5029283709392717655618634639, 5029283709392788024362812303,
19645639507768129066386315, 19645639507838497810563979,
5029283714004403674046022543, 5029283714004474042790200207,
19645639489788914928993163, 19645639489859283673170827,
5029283709392752839990723471, 5029283709392823208734901135,
19645639507803313438475147, 19645639507873682182652811,
5029283714004438858418111375, 5029283714004509227162289039,
5029283709383710456363893647, 5029283709383780825108071311,
5029283709401724854873375631, 5029283709401795223617553295,
5029283713995396474791281551, 5029283713995466843535459215,
5029283714013410873300763535, 5029283714013481242044941199,
5029283709383745640735982479, 5029283709383816009480160143,
5029283709401760039245464463, 5029283709401830407989642127,
5029283713995431659163370383, 5029283713995502027907548047,
5029283714013446057672852367, 5029283714013516426417030031,
76740779212869910676357, 19645639478556304139633543,
19645639494257330184274829, 5029283710529938134180840335,
19645639478521119767544711, 5029283710529902949808751503,
5029283710529973318552929167, 76740779248054282765189,
19645639487563503394374535, 19645639494292514556363661,
5029283710538945333435581327, 19645639494362883300541325,
5029283710556959731945063311, 19645639487528319022285703,
5029283710538910149063492495, 5029283710556924547572974479,
19645639485250130929533837, 5029283708224095124967146383,
19645639485320499673711501, 5029283708242109523476628367,
5029283708224130309339235215, 5029283708242144707848717199,
19645639478573896325677959, 5029283710529885357622707087,
5029283710529955726366884751, 19645639487581095580418951,
5029283710538892556877448079, 5029283710538962925621625743,
5029283710556977324131107727, 5029283708224112717153190799,
5029283708242127115662672783, 5029283708224147901525279631,
19645639492084695207789447, 5029283710543396156504818575,
5029283710561480923758478223, 5029283708228616316780561295,
5029283708228651501152650127, 5029283707071173620360299407,
19645639498760929811645325, 5029283707080180819615040399,
19645639498796114183734157, 5029283707071191212546343823,
5029283707080198411801084815, 5029283707098212810310566799,
76740779212869910676361, 19645639478556304139633547,
19645639478556304139633549, 5029283706510475466752672655,
19645639496570702649115531, 5029283711122161485180060559,
19645639478521119767544715, 19645639478591488511722379,
5029283706510440282380583823, 5029283706510510651124761487,
19645639496535518277026699, 19645639496605887021204363,
5029283711122126300807971727, 5029283711122196669552149391,
19645639478521119767544717, 5029283706501468267497931663,
19645639478591488511722381, 5029283706519482666007413647,
5029283711113154285925319567, 5029283711131168684434801551,
5029283706501433083125842831, 5029283706501503451870020495,
5029283706519447481635324815, 5029283706519517850379502479,
5029283711113119101553230735, 5029283711113189470297408399,
5029283711131133500062712719, 19645639487563503394374539,
19645639487563503394374541, 5029283708816318475966366607,
19645639505577901903856523, 19645639505577901903856525,
5029283713428004494393754511, 19645639487598687766463371,
5029283708816283291594277775, 5029283708816353660338455439,
19645639505613086275945355, 5029283713427969310021665679,
5029283713428039678765843343, 19645639487528319022285709,
5029283708807311276711625615, 5029283708825325675221107599,
19645639505542717531767693, 5029283713418997295139013519,
19645639505613086275945357, 5029283713437011693648495503,
5029283708807346461083714447, 5029283708825290490849018767,
5029283713418962110766924687, 5029283713419032479511102351,
5029283713436976509276406671, 19645639478573896325677963,
5029283706510422690194539407, 19645639496588294835159947,
5029283711122108708621927311, 5029283706501485859683976079,
5029283706519500258193458063, 5029283711113171878111363983,
5029283711131186276620845967, 19645639487581095580418955,
5029283708816265699408233359, 5029283708816300883780322191,
5029283708816371252524499855, 5029283713427986902207710095,
5029283713428057270951887759, 5029283708807328868897670031,
5029283708825343267407152015, 5029283706496982260056605583,
5029283706514926289821909903, 5029283711126612308249297807,
5029283706505989459311346575, 5029283706524003857820828559,
5029283711135689876248216463, 5029283708820769299035603855,
5029283708820874852151870351, 5029283713432490501835080591,
5029283713432560870579258255, 19645639483059903767004045,
5029283707672404170614260623, 5029283712284090189041648527,
5029283709969275164945302415, 5029283714580961183372690319,
5029283714589898013883253647, 5029283709978264772013998991,
1181753619824377872769, 302528926736647474659715, 302528926736647474659721,
77447405244643360252117389, 302528926701463102570883,
77447405244608175880028555, 19826535742628726646909190543,
302528926701463102570885, 77447405235636160997376391,
77447405244608175880028557, 77447405235600976625287559,
19826535742619719447654449551, 302528926701463102570889,
77447405235636160997376395, 77447405235636160997376397,
19826535740322918822067585423, 302528926683870916526467,
77447405244590583693984139, 77447405244660952438161803,
19826535742628709054723146127, 77447405235583384439243143,
19826535742619701855468405135, 19826535742619772224212582799,
77447405235583384439243147, 77447405235653753183420811,
19826535740322866045509452175, 77447405231079784811872647,
19826535742615198255841034639, 19826535742615268624585212303,
19826535740309355246627340687, 19826535740309425615371518351,
19826535740327369645136822671, 302528926683870916526473,
77447405231132561370005899, 19826535739169997317460738447,
302528926754239660704137, 77447405249146959879487883,
77447405249146959879487885, 77447405231097376997917067,
19826535739169962133088649615, 77447405231097376997917069,
19826535739160990118205997455, 77447405249111775507399053,
19826535743772676136633385359, 302528926675074823504265,
77447405228880761556320653, 77447405246895160065802635,
19826535743205222583584702863, 77447405228845577184231819,
19826535738593501380785226127, 77447405246859975693713803,
77447405246930344437891467, 19826535743205187399212614031,
19826535743205257767956791695, 302528926710259195593097,
77447405237887960811061643, 302528926780627939770761,
77447405255902359320543627, 77447405255902359320543629,
19826535745511065592798396815, 77447405237852776438972813,
19826535740890372375116267919, 77447405255867174948454797,
19826535745502058393543655823, 77447405255937543692632461,
19826535745520072792053137807, 77447405237835184252928395,
77447405237905552997106059, 77447405237870368625017227,
77447405237940737369194891, 77447405255884767134499211,
19826535745511048000612352399, 19826535740890319598558134671,
19826535740890389967302312335, 19826535740885851183302853007,
19826535740903865581812334991, 77447405242356376066343307,
77447405242426744810520971, 19826535742052265894605767055,
19826535742052336263349944719, 1181753619824377872772,
77447405228881002074489223, 302528926736647474659724,
302528926675177902719365, 77447405228880864635535751,
77447405244581890680177037, 302528926675177902719366,
77447405228845817702400391, 77447405244581890680177038,
302528926701463102570892, 77447405235574828864389517,
19826535740307156463889957263, 77447405228845611543970183,
19826535742612964082573132175, 77447405228845748982923655,
19826535742612964220012085647, 77447405235574622705959309,
19826535740307156257731527055, 77447405228828088077402503,
19826535742612946559106564495, 77447405235574622705959310,
19826535740307103687331824015, 302533529415466646291329,
77448583530421068448711555, 77448583530421068448711557,
19826837383787855129868288903, 77448583530421068448711561,
19826837383787855129868288907, 19826837383787855129868288909,
5075670370249690974853280088975, 77448583530385884076622723,
77448583530456252820800387, 19826837383787819945496200071,
19826837383787890314240377735, 19826837383787819945496200075,
19826837383787890314240377739, 5075670370249690939668908000143,
5075670370249691010037652177807, 77448583530385884076622725,
19826837383778847930613547911, 77448583530456252820800389,
19826837383796862329123029895, 19826837383787819945496200077,
5075670370249681967654025347983, 19826837383787890314240377741,
5075670370249699982052534829967, 19826837383778812746241459079,
19826837383778883114985636743, 19826837383796827144750941063,
19826837383796897513495118727, 5075670370249681932469653259151,
5075670370249682002838397436815, 5075670370249699946868162741135,
5075670370249700017236906918799, 19826837383778847930613547917,
5075670370247385131844066395023, 77448583530456252820800393,
19826837383796862329123029899, 19826837383796862329123029901,
5075670370251996817862493782927, 5075670370247385096659694306191,
5075670370247385167028438483855, 19826837383796827144750941067,
19826837383796897513495118731, 5075670370251996782678121694095,
5075670370251996853046865871759, 19826837383778812746241459085,
5075670370247376124644811654031, 19826837383778883114985636749,
5075670370247394139043321136015, 19826837383796827144750941069,
5075670370251987810663239041935, 19826837383796897513495118733,
5075670370252005825061748523919, 5075670370247376089460439565199,
5075670370247376159829183742863, 5075670370247394103858949047183,
5075670370247394174227693224847, 5075670370251987775478866953103,
5075670370251987845847611130767, 5075670370252005789877376435087,
5075670370252005860246120612751, 77448583530438660634755973,
19826837383792358729495659399, 19826837383787802353310155661,
5075670370249677464054397977487, 19826837383787872722054333325,
19826837383792323545123570567, 19826837383792393913867748231,
5075670370249677428870025888655, 5075670370249677499238770066319,
5075670370249695443268535370639, 77448583530473845006844805,
19826837383801365928750400391, 19826837383787837537682244493,
5075670370249686471253652718479, 19826837383787907906426422157,
5075670370249704485652162200463, 19826837383778865522799592333,
5075670370247389635443693765519, 5075670370251983307063611671439,
19826837383796879921309074317, 5075670370252001321462121153423,
19826837383778900707171681165, 5075670370247398642642948506511,
19826837383796844736936985485, 5075670370251992314262866412431,
19826837383796915105681163149, 5075670370247398607458576417679,
5075670370247398677827320595343, 5075670370251992279078494323599,
5075670370251992349447238501263, 5075670370252010293477003805583,
19826837383792305952937526151, 19826837383792376321681703815,
5075670370249677481646584021903, 5075670370249695425676349326223,
19826837383792341137309614983, 19826837383792411506053792647,
5075670370249677516830956110735, 5075670370249695460860721415055,
19826837383801313152192267143, 19826837383801383520936444807,
5075670370249686488845838762895, 5075670370249704432875604067215,
5075670370249704503244348244879, 5075670370247389582667135632271,
5075670370247389653035879809935, 5075670370252001268685563020175,
5075670370252001339054307197839, 5075670370247398589866390373263,
5075670370247398660235134550927, 5075670370251992331855052456847,
5075670370252010275884817761167, 5075670370247398625050762462095,
5075670370247398695419506639759, 5075670370251992367039424545679,
5075670370252010311069189849999, 19826837383774344330986177421,
5075670370246232210339459548047, 19826837383792358729495659405,
5075670370246232175155087459215, 5075670370246232245523831636879,
5075670370250843861173514847119, 19826837383774379515358266253,
5075670370246241217538714289039, 19826837383792393913867748237,
5075670370250852903557141676943, 5075670370248538053348673241999,
19826837383801365928750400397, 5075670370253149739367100629903,
19826837383783386714613007245, 5075670370248547060547927982991,
19826837383801401113122489229, 5075670370248547025363555894159,
5075670370248547095732300071823, 5075670370253158711381983282063,
5075670370246232227931645592463, 5075670370250843843581328802703,
5075670370246232263116017681295, 5075670370250843878765700891535,
5075670370246241235130900333455, 5075670370250852850780583543695,
5075670370250852921149327721359, 5075670370253149686590542496655,
5075670370253149756959286674319, 5075670370248547078140114027407,
5075670370253158693789797237647, 5075670370248547113324486116239,
5075670370253158728974169326479, 19826837383792376321681703821,
5075670370250848399957514306447, 5075670370250848364773142217615,
5075670370250848435141886395279, 19826837383792411506053792653,
5075670370250857407156769047439, 5075670370250857371972396958607,
5075670370250857442341141136271 ]; 
