# $Id: joingrdialog.tcl 1342 2007-12-31 14:15:42Z sergei $

#set gr_nick $user
set gr_group "talks"
set gr_server conference.jabber.org
set gr_passwd ""

custom::defvar gr_nick_list {} \
        [::msgcat::mc "Join group dialog data (nicks)."] -group Hidden
custom::defvar gr_group_list {} \
        [::msgcat::mc "Join group dialog data (groups)."] -group Hidden
custom::defvar gr_server_list {} \
        [::msgcat::mc "Join group dialog data (servers)."] -group Hidden

proc ecursor_entry {e} {
    $e icursor end
}

proc pack_input {fr row var lab args} {

    label $fr.l$var -text $lab
    ecursor_entry [eval entry $fr.$var -textvar $var $args]

    grid $fr.l$var -row $row -column 0 -sticky e
    grid $fr.$var  -row $row -column 1 -sticky ew
}

proc pack_combo {fr row var lab args} {

    label $fr.l$var -text $lab
    ecursor_entry [eval ComboBox $fr.$var -textvariable $var $args].e

    grid $fr.l$var -row $row -column 0 -sticky e
    grid $fr.$var  -row $row -column 1 -sticky ew
}

proc update_combo_list {list entry num} {

    set ind [lsearch -exact $list $entry]
    if {$ind >= 0} {
	set newlist [linsert [lreplace $list $ind $ind] 0 $entry]
    } else {
	set newlist [linsert $list 0 $entry]
    }
    if {[llength $newlist] > $num} {
	return [lreplace $newlist end end]
    } else {
	return $newlist
    }
}

proc join_group_dialog {args} {
    global gr_nick gr_group gr_server gr_connid gr_passwd
    global gr_nick_list gr_group_list gr_server_list

    if {[llength [jlib::connections]] == 0} return

    set gr_passwd ""
    foreach {opt val} $args {
	switch -- $opt {
	    -server     {set server $val}
	    -group      {set group $val}
	    -nick       {set nick $val}
	    -password   {set gr_passwd $val}
	    -connection {set connid $val}
	}
    }

    set gw .joingroup
    catch { destroy $gw }

    Dialog $gw -title [::msgcat::mc "Join group"] -separator 1 -anchor e \
	    -default 0 -cancel 1 -parent . -modal none

    set gf [$gw getframe]
    grid columnconfigure $gf 1 -weight 1

    if {[info exists group]} {
	set gr_group $group
#	set gr_group_list [update_combo_list $gr_group_list $gr_group 20]
    } elseif {[llength $gr_group_list]} {
	set gr_group [lindex $gr_group_list 0]
    }
    if {[info exists server]} {
	set gr_server $server
#	set gr_server_list [update_combo_list $gr_server_list $gr_server 10]
    } elseif {[llength $gr_server_list]} {
	set gr_server [lindex $gr_server_list 0]
    }
    if {[info exists nick]} {
	set gr_nick $nick
#	set gr_nick_list [update_combo_list $gr_nick_list $gr_nick 10]
    } else {
	set gr_nick [get_group_nick ${gr_group}@$gr_server $gr_nick]
    }
    if {![info exists connid]} {
	set connid [jlib::route ${gr_group}@$gr_server]
    }
    set gr_connid [jlib::connection_jid $connid]

    pack_combo $gf 0 gr_group [::msgcat::mc "Group:"] -values $gr_group_list
    pack_combo $gf 1 gr_server [::msgcat::mc "Server:"] -values $gr_server_list
    pack_combo $gf 2 gr_nick [::msgcat::mc "Nick:"] -values $gr_nick_list
    pack_input $gf 3 gr_passwd [::msgcat::mc "Password:"] -width 30 -show *

    if {[llength [jlib::connections]] > 1} {
	foreach c [jlib::connections] {
	    lappend connections [jlib::connection_jid $c]
	}
	pack_combo $gf 5 gr_connid [::msgcat::mc "Connection:"] \
	    -values $connections
    }

    $gw add -text [::msgcat::mc "Join"] -command [list join_group1 $gw]
	    
    $gw add -text [::msgcat::mc "Cancel"] -command [list destroy $gw]

    $gw draw $gf.gr_group
}

proc join_group1 {gw} {
    global gr_nick gr_group gr_server gr_connid gr_passwd
    global gr_nick_list gr_group_list gr_server_list

    destroy $gw

    set gr_nick_list [update_combo_list $gr_nick_list $gr_nick 10]
    set gr_group_list [update_combo_list $gr_group_list $gr_group 20]
    set gr_server_list [update_combo_list $gr_server_list $gr_server 10]

    foreach c [jlib::connections] {
	if {[jlib::connection_jid $c] == $gr_connid} {
	    set connid $c
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route ${gr_group}@$gr_server]
    }

    join_group ${gr_group}@$gr_server \
	       -nick $gr_nick \
	       -password $gr_passwd \
	       -connection $connid
}

proc join_group {jid args} {
    global gr_nick

    set password ""
    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	    -password   { set password $val }
	    -nick       { set nick $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $jid]
    }
    if {![info exists nick]} {
	set nick [get_group_nick $jid $gr_nick]
    }

    set cw [chat::winid [chat::chatid $connid $jid]]

    muc::join_group $connid $jid $nick $password

    raise_win $cw
    focus -force $cw.input
}

proc set_our_groupchat_nick {group nick} {
    global groupchats

    set group [tolower_node_and_domain $group]
    set groupchats(nick,$group) $nick
}

proc get_our_groupchat_nick {group} {
    global groupchats
    
    debugmsg conference "GET NICK: [list $group]"
    return $groupchats(nick,$group)
}

###############################################################################

proc joingroup_disco_node_menu_setup {m bw tnode data parentdata} {
    lassign $data type connid jid node
    lassign $parentdata ptype pconnid pjid pnode
    switch -- $type {
	item {
	    set identities [disco::get_jid_identities $connid $jid $node]
	    set pidentities [disco::get_jid_identities $pconnid $pjid $pnode]

	    # JID with resource is not a room JID
	    if {[node_and_server_from_jid $jid] != $jid} return

	    if {[lempty $identities]} {
		set identities $pidentities
	    }

	    foreach id $identities {
		if {[jlib::wrapper:getattr $id category] == "conference"} {
		    $m add command -label [::msgcat::mc "Join group..."] \
			-command [list join_group_dialog \
				       -server [server_from_jid $jid] \
				       -group [node_from_jid $jid] \
				       -connection $connid]
		    break
		}
	    }
	}
    }
}

hook::add disco_node_menu_hook \
	  [namespace current]::joingroup_disco_node_menu_setup 45

###############################################################################

