/*
 * Ostatnia aktualizacja:
 *
 * - $Id: pool.h,v 1.3 2002/12/14 19:36:11 mati Exp $
 *
 */

#undef POOL_DEBUG

/* pheap - singular allocation of memory */
	struct pheap
	{
		void *block;
		int size, used;
	};

/* pool_cleaner - callback type which is associated
   with a pool entry; invoked when the pool entry is 
   free'd */
	typedef void (*pool_cleaner) (void *arg);

/* pfree - a linked list node which stores an
   allocation chunk, plus a callback */
	struct pfree
	{
		pool_cleaner f;
		void *arg;
		struct pheap *heap;
		struct pfree *next;
	};

/* pool - base node for a pool. Maintains a linked list
   of pool entries (pfree) */
	typedef struct pool_struct
	{
		int size;
		struct pfree *cleanup;
		struct pheap *heap;
#ifdef POOL_DEBUG
		char name[8], zone[32];
		int lsize;
	}
	_pool, *pool;
#define pool_new() _pool_new(ZONE)
#define pool_heap(i) _pool_new_heap(i,ZONE)
#else
	}
	_pool, *pool;
#define pool_heap(i) _pool_new_heap(i,NULL)
#define pool_new() _pool_new(NULL)
#endif

	pool _pool_new (char *zone);	/* new pool :) */
	pool _pool_new_heap (int size, char *zone);	/* creates a new memory pool with an initial heap size */
	void *pmalloc (pool p, int size);	/* wrapper around malloc, takes from the pool, cleaned up automatically */
	void *pmalloc_x (pool p, int size, char c);	/* Wrapper around pmalloc which prefils buffer with c */
	void *pmalloco (pool p, int size);	/* YAPW for zeroing the block */
	char *pstrdup (pool p, const char *src);	/* wrapper around strdup, gains mem from pool */
	void pool_stat (int full);	/* print to stderr the changed pools and reset */
	char *pstrdupx (pool p, const char *src);	/* temp stub */
	void pool_cleanup (pool p, pool_cleaner f, void *arg);	/* calls f(arg) before the pool is freed during cleanup */
	void pool_free (pool p);	/* calls the cleanup functions, frees all the data on the pool, and deletes the pool itself */
	int pool_size (pool p);	/* returns total bytes allocated in this pool */
