/* ########################################################################

		    SMAC FILE USED BY XCORAL EDITOR

   File: head.sc
   Path: /home/c/X11/xcoral-2.19/SmacLib/head.sc
   Description: 
   Created: Sun Jul 31 12:04:39 DST
   Author: Bruno Pages
   Modified: Sun Jul 31 12:04:40 DST
   Last maintained by: Lionel Fournigault

   RCS $Revision$ $State$
   
   ########################################################################

   Note: 

   ########################################################################

   Copyright (c) : Bruno Pages

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */

/* Define a new class.
   Parent classes names must be separated by `,` or spaces */

int color_region();

void cplus_class_header()
{
  char * classname = gets("Class name ? ");
  char * parent;
  int orig = current_position();
  
  if (! classname)
    return;
  if  (*classname == 7) {
    free(classname);
    return;
  }

  set_mode("C++mode");
  parent = gets("Parent classes names ? ");
  wprintf("//\n//\tClass name : %s\n//\n//\tDescription :\n//\n",
	  classname);
  wprintf("class %s", classname);
  if (parent && (*parent != 7)) {
    char * sep = " : ";
    char * first = parent;
    char * p;
    
    while (p = strtok(first, " ,")) {
      wprintf("%spublic %s", sep, p);
      first = 0;
      sep = ", ";
    }
  }
  wprintf(" {\n");
  wprintf("  public:\n\t%s();\n\t%s(const %s &);\n\t~%s();\n\t\n",
	  classname, classname, classname, classname);
  wprintf("  protected:\n  private:\n};\n\n");

  set_mark(orig);
  color_region();
  reset_mark();
  
  goto_line(current_line() - 5);
  goto_end_of_line();
  
  free(classname);
  if (parent) free(parent);
}

void java_class_header()
{
  char * classname = gets("Class name ? ");
  char * parent;
  char * interfaces;
  int orig = current_position();
  
  if (! classname)
    return;
  if  (*classname == 7) {
    free(classname);
    return;
  }
  
  set_mode("Java");

  parent = gets("Parent class name ? ");
  interfaces = gets("Implements interfaces ? ");
  wprintf("/**\n *\tClass name : %s\n *\n *\tDescription :\n *\n"
          " *\t@author\t\t\n *\t@version\t\n *\t@see\t\t\n */\n",
	  classname);
  wprintf("public class %s", classname);
  if (parent && (*parent != 7)) {
    wprintf(" extends %s", parent);
  }
  if (interfaces && (*interfaces != 7)) {
    char * sep = " implements";
    char * first = interfaces;
    char * p;
    
    while (p = strtok(first, " ,")) {
      wprintf("%s %s", sep, p);
      first = 0;
      sep = ",";
    } 
  }
  wprintf("\n{\n");
  c_indent_line();
  wprintf("\n}\n");
  
  set_mark(orig);
  color_region();
  reset_mark();
  
  goto_previous_line();
  goto_previous_line();
  goto_end_of_line();
  
  free(classname);
  if (parent) 
    free(parent);
}


/* A new C++ method */
   
void cplus_method_header()
{
  char * methodname = gets("Method name ? ");
  char * classname;
  int orig = current_position();
  
  if (! methodname)
    return;
  if  (*methodname == 7) {
    free(methodname);
    return;
  }
  
  classname = gets("Class name ? ");
  
  if (! classname) {
    free(methodname);
    return;
  }
  if (*classname == 7) {
    free(methodname);
    free(classname);
    return;
  }

  set_mode("C++mode");
  
  wprintf("//\n//\tMethod name : %s\n//\n//\tDescription :\n//\tInput :\n//\tOutput :\n//\n",
	  methodname);
  wprintf("%s::%s()\n{\n  \n}\n\n", classname, methodname);
  
  set_mark(orig);
  color_region();
  reset_mark();
  
  goto_line(current_line() - 3);
  goto_end_of_line();
  free(classname);
  free(methodname);
}

/* A new Java method */
   
void java_method_header()
{
  char * methodname = gets("Method name ? ");
  int orig = current_position();
  
  if (! methodname)
    return;
  if  (*methodname == 7) {
    free(methodname);
    return;
  }
  
  set_mode("Java");
  
  wprintf("\t/**\n\t *\tMethod name : %s\n\t *\n\t *\tDescription :\n\t *\n\t *\t@param param1\t\n"
          "\t *\t@param param2\t\n\t *\t@return\t\t\n\t *\t@exception\t\t\n\t */\n",
	  methodname);
  wprintf("\t%s()\n\t{\n\t\t\n\t}\n\n", methodname);
  
  set_mark(orig);
  color_region();
  reset_mark();
  
  goto_line(current_line() - 3);
  goto_end_of_line();
  free(methodname);
}

/* A new function */

void function_header()
{
  char * functionname = gets("Function name ? ");
  int orig = current_position();
  
  if (! functionname)
    return;
  if  (*functionname == 7) {
    free(functionname);
    return;
  }
  
  set_mode("C-mode");
  wprintf("/*\n**\tFunction name : %s\n**\n**\tDescription :\n**\tInput :\n**\tOutput :\n*/\n",
	  functionname);
  wprintf("%s()\n{\n  \n}\n\n", functionname);
  
  set_mark(orig);
  color_region();
  reset_mark();
  
  goto_line(current_line() - 3);
  goto_end_of_line();
  free(functionname);
}


/* File header, a suffixe <> .h => a c file */
void include_header()
{
  char * filepath = filename();
  char * name;
  char * ext;
  int orig = current_position();
  
  if (! filepath) return;
  
  name = strrchr(filepath, '/');
  ext = strrchr(filepath, '.');
  
  if (! name)
    name = filepath;
  else
    name += 1;
  
  if (ext) {
    *ext++ = 0;
    if (*ext == 'h') {
      wprintf("#ifndef _%s_h\n#define _%s_h\n\n\n\n#endif /* _%s_h */\n",
	      name, name, name);
      set_mark(orig);
      color_region();
      reset_mark();
      goto_line(current_line() - 2);
    }
    else {
      wprintf("#include \"%s.h\"\n", name);
      set_mark(orig);
      color_region();
      reset_mark();
    }
  }
  
  free(filepath);
}


add_header()
{
    char *str;
    int num=0;
    int win = current_window();
    
    clear_list();
    
    add_list_item("1:  C++ class");
    add_list_item("2:  C++ method");
    add_list_item("3:  C function");
    add_list_item("4:  Java class");
    add_list_item("5:  Java method");
    add_list_item("6:  Include header");
    
    str = select_from_list("Programming util");

    redisplay();
    select_window(win);
    
    num = extract_number(str);
    switch(num) {
    case 1:
      cplus_class_header();
      break;
    case 2:
      cplus_method_header();
      break;
    case 3:
      function_header();
      break;
    case 4:
      java_class_header();
      break;
    case 5:
      java_method_header();
      break;
    case 6:
      include_header();
      break;
    default:
      break;
    }
}
